/*
 * Copyright (c) 2020, The Moves Institute
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * * Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package edu.nps.moves.disutil;

import edu.nps.moves.dis.Pdu;

/**
 * For non-standard experimental pdu's of pdu type 129..255.
 *
 * This class allows the PduFactory to parse the pdu header.
 *
 * @author Leif
 */
public class ExperimentalPdu extends Pdu {

    protected byte[] body; // The body is of unknown contents for non-standard pdu's. It will be exposed as a byte array for the end user to interpret.

    public byte[] getBody() {
        return body;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    @Override
    public void setPduLength(int pPduLength) {
        super.setPduLength(pPduLength);
        body = new byte[pPduLength - super.getMarshalledSize()];
    }

    @Override
    public int getMarshalledSize() {
        return super.getMarshalledSize() + body.length;
    }

    @Override
    public void marshal(java.nio.ByteBuffer buff) {
        super.marshal(buff);

        buff.put(body);
    }

    @Override
    public void unmarshal(java.nio.ByteBuffer buff) {
        super.unmarshal(buff);

        // abutler - The body is now initialized in the setPduLength() call
        // body = new byte[this.getPduLength() - 12]; // 12 is size of the pdu header.
        buff.get(body);
    }
}
