/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis;

import edu.nps.moves.dis.FixedDatum;
import edu.nps.moves.dis.SimulationManagementWithReliabilityFamilyPdu;
import edu.nps.moves.dis.VariableDatum;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class ActionResponseReliablePdu
extends SimulationManagementWithReliabilityFamilyPdu
implements Serializable {
    protected long requestID;
    protected long responseStatus;
    protected long numberOfFixedDatumRecords;
    protected long numberOfVariableDatumRecords;
    protected List<FixedDatum> fixedDatumRecords = new ArrayList<FixedDatum>();
    protected List<VariableDatum> variableDatumRecords = new ArrayList<VariableDatum>();

    public ActionResponseReliablePdu() {
        this.setPduType((short)57);
    }

    @Override
    public int getMarshalledSize() {
        Serializable listElement;
        int idx;
        int marshalSize = 0;
        marshalSize = super.getMarshalledSize();
        marshalSize += 4;
        marshalSize += 4;
        marshalSize += 4;
        marshalSize += 4;
        for (idx = 0; idx < this.fixedDatumRecords.size(); ++idx) {
            listElement = this.fixedDatumRecords.get(idx);
            marshalSize += ((FixedDatum)listElement).getMarshalledSize();
        }
        for (idx = 0; idx < this.variableDatumRecords.size(); ++idx) {
            listElement = this.variableDatumRecords.get(idx);
            marshalSize += ((VariableDatum)listElement).getMarshalledSize();
        }
        return marshalSize;
    }

    public void setRequestID(long pRequestID) {
        this.requestID = pRequestID;
    }

    public long getRequestID() {
        return this.requestID;
    }

    public void setResponseStatus(long pResponseStatus) {
        this.responseStatus = pResponseStatus;
    }

    public long getResponseStatus() {
        return this.responseStatus;
    }

    public long getNumberOfFixedDatumRecords() {
        return this.fixedDatumRecords.size();
    }

    public void setNumberOfFixedDatumRecords(long pNumberOfFixedDatumRecords) {
        this.numberOfFixedDatumRecords = pNumberOfFixedDatumRecords;
    }

    public long getNumberOfVariableDatumRecords() {
        return this.variableDatumRecords.size();
    }

    public void setNumberOfVariableDatumRecords(long pNumberOfVariableDatumRecords) {
        this.numberOfVariableDatumRecords = pNumberOfVariableDatumRecords;
    }

    public void setFixedDatumRecords(List<FixedDatum> pFixedDatumRecords) {
        this.fixedDatumRecords = pFixedDatumRecords;
    }

    public List<FixedDatum> getFixedDatumRecords() {
        return this.fixedDatumRecords;
    }

    public void setVariableDatumRecords(List<VariableDatum> pVariableDatumRecords) {
        this.variableDatumRecords = pVariableDatumRecords;
    }

    public List<VariableDatum> getVariableDatumRecords() {
        return this.variableDatumRecords;
    }

    @Override
    public void marshal(ByteBuffer buff) {
        int idx;
        super.marshal(buff);
        buff.putInt((int)this.requestID);
        buff.putInt((int)this.responseStatus);
        buff.putInt(this.fixedDatumRecords.size());
        buff.putInt(this.variableDatumRecords.size());
        for (idx = 0; idx < this.fixedDatumRecords.size(); ++idx) {
            FixedDatum aFixedDatum = this.fixedDatumRecords.get(idx);
            aFixedDatum.marshal(buff);
        }
        for (idx = 0; idx < this.variableDatumRecords.size(); ++idx) {
            VariableDatum aVariableDatum = this.variableDatumRecords.get(idx);
            aVariableDatum.marshal(buff);
        }
    }

    @Override
    public void unmarshal(ByteBuffer buff) {
        Serializable anX;
        super.unmarshal(buff);
        this.requestID = buff.getInt();
        this.responseStatus = buff.getInt();
        this.numberOfFixedDatumRecords = buff.getInt();
        this.numberOfVariableDatumRecords = buff.getInt();
        int idx = 0;
        while ((long)idx < this.numberOfFixedDatumRecords) {
            anX = new FixedDatum();
            ((FixedDatum)anX).unmarshal(buff);
            this.fixedDatumRecords.add((FixedDatum)anX);
            ++idx;
        }
        idx = 0;
        while ((long)idx < this.numberOfVariableDatumRecords) {
            anX = new VariableDatum();
            ((VariableDatum)anX).unmarshal(buff);
            this.variableDatumRecords.add((VariableDatum)anX);
            ++idx;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        int idx;
        boolean ivarsEqual = true;
        if (!(obj instanceof ActionResponseReliablePdu)) {
            return false;
        }
        ActionResponseReliablePdu rhs = (ActionResponseReliablePdu)obj;
        if (this.requestID != rhs.requestID) {
            ivarsEqual = false;
        }
        if (this.responseStatus != rhs.responseStatus) {
            ivarsEqual = false;
        }
        if (this.numberOfFixedDatumRecords != rhs.numberOfFixedDatumRecords) {
            ivarsEqual = false;
        }
        if (this.numberOfVariableDatumRecords != rhs.numberOfVariableDatumRecords) {
            ivarsEqual = false;
        }
        for (idx = 0; idx < this.fixedDatumRecords.size(); ++idx) {
            if (this.fixedDatumRecords.get(idx).equals(rhs.fixedDatumRecords.get(idx))) continue;
            ivarsEqual = false;
        }
        for (idx = 0; idx < this.variableDatumRecords.size(); ++idx) {
            if (this.variableDatumRecords.get(idx).equals(rhs.variableDatumRecords.get(idx))) continue;
            ivarsEqual = false;
        }
        return ivarsEqual && super.equalsImpl(rhs);
    }
}

