/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis;

import edu.nps.moves.dis.AggregateID;
import edu.nps.moves.dis.AggregateMarking;
import edu.nps.moves.dis.EntityID;
import edu.nps.moves.dis.EntityManagementFamilyPdu;
import edu.nps.moves.dis.EntityType;
import edu.nps.moves.dis.Orientation;
import edu.nps.moves.dis.SilentAggregateSystem;
import edu.nps.moves.dis.SilentEntitySystem;
import edu.nps.moves.dis.VariableDatum;
import edu.nps.moves.dis.Vector3Double;
import edu.nps.moves.dis.Vector3Float;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class AggregateStatePdu
extends EntityManagementFamilyPdu
implements Serializable {
    protected EntityID aggregateID = new EntityID();
    protected short forceID;
    protected short aggregateState;
    protected EntityType aggregateType = new EntityType();
    protected long formation;
    protected AggregateMarking aggregateMarking = new AggregateMarking();
    protected Vector3Float dimensions = new Vector3Float();
    protected Orientation orientation = new Orientation();
    protected Vector3Double centerOfMass = new Vector3Double();
    protected Vector3Float velocity = new Vector3Float();
    protected int numberOfDisAggregates;
    protected int numberOfDisEntities;
    protected int numberOfSilentAggregateTypes;
    protected int numberOfSilentEntityTypes;
    protected List<AggregateID> aggregateIDList = new ArrayList<AggregateID>();
    protected List<EntityID> entityIDList = new ArrayList<EntityID>();
    protected short pad2;
    protected List<SilentAggregateSystem> silentAggregateSystemList = new ArrayList<SilentAggregateSystem>();
    protected List<SilentEntitySystem> silentEntitySystemList = new ArrayList<SilentEntitySystem>();
    protected long numberOfVariableDatumRecords;
    protected List<VariableDatum> variableDatumList = new ArrayList<VariableDatum>();

    public AggregateStatePdu() {
        this.setPduType((short)33);
    }

    @Override
    public int getMarshalledSize() {
        Object listElement;
        int idx;
        int marshalSize = 0;
        marshalSize = super.getMarshalledSize();
        marshalSize += this.aggregateID.getMarshalledSize();
        ++marshalSize;
        ++marshalSize;
        marshalSize += this.aggregateType.getMarshalledSize();
        marshalSize += 4;
        marshalSize += this.aggregateMarking.getMarshalledSize();
        marshalSize += this.dimensions.getMarshalledSize();
        marshalSize += this.orientation.getMarshalledSize();
        marshalSize += this.centerOfMass.getMarshalledSize();
        marshalSize += this.velocity.getMarshalledSize();
        marshalSize += 2;
        marshalSize += 2;
        marshalSize += 2;
        marshalSize += 2;
        for (idx = 0; idx < this.aggregateIDList.size(); ++idx) {
            listElement = this.aggregateIDList.get(idx);
            marshalSize += ((AggregateID)listElement).getMarshalledSize();
        }
        for (idx = 0; idx < this.entityIDList.size(); ++idx) {
            listElement = this.entityIDList.get(idx);
            marshalSize += ((EntityID)listElement).getMarshalledSize();
        }
        marshalSize += this.getPad2Bits() / 8;
        for (idx = 0; idx < this.silentAggregateSystemList.size(); ++idx) {
            listElement = this.silentAggregateSystemList.get(idx);
            marshalSize += ((SilentAggregateSystem)listElement).getMarshalledSize();
        }
        for (idx = 0; idx < this.silentEntitySystemList.size(); ++idx) {
            listElement = this.silentEntitySystemList.get(idx);
            marshalSize += ((SilentEntitySystem)listElement).getMarshalledSize();
        }
        marshalSize += 4;
        for (idx = 0; idx < this.variableDatumList.size(); ++idx) {
            listElement = this.variableDatumList.get(idx);
            marshalSize += ((VariableDatum)listElement).getMarshalledSize();
        }
        return marshalSize;
    }

    public void setAggregateID(EntityID pAggregateID) {
        this.aggregateID = pAggregateID;
    }

    public EntityID getAggregateID() {
        return this.aggregateID;
    }

    public void setForceID(short pForceID) {
        this.forceID = pForceID;
    }

    public short getForceID() {
        return this.forceID;
    }

    public void setAggregateState(short pAggregateState) {
        this.aggregateState = pAggregateState;
    }

    public short getAggregateState() {
        return this.aggregateState;
    }

    public void setAggregateType(EntityType pAggregateType) {
        this.aggregateType = pAggregateType;
    }

    public EntityType getAggregateType() {
        return this.aggregateType;
    }

    public void setFormation(long pFormation) {
        this.formation = pFormation;
    }

    public long getFormation() {
        return this.formation;
    }

    public void setAggregateMarking(AggregateMarking pAggregateMarking) {
        this.aggregateMarking = pAggregateMarking;
    }

    public AggregateMarking getAggregateMarking() {
        return this.aggregateMarking;
    }

    public void setDimensions(Vector3Float pDimensions) {
        this.dimensions = pDimensions;
    }

    public Vector3Float getDimensions() {
        return this.dimensions;
    }

    public void setOrientation(Orientation pOrientation) {
        this.orientation = pOrientation;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setCenterOfMass(Vector3Double pCenterOfMass) {
        this.centerOfMass = pCenterOfMass;
    }

    public Vector3Double getCenterOfMass() {
        return this.centerOfMass;
    }

    public void setVelocity(Vector3Float pVelocity) {
        this.velocity = pVelocity;
    }

    public Vector3Float getVelocity() {
        return this.velocity;
    }

    public int getNumberOfDisAggregates() {
        return this.aggregateIDList.size();
    }

    public void setNumberOfDisAggregates(int pNumberOfDisAggregates) {
        this.numberOfDisAggregates = pNumberOfDisAggregates;
    }

    public int getNumberOfDisEntities() {
        return this.entityIDList.size();
    }

    public void setNumberOfDisEntities(int pNumberOfDisEntities) {
        this.numberOfDisEntities = pNumberOfDisEntities;
    }

    public int getNumberOfSilentAggregateTypes() {
        return this.silentAggregateSystemList.size();
    }

    public void setNumberOfSilentAggregateTypes(int pNumberOfSilentAggregateTypes) {
        this.numberOfSilentAggregateTypes = pNumberOfSilentAggregateTypes;
    }

    public int getNumberOfSilentEntityTypes() {
        return this.silentEntitySystemList.size();
    }

    public void setNumberOfSilentEntityTypes(int pNumberOfSilentEntityTypes) {
        this.numberOfSilentEntityTypes = pNumberOfSilentEntityTypes;
    }

    public void setAggregateIDList(List<AggregateID> pAggregateIDList) {
        this.aggregateIDList = pAggregateIDList;
    }

    public List<AggregateID> getAggregateIDList() {
        return this.aggregateIDList;
    }

    public void setEntityIDList(List<EntityID> pEntityIDList) {
        this.entityIDList = pEntityIDList;
    }

    public List<EntityID> getEntityIDList() {
        return this.entityIDList;
    }

    public void setPad2(short pPad2) {
        this.pad2 = pPad2;
    }

    public short getPad2() {
        return this.pad2;
    }

    public short getPad2Bits() {
        int val = 16 * ((this.aggregateIDList.size() + this.entityIDList.size()) % 2);
        return (short)val;
    }

    public void setSilentAggregateSystemList(List<SilentAggregateSystem> pSilentAggregateSystemList) {
        this.silentAggregateSystemList = pSilentAggregateSystemList;
    }

    public List<SilentAggregateSystem> getSilentAggregateSystemList() {
        return this.silentAggregateSystemList;
    }

    public void setSilentEntitySystemList(List<SilentEntitySystem> pSilentEntitySystemList) {
        this.silentEntitySystemList = pSilentEntitySystemList;
    }

    public List<SilentEntitySystem> getSilentEntitySystemList() {
        return this.silentEntitySystemList;
    }

    public long getNumberOfVariableDatumRecords() {
        return this.variableDatumList.size();
    }

    public void setNumberOfVariableDatumRecords(long pNumberOfVariableDatumRecords) {
        this.numberOfVariableDatumRecords = pNumberOfVariableDatumRecords;
    }

    public void setVariableDatumList(List<VariableDatum> pVariableDatumList) {
        this.variableDatumList = pVariableDatumList;
    }

    public List<VariableDatum> getVariableDatumList() {
        return this.variableDatumList;
    }

    @Override
    public void marshal(ByteBuffer buff) {
        int idx;
        super.marshal(buff);
        this.aggregateID.marshal(buff);
        buff.put((byte)this.forceID);
        buff.put((byte)this.aggregateState);
        this.aggregateType.marshal(buff);
        buff.putInt((int)this.formation);
        this.aggregateMarking.marshal(buff);
        this.dimensions.marshal(buff);
        this.orientation.marshal(buff);
        this.centerOfMass.marshal(buff);
        this.velocity.marshal(buff);
        buff.putShort((short)this.aggregateIDList.size());
        buff.putShort((short)this.entityIDList.size());
        buff.putShort((short)this.silentAggregateSystemList.size());
        buff.putShort((short)this.silentEntitySystemList.size());
        for (idx = 0; idx < this.aggregateIDList.size(); ++idx) {
            AggregateID aAggregateID = this.aggregateIDList.get(idx);
            aAggregateID.marshal(buff);
        }
        for (idx = 0; idx < this.entityIDList.size(); ++idx) {
            EntityID aEntityID = this.entityIDList.get(idx);
            aEntityID.marshal(buff);
        }
        if (this.getPad2Bits() / 8 == 2) {
            buff.putShort(this.pad2);
        }
        for (idx = 0; idx < this.silentAggregateSystemList.size(); ++idx) {
            SilentAggregateSystem aSilentAggregateSystem = this.silentAggregateSystemList.get(idx);
            aSilentAggregateSystem.marshal(buff);
        }
        for (idx = 0; idx < this.silentEntitySystemList.size(); ++idx) {
            SilentEntitySystem aSilentEntitySystem = this.silentEntitySystemList.get(idx);
            aSilentEntitySystem.marshal(buff);
        }
        buff.putInt(this.variableDatumList.size());
        for (idx = 0; idx < this.variableDatumList.size(); ++idx) {
            VariableDatum aVariableDatum = this.variableDatumList.get(idx);
            aVariableDatum.marshal(buff);
        }
    }

    @Override
    public void unmarshal(ByteBuffer buff) {
        Object anX;
        int idx;
        Serializable anX2;
        int idx2;
        super.unmarshal(buff);
        this.aggregateID.unmarshal(buff);
        this.forceID = (short)(buff.get() & 0xFF);
        this.aggregateState = (short)(buff.get() & 0xFF);
        this.aggregateType.unmarshal(buff);
        this.formation = buff.getInt();
        this.aggregateMarking.unmarshal(buff);
        this.dimensions.unmarshal(buff);
        this.orientation.unmarshal(buff);
        this.centerOfMass.unmarshal(buff);
        this.velocity.unmarshal(buff);
        this.numberOfDisAggregates = buff.getShort() & 0xFFFF;
        this.numberOfDisEntities = buff.getShort() & 0xFFFF;
        this.numberOfSilentAggregateTypes = buff.getShort() & 0xFFFF;
        this.numberOfSilentEntityTypes = buff.getShort() & 0xFFFF;
        for (idx2 = 0; idx2 < this.numberOfDisAggregates; ++idx2) {
            anX2 = new AggregateID();
            ((AggregateID)anX2).unmarshal(buff);
            this.aggregateIDList.add((AggregateID)anX2);
        }
        for (idx2 = 0; idx2 < this.numberOfDisEntities; ++idx2) {
            anX2 = new EntityID();
            ((EntityID)anX2).unmarshal(buff);
            this.entityIDList.add((EntityID)anX2);
        }
        int padBits = 16 * ((this.numberOfDisAggregates + this.numberOfDisEntities) % 2);
        if (padBits / 8 == 2) {
            this.pad2 = buff.getShort();
        }
        for (idx = 0; idx < this.numberOfSilentAggregateTypes; ++idx) {
            anX = new SilentAggregateSystem();
            ((SilentAggregateSystem)anX).unmarshal(buff);
            this.silentAggregateSystemList.add((SilentAggregateSystem)anX);
        }
        for (idx = 0; idx < this.numberOfSilentEntityTypes; ++idx) {
            anX = new SilentEntitySystem();
            ((SilentEntitySystem)anX).unmarshal(buff);
            this.silentEntitySystemList.add((SilentEntitySystem)anX);
        }
        this.numberOfVariableDatumRecords = buff.getInt();
        idx = 0;
        while ((long)idx < this.numberOfVariableDatumRecords) {
            anX = new VariableDatum();
            ((VariableDatum)anX).unmarshal(buff);
            this.variableDatumList.add((VariableDatum)anX);
            ++idx;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        int idx;
        boolean ivarsEqual = true;
        if (!(obj instanceof AggregateStatePdu)) {
            return false;
        }
        AggregateStatePdu rhs = (AggregateStatePdu)obj;
        if (!this.aggregateID.equals(rhs.aggregateID)) {
            ivarsEqual = false;
        }
        if (this.forceID != rhs.forceID) {
            ivarsEqual = false;
        }
        if (this.aggregateState != rhs.aggregateState) {
            ivarsEqual = false;
        }
        if (!this.aggregateType.equals(rhs.aggregateType)) {
            ivarsEqual = false;
        }
        if (this.formation != rhs.formation) {
            ivarsEqual = false;
        }
        if (!this.aggregateMarking.equals(rhs.aggregateMarking)) {
            ivarsEqual = false;
        }
        if (!this.dimensions.equals(rhs.dimensions)) {
            ivarsEqual = false;
        }
        if (!this.orientation.equals(rhs.orientation)) {
            ivarsEqual = false;
        }
        if (!this.centerOfMass.equals(rhs.centerOfMass)) {
            ivarsEqual = false;
        }
        if (!this.velocity.equals(rhs.velocity)) {
            ivarsEqual = false;
        }
        if (this.numberOfDisAggregates != rhs.numberOfDisAggregates) {
            ivarsEqual = false;
        }
        if (this.numberOfDisEntities != rhs.numberOfDisEntities) {
            ivarsEqual = false;
        }
        if (this.numberOfSilentAggregateTypes != rhs.numberOfSilentAggregateTypes) {
            ivarsEqual = false;
        }
        if (this.numberOfSilentEntityTypes != rhs.numberOfSilentEntityTypes) {
            ivarsEqual = false;
        }
        for (idx = 0; idx < this.aggregateIDList.size(); ++idx) {
            if (this.aggregateIDList.get(idx).equals(rhs.aggregateIDList.get(idx))) continue;
            ivarsEqual = false;
        }
        for (idx = 0; idx < this.entityIDList.size(); ++idx) {
            if (this.entityIDList.get(idx).equals(rhs.entityIDList.get(idx))) continue;
            ivarsEqual = false;
        }
        if (this.pad2 != rhs.pad2) {
            ivarsEqual = false;
        }
        for (idx = 0; idx < this.silentAggregateSystemList.size(); ++idx) {
            if (this.silentAggregateSystemList.get(idx).equals(rhs.silentAggregateSystemList.get(idx))) continue;
            ivarsEqual = false;
        }
        for (idx = 0; idx < this.silentEntitySystemList.size(); ++idx) {
            if (this.silentEntitySystemList.get(idx).equals(rhs.silentEntitySystemList.get(idx))) continue;
            ivarsEqual = false;
        }
        if (this.numberOfVariableDatumRecords != rhs.numberOfVariableDatumRecords) {
            ivarsEqual = false;
        }
        for (idx = 0; idx < this.variableDatumList.size(); ++idx) {
            if (this.variableDatumList.get(idx).equals(rhs.variableDatumList.get(idx))) continue;
            ivarsEqual = false;
        }
        return ivarsEqual && super.equalsImpl(rhs);
    }
}

