/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis;

import edu.nps.moves.dis.Orientation;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class BeamAntennaPattern
implements Serializable {
    protected Orientation beamDirection = new Orientation();
    protected float azimuthBeamwidth = 0.0f;
    protected float elevationBeamwidth = 0.0f;
    protected byte referenceSystem = 0;
    protected short padding1 = 0;
    protected byte padding2 = 0;
    protected float ez;
    protected float ex;
    protected float phase;

    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize += this.beamDirection.getMarshalledSize();
        marshalSize += 4;
        marshalSize += 4;
        ++marshalSize;
        marshalSize += 2;
        ++marshalSize;
        marshalSize += 4;
        marshalSize += 4;
        return marshalSize += 4;
    }

    public void setBeamDirection(Orientation pBeamDirection) {
        this.beamDirection = pBeamDirection;
    }

    public Orientation getBeamDirection() {
        return this.beamDirection;
    }

    public void setAzimuthBeamwidth(float pAzimuthBeamwidth) {
        this.azimuthBeamwidth = pAzimuthBeamwidth;
    }

    public float getAzimuthBeamwidth() {
        return this.azimuthBeamwidth;
    }

    public void setElevationBeamwidth(float pElevationBeamwidth) {
        this.elevationBeamwidth = pElevationBeamwidth;
    }

    public float getElevationBeamwidth() {
        return this.elevationBeamwidth;
    }

    public void setReferenceSystem(byte pReferenceSystem) {
        this.referenceSystem = pReferenceSystem;
    }

    public byte getReferenceSystem() {
        return this.referenceSystem;
    }

    public void setPadding1(short pPadding1) {
        this.padding1 = pPadding1;
    }

    public short getPadding1() {
        return this.padding1;
    }

    public void setPadding2(byte pPadding2) {
        this.padding2 = pPadding2;
    }

    public byte getPadding2() {
        return this.padding2;
    }

    public void setEz(float pEz) {
        this.ez = pEz;
    }

    public float getEz() {
        return this.ez;
    }

    public void setEx(float pEx) {
        this.ex = pEx;
    }

    public float getEx() {
        return this.ex;
    }

    public void setPhase(float pPhase) {
        this.phase = pPhase;
    }

    public float getPhase() {
        return this.phase;
    }

    public void marshal(ByteBuffer buff) {
        this.beamDirection.marshal(buff);
        buff.putFloat(this.azimuthBeamwidth);
        buff.putFloat(this.elevationBeamwidth);
        buff.put(this.referenceSystem);
        buff.putShort(this.padding1);
        buff.put(this.padding2);
        buff.putFloat(this.ez);
        buff.putFloat(this.ex);
        buff.putFloat(this.phase);
    }

    public void unmarshal(ByteBuffer buff) {
        this.beamDirection.unmarshal(buff);
        this.azimuthBeamwidth = buff.getFloat();
        this.elevationBeamwidth = buff.getFloat();
        this.referenceSystem = buff.get();
        this.padding1 = buff.getShort();
        this.padding2 = buff.get();
        this.ez = buff.getFloat();
        this.ex = buff.getFloat();
        this.phase = buff.getFloat();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof BeamAntennaPattern)) {
            return false;
        }
        BeamAntennaPattern rhs = (BeamAntennaPattern)obj;
        if (!this.beamDirection.equals(rhs.beamDirection)) {
            ivarsEqual = false;
        }
        if (this.azimuthBeamwidth != rhs.azimuthBeamwidth) {
            ivarsEqual = false;
        }
        if (this.elevationBeamwidth != rhs.elevationBeamwidth) {
            ivarsEqual = false;
        }
        if (this.referenceSystem != rhs.referenceSystem) {
            ivarsEqual = false;
        }
        if (this.padding1 != rhs.padding1) {
            ivarsEqual = false;
        }
        if (this.padding2 != rhs.padding2) {
            ivarsEqual = false;
        }
        if (this.ez != rhs.ez) {
            ivarsEqual = false;
        }
        if (this.ex != rhs.ex) {
            ivarsEqual = false;
        }
        if (this.phase != rhs.phase) {
            ivarsEqual = false;
        }
        return ivarsEqual;
    }
}

