/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis;

import edu.nps.moves.dis.ArticulationParameter;
import edu.nps.moves.dis.DeadReckoningParameter;
import edu.nps.moves.dis.EntityID;
import edu.nps.moves.dis.EntityInformationFamilyPdu;
import edu.nps.moves.dis.EntityType;
import edu.nps.moves.dis.Marking;
import edu.nps.moves.dis.Orientation;
import edu.nps.moves.dis.Vector3Double;
import edu.nps.moves.dis.Vector3Float;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class EntityStatePdu
extends EntityInformationFamilyPdu
implements Serializable {
    protected EntityID entityID = new EntityID();
    protected short forceId;
    protected byte numberOfArticulationParameters;
    protected EntityType entityType = new EntityType();
    protected EntityType alternativeEntityType = new EntityType();
    protected Vector3Float entityLinearVelocity = new Vector3Float();
    protected Vector3Double entityLocation = new Vector3Double();
    protected Orientation entityOrientation = new Orientation();
    protected int entityAppearance;
    protected DeadReckoningParameter deadReckoningParameters = new DeadReckoningParameter();
    protected Marking marking = new Marking();
    protected int capabilities;
    protected List<ArticulationParameter> articulationParameters = new ArrayList<ArticulationParameter>();

    public EntityStatePdu() {
        this.setPduType((short)1);
    }

    @Override
    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize = super.getMarshalledSize();
        marshalSize += this.entityID.getMarshalledSize();
        ++marshalSize;
        ++marshalSize;
        marshalSize += this.entityType.getMarshalledSize();
        marshalSize += this.alternativeEntityType.getMarshalledSize();
        marshalSize += this.entityLinearVelocity.getMarshalledSize();
        marshalSize += this.entityLocation.getMarshalledSize();
        marshalSize += this.entityOrientation.getMarshalledSize();
        marshalSize += 4;
        marshalSize += this.deadReckoningParameters.getMarshalledSize();
        marshalSize += this.marking.getMarshalledSize();
        marshalSize += 4;
        for (int idx = 0; idx < this.articulationParameters.size(); ++idx) {
            ArticulationParameter listElement = this.articulationParameters.get(idx);
            marshalSize += listElement.getMarshalledSize();
        }
        return marshalSize;
    }

    public void setEntityID(EntityID pEntityID) {
        this.entityID = pEntityID;
    }

    public EntityID getEntityID() {
        return this.entityID;
    }

    public void setForceId(short pForceId) {
        this.forceId = pForceId;
    }

    public short getForceId() {
        return this.forceId;
    }

    public byte getNumberOfArticulationParameters() {
        return (byte)this.articulationParameters.size();
    }

    public void setNumberOfArticulationParameters(byte pNumberOfArticulationParameters) {
        this.numberOfArticulationParameters = pNumberOfArticulationParameters;
    }

    public void setEntityType(EntityType pEntityType) {
        this.entityType = pEntityType;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public void setAlternativeEntityType(EntityType pAlternativeEntityType) {
        this.alternativeEntityType = pAlternativeEntityType;
    }

    public EntityType getAlternativeEntityType() {
        return this.alternativeEntityType;
    }

    public void setEntityLinearVelocity(Vector3Float pEntityLinearVelocity) {
        this.entityLinearVelocity = pEntityLinearVelocity;
    }

    public Vector3Float getEntityLinearVelocity() {
        return this.entityLinearVelocity;
    }

    public void setEntityLocation(Vector3Double pEntityLocation) {
        this.entityLocation = pEntityLocation;
    }

    public Vector3Double getEntityLocation() {
        return this.entityLocation;
    }

    public void setEntityOrientation(Orientation pEntityOrientation) {
        this.entityOrientation = pEntityOrientation;
    }

    public Orientation getEntityOrientation() {
        return this.entityOrientation;
    }

    public void setEntityAppearance(int pEntityAppearance) {
        this.entityAppearance = pEntityAppearance;
    }

    public int getEntityAppearance() {
        return this.entityAppearance;
    }

    public void setDeadReckoningParameters(DeadReckoningParameter pDeadReckoningParameters) {
        this.deadReckoningParameters = pDeadReckoningParameters;
    }

    public DeadReckoningParameter getDeadReckoningParameters() {
        return this.deadReckoningParameters;
    }

    public void setMarking(Marking pMarking) {
        this.marking = pMarking;
    }

    public Marking getMarking() {
        return this.marking;
    }

    public void setCapabilities(int pCapabilities) {
        this.capabilities = pCapabilities;
    }

    public int getCapabilities() {
        return this.capabilities;
    }

    public void setArticulationParameters(List<ArticulationParameter> pArticulationParameters) {
        this.articulationParameters = pArticulationParameters;
    }

    public List<ArticulationParameter> getArticulationParameters() {
        return this.articulationParameters;
    }

    public int getEntityAppearance_paintScheme() {
        int val = this.entityAppearance & 1;
        return val >> 0;
    }

    public void setEntityAppearance_paintScheme(int val) {
        int aVal = 0;
        this.entityAppearance &= 0xFFFFFFFE;
        aVal = val << 0;
        this.entityAppearance |= aVal;
    }

    public int getEntityAppearance_mobility() {
        int val = this.entityAppearance & 2;
        return val >> 1;
    }

    public void setEntityAppearance_mobility(int val) {
        int aVal = 0;
        this.entityAppearance &= 0xFFFFFFFD;
        aVal = val << 1;
        this.entityAppearance |= aVal;
    }

    public int getEntityAppearance_firepower() {
        int val = this.entityAppearance & 4;
        return val >> 2;
    }

    public void setEntityAppearance_firepower(int val) {
        int aVal = 0;
        this.entityAppearance &= 0xFFFFFFFB;
        aVal = val << 2;
        this.entityAppearance |= aVal;
    }

    public int getEntityAppearance_damage() {
        int val = this.entityAppearance & 0x18;
        return val >> 3;
    }

    public void setEntityAppearance_damage(int val) {
        int aVal = 0;
        this.entityAppearance &= 0xFFFFFFE7;
        aVal = val << 3;
        this.entityAppearance |= aVal;
    }

    public int getEntityAppearance_smoke() {
        int val = this.entityAppearance & 0x60;
        return val >> 5;
    }

    public void setEntityAppearance_smoke(int val) {
        int aVal = 0;
        this.entityAppearance &= 0xFFFFFF9F;
        aVal = val << 5;
        this.entityAppearance |= aVal;
    }

    public int getEntityAppearance_trailingEffects() {
        int val = this.entityAppearance & 0x180;
        return val >> 7;
    }

    public void setEntityAppearance_trailingEffects(int val) {
        int aVal = 0;
        this.entityAppearance &= 0xFFFFFE7F;
        aVal = val << 7;
        this.entityAppearance |= aVal;
    }

    public int getEntityAppearance_hatch() {
        int val = this.entityAppearance & 0xE00;
        return val >> 9;
    }

    public void setEntityAppearance_hatch(int val) {
        int aVal = 0;
        this.entityAppearance &= 0xFFFFF1FF;
        aVal = val << 9;
        this.entityAppearance |= aVal;
    }

    public int getEntityAppearance_headlights() {
        int val = this.entityAppearance & 0x1000;
        return val >> 12;
    }

    public void setEntityAppearance_headlights(int val) {
        int aVal = 0;
        this.entityAppearance &= 0xFFFFEFFF;
        aVal = val << 12;
        this.entityAppearance |= aVal;
    }

    public int getEntityAppearance_tailLights() {
        int val = this.entityAppearance & 0x2000;
        return val >> 13;
    }

    public void setEntityAppearance_tailLights(int val) {
        int aVal = 0;
        this.entityAppearance &= 0xFFFFDFFF;
        aVal = val << 13;
        this.entityAppearance |= aVal;
    }

    public int getEntityAppearance_brakeLights() {
        int val = this.entityAppearance & 0x4000;
        return val >> 14;
    }

    public void setEntityAppearance_brakeLights(int val) {
        int aVal = 0;
        this.entityAppearance &= 0xFFFFBFFF;
        aVal = val << 14;
        this.entityAppearance |= aVal;
    }

    public int getEntityAppearance_flaming() {
        int val = this.entityAppearance & 0x8000;
        return val >> 15;
    }

    public void setEntityAppearance_flaming(int val) {
        int aVal = 0;
        this.entityAppearance &= 0xFFFF7FFF;
        aVal = val << 15;
        this.entityAppearance |= aVal;
    }

    public int getEntityAppearance_launcher() {
        int val = this.entityAppearance & 0x10000;
        return val >> 16;
    }

    public void setEntityAppearance_launcher(int val) {
        int aVal = 0;
        this.entityAppearance &= 0xFFFEFFFF;
        aVal = val << 16;
        this.entityAppearance |= aVal;
    }

    public int getEntityAppearance_camouflageType() {
        int val = this.entityAppearance & 0x60000;
        return val >> 17;
    }

    public void setEntityAppearance_camouflageType(int val) {
        int aVal = 0;
        this.entityAppearance &= 0xFFF9FFFF;
        aVal = val << 17;
        this.entityAppearance |= aVal;
    }

    @Override
    public void marshal(ByteBuffer buff) {
        super.marshal(buff);
        this.entityID.marshal(buff);
        buff.put((byte)this.forceId);
        buff.put((byte)this.articulationParameters.size());
        this.entityType.marshal(buff);
        this.alternativeEntityType.marshal(buff);
        this.entityLinearVelocity.marshal(buff);
        this.entityLocation.marshal(buff);
        this.entityOrientation.marshal(buff);
        buff.putInt(this.entityAppearance);
        this.deadReckoningParameters.marshal(buff);
        this.marking.marshal(buff);
        buff.putInt(this.capabilities);
        for (int idx = 0; idx < this.articulationParameters.size(); ++idx) {
            ArticulationParameter aArticulationParameter = this.articulationParameters.get(idx);
            aArticulationParameter.marshal(buff);
        }
    }

    @Override
    public void unmarshal(ByteBuffer buff) {
        super.unmarshal(buff);
        this.entityID.unmarshal(buff);
        this.forceId = (short)(buff.get() & 0xFF);
        this.numberOfArticulationParameters = buff.get();
        this.entityType.unmarshal(buff);
        this.alternativeEntityType.unmarshal(buff);
        this.entityLinearVelocity.unmarshal(buff);
        this.entityLocation.unmarshal(buff);
        this.entityOrientation.unmarshal(buff);
        this.entityAppearance = buff.getInt();
        this.deadReckoningParameters.unmarshal(buff);
        this.marking.unmarshal(buff);
        this.capabilities = buff.getInt();
        for (int idx = 0; idx < this.numberOfArticulationParameters; ++idx) {
            ArticulationParameter anX = new ArticulationParameter();
            anX.unmarshal(buff);
            this.articulationParameters.add(anX);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof EntityStatePdu)) {
            return false;
        }
        EntityStatePdu rhs = (EntityStatePdu)obj;
        if (!this.entityID.equals(rhs.entityID)) {
            ivarsEqual = false;
        }
        if (this.forceId != rhs.forceId) {
            ivarsEqual = false;
        }
        if (this.numberOfArticulationParameters != rhs.numberOfArticulationParameters) {
            ivarsEqual = false;
        }
        if (!this.entityType.equals(rhs.entityType)) {
            ivarsEqual = false;
        }
        if (!this.alternativeEntityType.equals(rhs.alternativeEntityType)) {
            ivarsEqual = false;
        }
        if (!this.entityLinearVelocity.equals(rhs.entityLinearVelocity)) {
            ivarsEqual = false;
        }
        if (!this.entityLocation.equals(rhs.entityLocation)) {
            ivarsEqual = false;
        }
        if (!this.entityOrientation.equals(rhs.entityOrientation)) {
            ivarsEqual = false;
        }
        if (this.entityAppearance != rhs.entityAppearance) {
            ivarsEqual = false;
        }
        if (!this.deadReckoningParameters.equals(rhs.deadReckoningParameters)) {
            ivarsEqual = false;
        }
        if (!this.marking.equals(rhs.marking)) {
            ivarsEqual = false;
        }
        if (this.capabilities != rhs.capabilities) {
            ivarsEqual = false;
        }
        for (int idx = 0; idx < this.articulationParameters.size(); ++idx) {
            if (this.articulationParameters.get(idx).equals(rhs.articulationParameters.get(idx))) continue;
            ivarsEqual = false;
        }
        return ivarsEqual && super.equalsImpl(rhs);
    }
}

