/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis;

import edu.nps.moves.dis.BurstDescriptor;
import edu.nps.moves.dis.EntityID;
import edu.nps.moves.dis.EventID;
import edu.nps.moves.dis.Vector3Double;
import edu.nps.moves.dis.Vector3Float;
import edu.nps.moves.dis.WarfareFamilyPdu;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class FirePdu
extends WarfareFamilyPdu
implements Serializable {
    protected EntityID munitionID = new EntityID();
    protected EventID eventID = new EventID();
    protected int fireMissionIndex;
    protected Vector3Double locationInWorldCoordinates = new Vector3Double();
    protected BurstDescriptor burstDescriptor = new BurstDescriptor();
    protected Vector3Float velocity = new Vector3Float();
    protected float rangeToTarget;

    public FirePdu() {
        this.setPduType((short)2);
    }

    @Override
    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize = super.getMarshalledSize();
        marshalSize += this.munitionID.getMarshalledSize();
        marshalSize += this.eventID.getMarshalledSize();
        marshalSize += 4;
        marshalSize += this.locationInWorldCoordinates.getMarshalledSize();
        marshalSize += this.burstDescriptor.getMarshalledSize();
        marshalSize += this.velocity.getMarshalledSize();
        return marshalSize += 4;
    }

    public void setMunitionID(EntityID pMunitionID) {
        this.munitionID = pMunitionID;
    }

    public EntityID getMunitionID() {
        return this.munitionID;
    }

    public void setEventID(EventID pEventID) {
        this.eventID = pEventID;
    }

    public EventID getEventID() {
        return this.eventID;
    }

    public void setFireMissionIndex(int pFireMissionIndex) {
        this.fireMissionIndex = pFireMissionIndex;
    }

    public int getFireMissionIndex() {
        return this.fireMissionIndex;
    }

    public void setLocationInWorldCoordinates(Vector3Double pLocationInWorldCoordinates) {
        this.locationInWorldCoordinates = pLocationInWorldCoordinates;
    }

    public Vector3Double getLocationInWorldCoordinates() {
        return this.locationInWorldCoordinates;
    }

    public void setBurstDescriptor(BurstDescriptor pBurstDescriptor) {
        this.burstDescriptor = pBurstDescriptor;
    }

    public BurstDescriptor getBurstDescriptor() {
        return this.burstDescriptor;
    }

    public void setVelocity(Vector3Float pVelocity) {
        this.velocity = pVelocity;
    }

    public Vector3Float getVelocity() {
        return this.velocity;
    }

    public void setRangeToTarget(float pRangeToTarget) {
        this.rangeToTarget = pRangeToTarget;
    }

    public float getRangeToTarget() {
        return this.rangeToTarget;
    }

    @Override
    public void marshal(ByteBuffer buff) {
        super.marshal(buff);
        this.munitionID.marshal(buff);
        this.eventID.marshal(buff);
        buff.putInt(this.fireMissionIndex);
        this.locationInWorldCoordinates.marshal(buff);
        this.burstDescriptor.marshal(buff);
        this.velocity.marshal(buff);
        buff.putFloat(this.rangeToTarget);
    }

    @Override
    public void unmarshal(ByteBuffer buff) {
        super.unmarshal(buff);
        this.munitionID.unmarshal(buff);
        this.eventID.unmarshal(buff);
        this.fireMissionIndex = buff.getInt();
        this.locationInWorldCoordinates.unmarshal(buff);
        this.burstDescriptor.unmarshal(buff);
        this.velocity.unmarshal(buff);
        this.rangeToTarget = buff.getFloat();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof FirePdu)) {
            return false;
        }
        FirePdu rhs = (FirePdu)obj;
        if (!this.munitionID.equals(rhs.munitionID)) {
            ivarsEqual = false;
        }
        if (!this.eventID.equals(rhs.eventID)) {
            ivarsEqual = false;
        }
        if (this.fireMissionIndex != rhs.fireMissionIndex) {
            ivarsEqual = false;
        }
        if (!this.locationInWorldCoordinates.equals(rhs.locationInWorldCoordinates)) {
            ivarsEqual = false;
        }
        if (!this.burstDescriptor.equals(rhs.burstDescriptor)) {
            ivarsEqual = false;
        }
        if (!this.velocity.equals(rhs.velocity)) {
            ivarsEqual = false;
        }
        if (this.rangeToTarget != rhs.rangeToTarget) {
            ivarsEqual = false;
        }
        return ivarsEqual && super.equalsImpl(rhs);
    }
}

