/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis;

import edu.nps.moves.dis.FourByteChunk;
import edu.nps.moves.dis.GridAxisRecord;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class GridAxisRecordRepresentation2
extends GridAxisRecord
implements Serializable {
    protected int numberOfValues;
    protected List<FourByteChunk> dataValues = new ArrayList<FourByteChunk>();

    @Override
    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize = super.getMarshalledSize();
        marshalSize += 2;
        for (int idx = 0; idx < this.dataValues.size(); ++idx) {
            FourByteChunk listElement = this.dataValues.get(idx);
            marshalSize += listElement.getMarshalledSize();
        }
        return marshalSize;
    }

    public int getNumberOfValues() {
        return this.dataValues.size();
    }

    public void setNumberOfValues(int pNumberOfValues) {
        this.numberOfValues = pNumberOfValues;
    }

    public void setDataValues(List<FourByteChunk> pDataValues) {
        this.dataValues = pDataValues;
    }

    public List<FourByteChunk> getDataValues() {
        return this.dataValues;
    }

    @Override
    public void marshal(ByteBuffer buff) {
        super.marshal(buff);
        buff.putShort((short)this.dataValues.size());
        for (int idx = 0; idx < this.dataValues.size(); ++idx) {
            FourByteChunk aFourByteChunk = this.dataValues.get(idx);
            aFourByteChunk.marshal(buff);
        }
    }

    @Override
    public void unmarshal(ByteBuffer buff) {
        super.unmarshal(buff);
        this.numberOfValues = buff.getShort() & 0xFFFF;
        for (int idx = 0; idx < this.numberOfValues; ++idx) {
            FourByteChunk anX = new FourByteChunk();
            anX.unmarshal(buff);
            this.dataValues.add(anX);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof GridAxisRecordRepresentation2)) {
            return false;
        }
        GridAxisRecordRepresentation2 rhs = (GridAxisRecordRepresentation2)obj;
        if (this.numberOfValues != rhs.numberOfValues) {
            ivarsEqual = false;
        }
        for (int idx = 0; idx < this.dataValues.size(); ++idx) {
            if (this.dataValues.get(idx).equals(rhs.dataValues.get(idx))) continue;
            ivarsEqual = false;
        }
        return ivarsEqual && super.equalsImpl(rhs);
    }
}

