/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis;

import edu.nps.moves.dis.Orientation;
import edu.nps.moves.dis.SixByteChunk;
import edu.nps.moves.dis.Vector3Double;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class LinearSegmentParameter
implements Serializable {
    protected short segmentNumber;
    protected SixByteChunk segmentAppearance = new SixByteChunk();
    protected Vector3Double location = new Vector3Double();
    protected Orientation orientation = new Orientation();
    protected int segmentLength;
    protected int segmentWidth;
    protected int segmentHeight;
    protected int segmentDepth;
    protected long pad1;

    public int getMarshalledSize() {
        int marshalSize = 0;
        ++marshalSize;
        marshalSize += this.segmentAppearance.getMarshalledSize();
        marshalSize += this.location.getMarshalledSize();
        marshalSize += this.orientation.getMarshalledSize();
        marshalSize += 2;
        marshalSize += 2;
        marshalSize += 2;
        marshalSize += 2;
        return marshalSize += 4;
    }

    public void setSegmentNumber(short pSegmentNumber) {
        this.segmentNumber = pSegmentNumber;
    }

    public short getSegmentNumber() {
        return this.segmentNumber;
    }

    public void setSegmentAppearance(SixByteChunk pSegmentAppearance) {
        this.segmentAppearance = pSegmentAppearance;
    }

    public SixByteChunk getSegmentAppearance() {
        return this.segmentAppearance;
    }

    public void setLocation(Vector3Double pLocation) {
        this.location = pLocation;
    }

    public Vector3Double getLocation() {
        return this.location;
    }

    public void setOrientation(Orientation pOrientation) {
        this.orientation = pOrientation;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setSegmentLength(int pSegmentLength) {
        this.segmentLength = pSegmentLength;
    }

    public int getSegmentLength() {
        return this.segmentLength;
    }

    public void setSegmentWidth(int pSegmentWidth) {
        this.segmentWidth = pSegmentWidth;
    }

    public int getSegmentWidth() {
        return this.segmentWidth;
    }

    public void setSegmentHeight(int pSegmentHeight) {
        this.segmentHeight = pSegmentHeight;
    }

    public int getSegmentHeight() {
        return this.segmentHeight;
    }

    public void setSegmentDepth(int pSegmentDepth) {
        this.segmentDepth = pSegmentDepth;
    }

    public int getSegmentDepth() {
        return this.segmentDepth;
    }

    public void setPad1(long pPad1) {
        this.pad1 = pPad1;
    }

    public long getPad1() {
        return this.pad1;
    }

    public void marshal(ByteBuffer buff) {
        buff.put((byte)this.segmentNumber);
        this.segmentAppearance.marshal(buff);
        this.location.marshal(buff);
        this.orientation.marshal(buff);
        buff.putShort((short)this.segmentLength);
        buff.putShort((short)this.segmentWidth);
        buff.putShort((short)this.segmentHeight);
        buff.putShort((short)this.segmentDepth);
        buff.putInt((int)this.pad1);
    }

    public void unmarshal(ByteBuffer buff) {
        this.segmentNumber = (short)(buff.get() & 0xFF);
        this.segmentAppearance.unmarshal(buff);
        this.location.unmarshal(buff);
        this.orientation.unmarshal(buff);
        this.segmentLength = buff.getShort() & 0xFFFF;
        this.segmentWidth = buff.getShort() & 0xFFFF;
        this.segmentHeight = buff.getShort() & 0xFFFF;
        this.segmentDepth = buff.getShort() & 0xFFFF;
        this.pad1 = buff.getInt();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof LinearSegmentParameter)) {
            return false;
        }
        LinearSegmentParameter rhs = (LinearSegmentParameter)obj;
        if (this.segmentNumber != rhs.segmentNumber) {
            ivarsEqual = false;
        }
        if (!this.segmentAppearance.equals(rhs.segmentAppearance)) {
            ivarsEqual = false;
        }
        if (!this.location.equals(rhs.location)) {
            ivarsEqual = false;
        }
        if (!this.orientation.equals(rhs.orientation)) {
            ivarsEqual = false;
        }
        if (this.segmentLength != rhs.segmentLength) {
            ivarsEqual = false;
        }
        if (this.segmentWidth != rhs.segmentWidth) {
            ivarsEqual = false;
        }
        if (this.segmentHeight != rhs.segmentHeight) {
            ivarsEqual = false;
        }
        if (this.segmentDepth != rhs.segmentDepth) {
            ivarsEqual = false;
        }
        if (this.pad1 != rhs.pad1) {
            ivarsEqual = false;
        }
        return ivarsEqual;
    }
}

