/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis;

import edu.nps.moves.dis.EntityID;
import edu.nps.moves.dis.EntityType;
import edu.nps.moves.dis.MinefieldFamilyPdu;
import edu.nps.moves.dis.TwoByteChunk;
import edu.nps.moves.dis.Vector3Float;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class MinefieldDataPdu
extends MinefieldFamilyPdu
implements Serializable {
    protected EntityID minefieldID = new EntityID();
    protected EntityID requestingEntityID = new EntityID();
    protected int minefieldSequenceNumbeer;
    protected short requestID;
    protected short pduSequenceNumber;
    protected short numberOfPdus;
    protected short numberOfMinesInThisPdu;
    protected short numberOfSensorTypes;
    protected short pad2 = 0;
    protected long dataFilter;
    protected EntityType mineType = new EntityType();
    protected List<TwoByteChunk> sensorTypes = new ArrayList<TwoByteChunk>();
    protected short pad3;
    protected List<Vector3Float> mineLocation = new ArrayList<Vector3Float>();

    public MinefieldDataPdu() {
        this.setPduType((short)39);
    }

    @Override
    public int getMarshalledSize() {
        Serializable listElement;
        int idx;
        int marshalSize = 0;
        marshalSize = super.getMarshalledSize();
        marshalSize += this.minefieldID.getMarshalledSize();
        marshalSize += this.requestingEntityID.getMarshalledSize();
        marshalSize += 2;
        ++marshalSize;
        ++marshalSize;
        ++marshalSize;
        ++marshalSize;
        ++marshalSize;
        ++marshalSize;
        marshalSize += 4;
        marshalSize += this.mineType.getMarshalledSize();
        for (idx = 0; idx < this.sensorTypes.size(); ++idx) {
            listElement = this.sensorTypes.get(idx);
            marshalSize += ((TwoByteChunk)listElement).getMarshalledSize();
        }
        ++marshalSize;
        for (idx = 0; idx < this.mineLocation.size(); ++idx) {
            listElement = this.mineLocation.get(idx);
            marshalSize += ((Vector3Float)listElement).getMarshalledSize();
        }
        return marshalSize;
    }

    public void setMinefieldID(EntityID pMinefieldID) {
        this.minefieldID = pMinefieldID;
    }

    public EntityID getMinefieldID() {
        return this.minefieldID;
    }

    public void setRequestingEntityID(EntityID pRequestingEntityID) {
        this.requestingEntityID = pRequestingEntityID;
    }

    public EntityID getRequestingEntityID() {
        return this.requestingEntityID;
    }

    public void setMinefieldSequenceNumbeer(int pMinefieldSequenceNumbeer) {
        this.minefieldSequenceNumbeer = pMinefieldSequenceNumbeer;
    }

    public int getMinefieldSequenceNumbeer() {
        return this.minefieldSequenceNumbeer;
    }

    public void setRequestID(short pRequestID) {
        this.requestID = pRequestID;
    }

    public short getRequestID() {
        return this.requestID;
    }

    public void setPduSequenceNumber(short pPduSequenceNumber) {
        this.pduSequenceNumber = pPduSequenceNumber;
    }

    public short getPduSequenceNumber() {
        return this.pduSequenceNumber;
    }

    public void setNumberOfPdus(short pNumberOfPdus) {
        this.numberOfPdus = pNumberOfPdus;
    }

    public short getNumberOfPdus() {
        return this.numberOfPdus;
    }

    public short getNumberOfMinesInThisPdu() {
        return (short)this.mineLocation.size();
    }

    public void setNumberOfMinesInThisPdu(short pNumberOfMinesInThisPdu) {
        this.numberOfMinesInThisPdu = pNumberOfMinesInThisPdu;
    }

    public short getNumberOfSensorTypes() {
        return (short)this.sensorTypes.size();
    }

    public void setNumberOfSensorTypes(short pNumberOfSensorTypes) {
        this.numberOfSensorTypes = pNumberOfSensorTypes;
    }

    public void setPad2(short pPad2) {
        this.pad2 = pPad2;
    }

    public short getPad2() {
        return this.pad2;
    }

    public void setDataFilter(long pDataFilter) {
        this.dataFilter = pDataFilter;
    }

    public long getDataFilter() {
        return this.dataFilter;
    }

    public void setMineType(EntityType pMineType) {
        this.mineType = pMineType;
    }

    public EntityType getMineType() {
        return this.mineType;
    }

    public void setSensorTypes(List<TwoByteChunk> pSensorTypes) {
        this.sensorTypes = pSensorTypes;
    }

    public List<TwoByteChunk> getSensorTypes() {
        return this.sensorTypes;
    }

    public void setPad3(short pPad3) {
        this.pad3 = pPad3;
    }

    public short getPad3() {
        return this.pad3;
    }

    public void setMineLocation(List<Vector3Float> pMineLocation) {
        this.mineLocation = pMineLocation;
    }

    public List<Vector3Float> getMineLocation() {
        return this.mineLocation;
    }

    @Override
    public void marshal(ByteBuffer buff) {
        int idx;
        super.marshal(buff);
        this.minefieldID.marshal(buff);
        this.requestingEntityID.marshal(buff);
        buff.putShort((short)this.minefieldSequenceNumbeer);
        buff.put((byte)this.requestID);
        buff.put((byte)this.pduSequenceNumber);
        buff.put((byte)this.numberOfPdus);
        buff.put((byte)this.mineLocation.size());
        buff.put((byte)this.sensorTypes.size());
        buff.put((byte)this.pad2);
        buff.putInt((int)this.dataFilter);
        this.mineType.marshal(buff);
        for (idx = 0; idx < this.sensorTypes.size(); ++idx) {
            TwoByteChunk aTwoByteChunk = this.sensorTypes.get(idx);
            aTwoByteChunk.marshal(buff);
        }
        buff.put((byte)this.pad3);
        for (idx = 0; idx < this.mineLocation.size(); ++idx) {
            Vector3Float aVector3Float = this.mineLocation.get(idx);
            aVector3Float.marshal(buff);
        }
    }

    @Override
    public void unmarshal(ByteBuffer buff) {
        Serializable anX;
        int idx;
        super.unmarshal(buff);
        this.minefieldID.unmarshal(buff);
        this.requestingEntityID.unmarshal(buff);
        this.minefieldSequenceNumbeer = buff.getShort() & 0xFFFF;
        this.requestID = (short)(buff.get() & 0xFF);
        this.pduSequenceNumber = (short)(buff.get() & 0xFF);
        this.numberOfPdus = (short)(buff.get() & 0xFF);
        this.numberOfMinesInThisPdu = (short)(buff.get() & 0xFF);
        this.numberOfSensorTypes = (short)(buff.get() & 0xFF);
        this.pad2 = (short)(buff.get() & 0xFF);
        this.dataFilter = buff.getInt();
        this.mineType.unmarshal(buff);
        for (idx = 0; idx < this.numberOfSensorTypes; ++idx) {
            anX = new TwoByteChunk();
            ((TwoByteChunk)anX).unmarshal(buff);
            this.sensorTypes.add((TwoByteChunk)anX);
        }
        this.pad3 = (short)(buff.get() & 0xFF);
        for (idx = 0; idx < this.numberOfMinesInThisPdu; ++idx) {
            anX = new Vector3Float();
            ((Vector3Float)anX).unmarshal(buff);
            this.mineLocation.add((Vector3Float)anX);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        int idx;
        boolean ivarsEqual = true;
        if (!(obj instanceof MinefieldDataPdu)) {
            return false;
        }
        MinefieldDataPdu rhs = (MinefieldDataPdu)obj;
        if (!this.minefieldID.equals(rhs.minefieldID)) {
            ivarsEqual = false;
        }
        if (!this.requestingEntityID.equals(rhs.requestingEntityID)) {
            ivarsEqual = false;
        }
        if (this.minefieldSequenceNumbeer != rhs.minefieldSequenceNumbeer) {
            ivarsEqual = false;
        }
        if (this.requestID != rhs.requestID) {
            ivarsEqual = false;
        }
        if (this.pduSequenceNumber != rhs.pduSequenceNumber) {
            ivarsEqual = false;
        }
        if (this.numberOfPdus != rhs.numberOfPdus) {
            ivarsEqual = false;
        }
        if (this.numberOfMinesInThisPdu != rhs.numberOfMinesInThisPdu) {
            ivarsEqual = false;
        }
        if (this.numberOfSensorTypes != rhs.numberOfSensorTypes) {
            ivarsEqual = false;
        }
        if (this.pad2 != rhs.pad2) {
            ivarsEqual = false;
        }
        if (this.dataFilter != rhs.dataFilter) {
            ivarsEqual = false;
        }
        if (!this.mineType.equals(rhs.mineType)) {
            ivarsEqual = false;
        }
        for (idx = 0; idx < this.sensorTypes.size(); ++idx) {
            if (this.sensorTypes.get(idx).equals(rhs.sensorTypes.get(idx))) continue;
            ivarsEqual = false;
        }
        if (this.pad3 != rhs.pad3) {
            ivarsEqual = false;
        }
        for (idx = 0; idx < this.mineLocation.size(); ++idx) {
            if (this.mineLocation.get(idx).equals(rhs.mineLocation.get(idx))) continue;
            ivarsEqual = false;
        }
        return ivarsEqual && super.equalsImpl(rhs);
    }
}

