/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis;

import edu.nps.moves.dis.EightByteChunk;
import edu.nps.moves.dis.EntityID;
import edu.nps.moves.dis.MinefieldFamilyPdu;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class MinefieldResponseNackPdu
extends MinefieldFamilyPdu
implements Serializable {
    protected EntityID minefieldID = new EntityID();
    protected EntityID requestingEntityID = new EntityID();
    protected short requestID;
    protected short numberOfMissingPdus;
    protected List<EightByteChunk> missingPduSequenceNumbers = new ArrayList<EightByteChunk>();

    public MinefieldResponseNackPdu() {
        this.setPduType((short)40);
    }

    @Override
    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize = super.getMarshalledSize();
        marshalSize += this.minefieldID.getMarshalledSize();
        marshalSize += this.requestingEntityID.getMarshalledSize();
        ++marshalSize;
        ++marshalSize;
        for (int idx = 0; idx < this.missingPduSequenceNumbers.size(); ++idx) {
            EightByteChunk listElement = this.missingPduSequenceNumbers.get(idx);
            marshalSize += listElement.getMarshalledSize();
        }
        return marshalSize;
    }

    public void setMinefieldID(EntityID pMinefieldID) {
        this.minefieldID = pMinefieldID;
    }

    public EntityID getMinefieldID() {
        return this.minefieldID;
    }

    public void setRequestingEntityID(EntityID pRequestingEntityID) {
        this.requestingEntityID = pRequestingEntityID;
    }

    public EntityID getRequestingEntityID() {
        return this.requestingEntityID;
    }

    public void setRequestID(short pRequestID) {
        this.requestID = pRequestID;
    }

    public short getRequestID() {
        return this.requestID;
    }

    public short getNumberOfMissingPdus() {
        return (short)this.missingPduSequenceNumbers.size();
    }

    public void setNumberOfMissingPdus(short pNumberOfMissingPdus) {
        this.numberOfMissingPdus = pNumberOfMissingPdus;
    }

    public void setMissingPduSequenceNumbers(List<EightByteChunk> pMissingPduSequenceNumbers) {
        this.missingPduSequenceNumbers = pMissingPduSequenceNumbers;
    }

    public List<EightByteChunk> getMissingPduSequenceNumbers() {
        return this.missingPduSequenceNumbers;
    }

    @Override
    public void marshal(ByteBuffer buff) {
        super.marshal(buff);
        this.minefieldID.marshal(buff);
        this.requestingEntityID.marshal(buff);
        buff.put((byte)this.requestID);
        buff.put((byte)this.missingPduSequenceNumbers.size());
        for (int idx = 0; idx < this.missingPduSequenceNumbers.size(); ++idx) {
            EightByteChunk aEightByteChunk = this.missingPduSequenceNumbers.get(idx);
            aEightByteChunk.marshal(buff);
        }
    }

    @Override
    public void unmarshal(ByteBuffer buff) {
        super.unmarshal(buff);
        this.minefieldID.unmarshal(buff);
        this.requestingEntityID.unmarshal(buff);
        this.requestID = (short)(buff.get() & 0xFF);
        this.numberOfMissingPdus = (short)(buff.get() & 0xFF);
        for (int idx = 0; idx < this.numberOfMissingPdus; ++idx) {
            EightByteChunk anX = new EightByteChunk();
            anX.unmarshal(buff);
            this.missingPduSequenceNumbers.add(anX);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof MinefieldResponseNackPdu)) {
            return false;
        }
        MinefieldResponseNackPdu rhs = (MinefieldResponseNackPdu)obj;
        if (!this.minefieldID.equals(rhs.minefieldID)) {
            ivarsEqual = false;
        }
        if (!this.requestingEntityID.equals(rhs.requestingEntityID)) {
            ivarsEqual = false;
        }
        if (this.requestID != rhs.requestID) {
            ivarsEqual = false;
        }
        if (this.numberOfMissingPdus != rhs.numberOfMissingPdus) {
            ivarsEqual = false;
        }
        for (int idx = 0; idx < this.missingPduSequenceNumbers.size(); ++idx) {
            if (this.missingPduSequenceNumbers.get(idx).equals(rhs.missingPduSequenceNumbers.get(idx))) continue;
            ivarsEqual = false;
        }
        return ivarsEqual && super.equalsImpl(rhs);
    }
}

