/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis;

import edu.nps.moves.dis.EntityID;
import edu.nps.moves.dis.EntityType;
import edu.nps.moves.dis.MinefieldFamilyPdu;
import edu.nps.moves.dis.Orientation;
import edu.nps.moves.dis.Point;
import edu.nps.moves.dis.Vector3Double;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class MinefieldStatePdu
extends MinefieldFamilyPdu
implements Serializable {
    protected EntityID minefieldID = new EntityID();
    protected int minefieldSequence;
    protected short forceID;
    protected short numberOfPerimeterPoints;
    protected EntityType minefieldType = new EntityType();
    protected int numberOfMineTypes;
    protected Vector3Double minefieldLocation = new Vector3Double();
    protected Orientation minefieldOrientation = new Orientation();
    protected int appearance;
    protected int protocolMode;
    protected List<Point> perimeterPoints = new ArrayList<Point>();
    protected List<EntityType> mineType = new ArrayList<EntityType>();

    public MinefieldStatePdu() {
        this.setPduType((short)37);
    }

    @Override
    public int getMarshalledSize() {
        Serializable listElement;
        int idx;
        int marshalSize = 0;
        marshalSize = super.getMarshalledSize();
        marshalSize += this.minefieldID.getMarshalledSize();
        marshalSize += 2;
        ++marshalSize;
        ++marshalSize;
        marshalSize += this.minefieldType.getMarshalledSize();
        marshalSize += 2;
        marshalSize += this.minefieldLocation.getMarshalledSize();
        marshalSize += this.minefieldOrientation.getMarshalledSize();
        marshalSize += 2;
        marshalSize += 2;
        for (idx = 0; idx < this.perimeterPoints.size(); ++idx) {
            listElement = this.perimeterPoints.get(idx);
            marshalSize += ((Point)listElement).getMarshalledSize();
        }
        for (idx = 0; idx < this.mineType.size(); ++idx) {
            listElement = this.mineType.get(idx);
            marshalSize += ((EntityType)listElement).getMarshalledSize();
        }
        return marshalSize;
    }

    public void setMinefieldID(EntityID pMinefieldID) {
        this.minefieldID = pMinefieldID;
    }

    public EntityID getMinefieldID() {
        return this.minefieldID;
    }

    public void setMinefieldSequence(int pMinefieldSequence) {
        this.minefieldSequence = pMinefieldSequence;
    }

    public int getMinefieldSequence() {
        return this.minefieldSequence;
    }

    public void setForceID(short pForceID) {
        this.forceID = pForceID;
    }

    public short getForceID() {
        return this.forceID;
    }

    public short getNumberOfPerimeterPoints() {
        return (short)this.perimeterPoints.size();
    }

    public void setNumberOfPerimeterPoints(short pNumberOfPerimeterPoints) {
        this.numberOfPerimeterPoints = pNumberOfPerimeterPoints;
    }

    public void setMinefieldType(EntityType pMinefieldType) {
        this.minefieldType = pMinefieldType;
    }

    public EntityType getMinefieldType() {
        return this.minefieldType;
    }

    public int getNumberOfMineTypes() {
        return this.mineType.size();
    }

    public void setNumberOfMineTypes(int pNumberOfMineTypes) {
        this.numberOfMineTypes = pNumberOfMineTypes;
    }

    public void setMinefieldLocation(Vector3Double pMinefieldLocation) {
        this.minefieldLocation = pMinefieldLocation;
    }

    public Vector3Double getMinefieldLocation() {
        return this.minefieldLocation;
    }

    public void setMinefieldOrientation(Orientation pMinefieldOrientation) {
        this.minefieldOrientation = pMinefieldOrientation;
    }

    public Orientation getMinefieldOrientation() {
        return this.minefieldOrientation;
    }

    public void setAppearance(int pAppearance) {
        this.appearance = pAppearance;
    }

    public int getAppearance() {
        return this.appearance;
    }

    public void setProtocolMode(int pProtocolMode) {
        this.protocolMode = pProtocolMode;
    }

    public int getProtocolMode() {
        return this.protocolMode;
    }

    public void setPerimeterPoints(List<Point> pPerimeterPoints) {
        this.perimeterPoints = pPerimeterPoints;
    }

    public List<Point> getPerimeterPoints() {
        return this.perimeterPoints;
    }

    public void setMineType(List<EntityType> pMineType) {
        this.mineType = pMineType;
    }

    public List<EntityType> getMineType() {
        return this.mineType;
    }

    @Override
    public void marshal(ByteBuffer buff) {
        int idx;
        super.marshal(buff);
        this.minefieldID.marshal(buff);
        buff.putShort((short)this.minefieldSequence);
        buff.put((byte)this.forceID);
        buff.put((byte)this.perimeterPoints.size());
        this.minefieldType.marshal(buff);
        buff.putShort((short)this.mineType.size());
        this.minefieldLocation.marshal(buff);
        this.minefieldOrientation.marshal(buff);
        buff.putShort((short)this.appearance);
        buff.putShort((short)this.protocolMode);
        for (idx = 0; idx < this.perimeterPoints.size(); ++idx) {
            Point aPoint = this.perimeterPoints.get(idx);
            aPoint.marshal(buff);
        }
        for (idx = 0; idx < this.mineType.size(); ++idx) {
            EntityType aEntityType = this.mineType.get(idx);
            aEntityType.marshal(buff);
        }
    }

    @Override
    public void unmarshal(ByteBuffer buff) {
        Serializable anX;
        int idx;
        super.unmarshal(buff);
        this.minefieldID.unmarshal(buff);
        this.minefieldSequence = buff.getShort() & 0xFFFF;
        this.forceID = (short)(buff.get() & 0xFF);
        this.numberOfPerimeterPoints = (short)(buff.get() & 0xFF);
        this.minefieldType.unmarshal(buff);
        this.numberOfMineTypes = buff.getShort() & 0xFFFF;
        this.minefieldLocation.unmarshal(buff);
        this.minefieldOrientation.unmarshal(buff);
        this.appearance = buff.getShort() & 0xFFFF;
        this.protocolMode = buff.getShort() & 0xFFFF;
        for (idx = 0; idx < this.numberOfPerimeterPoints; ++idx) {
            anX = new Point();
            ((Point)anX).unmarshal(buff);
            this.perimeterPoints.add((Point)anX);
        }
        for (idx = 0; idx < this.numberOfMineTypes; ++idx) {
            anX = new EntityType();
            ((EntityType)anX).unmarshal(buff);
            this.mineType.add((EntityType)anX);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        int idx;
        boolean ivarsEqual = true;
        if (!(obj instanceof MinefieldStatePdu)) {
            return false;
        }
        MinefieldStatePdu rhs = (MinefieldStatePdu)obj;
        if (!this.minefieldID.equals(rhs.minefieldID)) {
            ivarsEqual = false;
        }
        if (this.minefieldSequence != rhs.minefieldSequence) {
            ivarsEqual = false;
        }
        if (this.forceID != rhs.forceID) {
            ivarsEqual = false;
        }
        if (this.numberOfPerimeterPoints != rhs.numberOfPerimeterPoints) {
            ivarsEqual = false;
        }
        if (!this.minefieldType.equals(rhs.minefieldType)) {
            ivarsEqual = false;
        }
        if (this.numberOfMineTypes != rhs.numberOfMineTypes) {
            ivarsEqual = false;
        }
        if (!this.minefieldLocation.equals(rhs.minefieldLocation)) {
            ivarsEqual = false;
        }
        if (!this.minefieldOrientation.equals(rhs.minefieldOrientation)) {
            ivarsEqual = false;
        }
        if (this.appearance != rhs.appearance) {
            ivarsEqual = false;
        }
        if (this.protocolMode != rhs.protocolMode) {
            ivarsEqual = false;
        }
        for (idx = 0; idx < this.perimeterPoints.size(); ++idx) {
            if (this.perimeterPoints.get(idx).equals(rhs.perimeterPoints.get(idx))) continue;
            ivarsEqual = false;
        }
        for (idx = 0; idx < this.mineType.size(); ++idx) {
            if (this.mineType.get(idx).equals(rhs.mineType.get(idx))) continue;
            ivarsEqual = false;
        }
        return ivarsEqual && super.equalsImpl(rhs);
    }
}

