/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis;

import edu.nps.moves.dis.EntityStatePdu;
import edu.nps.moves.disenum.PduType;
import edu.nps.moves.disutil.DisTime;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Pdu
implements Serializable {
    protected short protocolVersion = (short)6;
    protected short exerciseID = 0;
    protected short pduType;
    protected short protocolFamily;
    protected long timestamp;
    protected short padding = 0;

    public int getLength() {
        return this.getMarshalledSize();
    }

    public int getMarshalledSize() {
        int marshalSize = 0;
        ++marshalSize;
        ++marshalSize;
        ++marshalSize;
        ++marshalSize;
        marshalSize += 4;
        marshalSize += 2;
        return marshalSize += 2;
    }

    public void setProtocolVersion(short pProtocolVersion) {
        this.protocolVersion = pProtocolVersion;
    }

    public short getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setExerciseID(short pExerciseID) {
        this.exerciseID = pExerciseID;
    }

    public short getExerciseID() {
        return this.exerciseID;
    }

    public void setPduType(short pPduType) {
        this.pduType = pPduType;
    }

    public short getPduType() {
        return this.pduType;
    }

    public PduType getPduTypeEnum() {
        return PduType.lookup[this.pduType];
    }

    public void setProtocolFamily(short pProtocolFamily) {
        this.protocolFamily = pProtocolFamily;
    }

    public short getProtocolFamily() {
        return this.protocolFamily;
    }

    public void setTimestamp(long pTimestamp) {
        this.timestamp = pTimestamp;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @Deprecated
    public void setPduLength(int pPduLength) {
    }

    @Deprecated
    public int getPduLength() {
        return this.getMarshalledSize();
    }

    public void setPadding(short pPadding) {
        this.padding = pPadding;
    }

    public short getPadding() {
        return this.padding;
    }

    private static long shiftBytes(int[] fourBytes) {
        long value = 0L;
        value = (long)(fourBytes[0] << 24 | fourBytes[1] << 16 | fourBytes[2] << 8 | fourBytes[3]) & 0xFFFFFFFFL;
        return value;
    }

    public static long readUnsignedInt(ByteBuffer buff) {
        int[] fourBytes = new int[]{Pdu.toUnsignedInt(buff.get()), Pdu.toUnsignedInt(buff.get()), Pdu.toUnsignedInt(buff.get()), Pdu.toUnsignedInt(buff.get())};
        return Pdu.shiftBytes(fourBytes);
    }

    public static int toUnsignedInt(byte b) {
        return b & 0xFF;
    }

    public static int toUnsignedInt(short s) {
        return s & 0xFFFF;
    }

    public void marshal(DataOutputStream dos) {
        try {
            dos.write(this.marshal());
        }
        catch (IOException ex) {
            Logger.getLogger(Pdu.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void unmarshal(DataInputStream dis) {
        try {
            byte[] header = new byte[12];
            dis.mark(header.length);
            dis.read(header, 0, header.length);
            short pduLength = ByteBuffer.wrap(header).getShort(8);
            this.setPduLength(pduLength);
            dis.reset();
            byte[] pdu = new byte[pduLength];
            dis.read(pdu, 0, pduLength);
            this.unmarshal(ByteBuffer.wrap(pdu));
        }
        catch (IOException ex) {
            Logger.getLogger(EntityStatePdu.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void marshal(ByteBuffer buff) {
        buff.put((byte)this.protocolVersion);
        buff.put((byte)this.exerciseID);
        buff.put((byte)this.pduType);
        buff.put((byte)this.protocolFamily);
        buff.putInt((int)this.timestamp);
        buff.putShort((short)this.getLength());
        buff.putShort(this.padding);
    }

    public void unmarshal(ByteBuffer buff) {
        this.protocolVersion = (short)Pdu.toUnsignedInt(buff.get());
        this.exerciseID = (short)Pdu.toUnsignedInt(buff.get());
        this.pduType = (short)Pdu.toUnsignedInt(buff.get());
        this.protocolFamily = (short)Pdu.toUnsignedInt(buff.get());
        this.timestamp = buff.getInt();
        int pduLength = Pdu.toUnsignedInt(buff.getShort());
        this.setPduLength(pduLength);
        this.padding = buff.getShort();
    }

    public byte[] marshal() {
        byte[] data = new byte[this.getMarshalledSize()];
        ByteBuffer buff = ByteBuffer.wrap(data);
        this.marshal(buff);
        return data;
    }

    public byte[] marshalWithDisAbsoluteTimestamp() {
        DisTime disTime = DisTime.getInstance();
        this.setTimestamp(disTime.getDisAbsoluteTimestamp());
        return this.marshal();
    }

    public void marshalWithDisAbsoluteTimestamp(ByteBuffer buff) {
        DisTime disTime = DisTime.getInstance();
        this.setTimestamp(disTime.getDisAbsoluteTimestamp());
        this.marshal(buff);
    }

    public byte[] marshalWithDisRelativeTimestamp() {
        DisTime disTime = DisTime.getInstance();
        this.setTimestamp(disTime.getDisRelativeTimestamp());
        return this.marshal();
    }

    public void marshalWithDisRelativeTimestamp(ByteBuffer buff) {
        DisTime disTime = DisTime.getInstance();
        this.setTimestamp(disTime.getDisRelativeTimestamp());
        this.marshal(buff);
    }

    public byte[] marshalWithNpsTimestamp() {
        DisTime disTime = DisTime.getInstance();
        this.setTimestamp(disTime.getNpsTimestamp());
        return this.marshal();
    }

    public void marshalWithNpsTimestamp(ByteBuffer buff) {
        DisTime disTime = DisTime.getInstance();
        this.setTimestamp(disTime.getNpsTimestamp());
        this.marshal(buff);
    }

    public byte[] marshalWithUnixTimestamp() {
        DisTime disTime = DisTime.getInstance();
        this.setTimestamp(disTime.getUnixTimestamp());
        return this.marshal();
    }

    public void marshalWithUnixTimestamp(ByteBuffer buff) {
        DisTime disTime = DisTime.getInstance();
        this.setTimestamp(disTime.getUnixTimestamp());
        this.marshal(buff);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof Pdu)) {
            return false;
        }
        Pdu rhs = (Pdu)obj;
        if (this.protocolVersion != rhs.protocolVersion) {
            ivarsEqual = false;
        }
        if (this.exerciseID != rhs.exerciseID) {
            ivarsEqual = false;
        }
        if (this.pduType != rhs.pduType) {
            ivarsEqual = false;
        }
        if (this.protocolFamily != rhs.protocolFamily) {
            ivarsEqual = false;
        }
        if (this.timestamp != rhs.timestamp) {
            ivarsEqual = false;
        }
        if (this.getMarshalledSize() != rhs.getMarshalledSize()) {
            ivarsEqual = false;
        }
        if (this.padding != rhs.padding) {
            ivarsEqual = false;
        }
        return ivarsEqual;
    }
}

