/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis;

import edu.nps.moves.dis.EntityID;
import edu.nps.moves.dis.RadioCommunicationsFamilyPdu;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class ReceiverPdu
extends RadioCommunicationsFamilyPdu
implements Serializable {
    protected EntityID entityId = new EntityID();
    protected int radioId;
    protected int receiverState;
    protected int padding1;
    protected float receivedPower;
    protected EntityID transmitterEntityId = new EntityID();
    protected int transmitterRadioId;

    public ReceiverPdu() {
        this.setPduType((short)27);
    }

    @Override
    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize = super.getMarshalledSize();
        marshalSize += this.entityId.getMarshalledSize();
        marshalSize += 2;
        marshalSize += 2;
        marshalSize += 2;
        marshalSize += 4;
        marshalSize += this.transmitterEntityId.getMarshalledSize();
        return marshalSize += 2;
    }

    public void setEntityId(EntityID pEntityId) {
        this.entityId = pEntityId;
    }

    public EntityID getEntityId() {
        return this.entityId;
    }

    public void setRadioId(int pRadioId) {
        this.radioId = pRadioId;
    }

    public int getRadioId() {
        return this.radioId;
    }

    public void setReceiverState(int pReceiverState) {
        this.receiverState = pReceiverState;
    }

    public int getReceiverState() {
        return this.receiverState;
    }

    public void setPadding1(int pPadding1) {
        this.padding1 = pPadding1;
    }

    public int getPadding1() {
        return this.padding1;
    }

    public void setReceivedPower(float pReceivedPower) {
        this.receivedPower = pReceivedPower;
    }

    public float getReceivedPower() {
        return this.receivedPower;
    }

    public void setTransmitterEntityId(EntityID pTransmitterEntityId) {
        this.transmitterEntityId = pTransmitterEntityId;
    }

    public EntityID getTransmitterEntityId() {
        return this.transmitterEntityId;
    }

    public void setTransmitterRadioId(int pTransmitterRadioId) {
        this.transmitterRadioId = pTransmitterRadioId;
    }

    public int getTransmitterRadioId() {
        return this.transmitterRadioId;
    }

    @Override
    public void marshal(ByteBuffer buff) {
        super.marshal(buff);
        this.entityId.marshal(buff);
        buff.putShort((short)this.radioId);
        buff.putShort((short)this.receiverState);
        buff.putShort((short)this.padding1);
        buff.putFloat(this.receivedPower);
        this.transmitterEntityId.marshal(buff);
        buff.putShort((short)this.transmitterRadioId);
    }

    @Override
    public void unmarshal(ByteBuffer buff) {
        super.unmarshal(buff);
        this.entityId.unmarshal(buff);
        this.radioId = buff.getShort() & 0xFFFF;
        this.receiverState = buff.getShort() & 0xFFFF;
        this.padding1 = buff.getShort() & 0xFFFF;
        this.receivedPower = buff.getFloat();
        this.transmitterEntityId.unmarshal(buff);
        this.transmitterRadioId = buff.getShort() & 0xFFFF;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof ReceiverPdu)) {
            return false;
        }
        ReceiverPdu rhs = (ReceiverPdu)obj;
        if (!this.entityId.equals(rhs.entityId)) {
            ivarsEqual = false;
        }
        if (this.radioId != rhs.radioId) {
            ivarsEqual = false;
        }
        if (this.receiverState != rhs.receiverState) {
            ivarsEqual = false;
        }
        if (this.padding1 != rhs.padding1) {
            ivarsEqual = false;
        }
        if (this.receivedPower != rhs.receivedPower) {
            ivarsEqual = false;
        }
        if (!this.transmitterEntityId.equals(rhs.transmitterEntityId)) {
            ivarsEqual = false;
        }
        if (this.transmitterRadioId != rhs.transmitterRadioId) {
            ivarsEqual = false;
        }
        return ivarsEqual && super.equalsImpl(rhs);
    }
}

