/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis;

import edu.nps.moves.dis.EntityID;
import edu.nps.moves.dis.LogisticsFamilyPdu;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class RepairResponsePdu
extends LogisticsFamilyPdu
implements Serializable {
    protected EntityID receivingEntityID = new EntityID();
    protected EntityID repairingEntityID = new EntityID();
    protected short repairResult;
    protected short padding1 = 0;
    protected byte padding2 = 0;

    public RepairResponsePdu() {
        this.setPduType((short)10);
    }

    @Override
    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize = super.getMarshalledSize();
        marshalSize += this.receivingEntityID.getMarshalledSize();
        marshalSize += this.repairingEntityID.getMarshalledSize();
        ++marshalSize;
        marshalSize += 2;
        return ++marshalSize;
    }

    public void setReceivingEntityID(EntityID pReceivingEntityID) {
        this.receivingEntityID = pReceivingEntityID;
    }

    public EntityID getReceivingEntityID() {
        return this.receivingEntityID;
    }

    public void setRepairingEntityID(EntityID pRepairingEntityID) {
        this.repairingEntityID = pRepairingEntityID;
    }

    public EntityID getRepairingEntityID() {
        return this.repairingEntityID;
    }

    public void setRepairResult(short pRepairResult) {
        this.repairResult = pRepairResult;
    }

    public short getRepairResult() {
        return this.repairResult;
    }

    public void setPadding1(short pPadding1) {
        this.padding1 = pPadding1;
    }

    public short getPadding1() {
        return this.padding1;
    }

    public void setPadding2(byte pPadding2) {
        this.padding2 = pPadding2;
    }

    public byte getPadding2() {
        return this.padding2;
    }

    @Override
    public void marshal(ByteBuffer buff) {
        super.marshal(buff);
        this.receivingEntityID.marshal(buff);
        this.repairingEntityID.marshal(buff);
        buff.put((byte)this.repairResult);
        buff.putShort(this.padding1);
        buff.put(this.padding2);
    }

    @Override
    public void unmarshal(ByteBuffer buff) {
        super.unmarshal(buff);
        this.receivingEntityID.unmarshal(buff);
        this.repairingEntityID.unmarshal(buff);
        this.repairResult = (short)(buff.get() & 0xFF);
        this.padding1 = buff.getShort();
        this.padding2 = buff.get();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof RepairResponsePdu)) {
            return false;
        }
        RepairResponsePdu rhs = (RepairResponsePdu)obj;
        if (!this.receivingEntityID.equals(rhs.receivingEntityID)) {
            ivarsEqual = false;
        }
        if (!this.repairingEntityID.equals(rhs.repairingEntityID)) {
            ivarsEqual = false;
        }
        if (this.repairResult != rhs.repairResult) {
            ivarsEqual = false;
        }
        if (this.padding1 != rhs.padding1) {
            ivarsEqual = false;
        }
        if (this.padding2 != rhs.padding2) {
            ivarsEqual = false;
        }
        return ivarsEqual && super.equalsImpl(rhs);
    }
}

