/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis;

import edu.nps.moves.dis.DistributedEmissionsFamilyPdu;
import edu.nps.moves.dis.EntityID;
import edu.nps.moves.dis.PropulsionSystemData;
import edu.nps.moves.dis.VectoringNozzleSystemData;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class SeesPdu
extends DistributedEmissionsFamilyPdu
implements Serializable {
    protected EntityID orginatingEntityID = new EntityID();
    protected int infraredSignatureRepresentationIndex;
    protected int acousticSignatureRepresentationIndex;
    protected int radarCrossSectionSignatureRepresentationIndex;
    protected int numberOfPropulsionSystems;
    protected int numberOfVectoringNozzleSystems;
    protected List<PropulsionSystemData> propulsionSystemData = new ArrayList<PropulsionSystemData>();
    protected List<VectoringNozzleSystemData> vectoringSystemData = new ArrayList<VectoringNozzleSystemData>();

    public SeesPdu() {
        this.setPduType((short)30);
    }

    @Override
    public int getMarshalledSize() {
        Serializable listElement;
        int idx;
        int marshalSize = 0;
        marshalSize = super.getMarshalledSize();
        marshalSize += this.orginatingEntityID.getMarshalledSize();
        marshalSize += 2;
        marshalSize += 2;
        marshalSize += 2;
        marshalSize += 2;
        marshalSize += 2;
        for (idx = 0; idx < this.propulsionSystemData.size(); ++idx) {
            listElement = this.propulsionSystemData.get(idx);
            marshalSize += ((PropulsionSystemData)listElement).getMarshalledSize();
        }
        for (idx = 0; idx < this.vectoringSystemData.size(); ++idx) {
            listElement = this.vectoringSystemData.get(idx);
            marshalSize += ((VectoringNozzleSystemData)listElement).getMarshalledSize();
        }
        return marshalSize;
    }

    public void setOrginatingEntityID(EntityID pOrginatingEntityID) {
        this.orginatingEntityID = pOrginatingEntityID;
    }

    public EntityID getOrginatingEntityID() {
        return this.orginatingEntityID;
    }

    public void setInfraredSignatureRepresentationIndex(int pInfraredSignatureRepresentationIndex) {
        this.infraredSignatureRepresentationIndex = pInfraredSignatureRepresentationIndex;
    }

    public int getInfraredSignatureRepresentationIndex() {
        return this.infraredSignatureRepresentationIndex;
    }

    public void setAcousticSignatureRepresentationIndex(int pAcousticSignatureRepresentationIndex) {
        this.acousticSignatureRepresentationIndex = pAcousticSignatureRepresentationIndex;
    }

    public int getAcousticSignatureRepresentationIndex() {
        return this.acousticSignatureRepresentationIndex;
    }

    public void setRadarCrossSectionSignatureRepresentationIndex(int pRadarCrossSectionSignatureRepresentationIndex) {
        this.radarCrossSectionSignatureRepresentationIndex = pRadarCrossSectionSignatureRepresentationIndex;
    }

    public int getRadarCrossSectionSignatureRepresentationIndex() {
        return this.radarCrossSectionSignatureRepresentationIndex;
    }

    public int getNumberOfPropulsionSystems() {
        return this.propulsionSystemData.size();
    }

    public void setNumberOfPropulsionSystems(int pNumberOfPropulsionSystems) {
        this.numberOfPropulsionSystems = pNumberOfPropulsionSystems;
    }

    public int getNumberOfVectoringNozzleSystems() {
        return this.vectoringSystemData.size();
    }

    public void setNumberOfVectoringNozzleSystems(int pNumberOfVectoringNozzleSystems) {
        this.numberOfVectoringNozzleSystems = pNumberOfVectoringNozzleSystems;
    }

    public void setPropulsionSystemData(List<PropulsionSystemData> pPropulsionSystemData) {
        this.propulsionSystemData = pPropulsionSystemData;
    }

    public List<PropulsionSystemData> getPropulsionSystemData() {
        return this.propulsionSystemData;
    }

    public void setVectoringSystemData(List<VectoringNozzleSystemData> pVectoringSystemData) {
        this.vectoringSystemData = pVectoringSystemData;
    }

    public List<VectoringNozzleSystemData> getVectoringSystemData() {
        return this.vectoringSystemData;
    }

    @Override
    public void marshal(ByteBuffer buff) {
        int idx;
        super.marshal(buff);
        this.orginatingEntityID.marshal(buff);
        buff.putShort((short)this.infraredSignatureRepresentationIndex);
        buff.putShort((short)this.acousticSignatureRepresentationIndex);
        buff.putShort((short)this.radarCrossSectionSignatureRepresentationIndex);
        buff.putShort((short)this.propulsionSystemData.size());
        buff.putShort((short)this.vectoringSystemData.size());
        for (idx = 0; idx < this.propulsionSystemData.size(); ++idx) {
            PropulsionSystemData aPropulsionSystemData = this.propulsionSystemData.get(idx);
            aPropulsionSystemData.marshal(buff);
        }
        for (idx = 0; idx < this.vectoringSystemData.size(); ++idx) {
            VectoringNozzleSystemData aVectoringNozzleSystemData = this.vectoringSystemData.get(idx);
            aVectoringNozzleSystemData.marshal(buff);
        }
    }

    @Override
    public void unmarshal(ByteBuffer buff) {
        Serializable anX;
        int idx;
        super.unmarshal(buff);
        this.orginatingEntityID.unmarshal(buff);
        this.infraredSignatureRepresentationIndex = buff.getShort() & 0xFFFF;
        this.acousticSignatureRepresentationIndex = buff.getShort() & 0xFFFF;
        this.radarCrossSectionSignatureRepresentationIndex = buff.getShort() & 0xFFFF;
        this.numberOfPropulsionSystems = buff.getShort() & 0xFFFF;
        this.numberOfVectoringNozzleSystems = buff.getShort() & 0xFFFF;
        for (idx = 0; idx < this.numberOfPropulsionSystems; ++idx) {
            anX = new PropulsionSystemData();
            ((PropulsionSystemData)anX).unmarshal(buff);
            this.propulsionSystemData.add((PropulsionSystemData)anX);
        }
        for (idx = 0; idx < this.numberOfVectoringNozzleSystems; ++idx) {
            anX = new VectoringNozzleSystemData();
            ((VectoringNozzleSystemData)anX).unmarshal(buff);
            this.vectoringSystemData.add((VectoringNozzleSystemData)anX);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        int idx;
        boolean ivarsEqual = true;
        if (!(obj instanceof SeesPdu)) {
            return false;
        }
        SeesPdu rhs = (SeesPdu)obj;
        if (!this.orginatingEntityID.equals(rhs.orginatingEntityID)) {
            ivarsEqual = false;
        }
        if (this.infraredSignatureRepresentationIndex != rhs.infraredSignatureRepresentationIndex) {
            ivarsEqual = false;
        }
        if (this.acousticSignatureRepresentationIndex != rhs.acousticSignatureRepresentationIndex) {
            ivarsEqual = false;
        }
        if (this.radarCrossSectionSignatureRepresentationIndex != rhs.radarCrossSectionSignatureRepresentationIndex) {
            ivarsEqual = false;
        }
        if (this.numberOfPropulsionSystems != rhs.numberOfPropulsionSystems) {
            ivarsEqual = false;
        }
        if (this.numberOfVectoringNozzleSystems != rhs.numberOfVectoringNozzleSystems) {
            ivarsEqual = false;
        }
        for (idx = 0; idx < this.propulsionSystemData.size(); ++idx) {
            if (this.propulsionSystemData.get(idx).equals(rhs.propulsionSystemData.get(idx))) continue;
            ivarsEqual = false;
        }
        for (idx = 0; idx < this.vectoringSystemData.size(); ++idx) {
            if (this.vectoringSystemData.get(idx).equals(rhs.vectoringSystemData.get(idx))) continue;
            ivarsEqual = false;
        }
        return ivarsEqual && super.equalsImpl(rhs);
    }
}

