/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis;

import edu.nps.moves.dis.EntityID;
import edu.nps.moves.dis.RadioCommunicationsFamilyPdu;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class SignalPdu
extends RadioCommunicationsFamilyPdu
implements Serializable {
    protected EntityID entityId = new EntityID();
    protected int radioId;
    protected int encodingScheme;
    protected int tdlType;
    protected long sampleRate;
    protected int dataLength;
    protected int samples;
    protected byte[] data = new byte[0];

    public SignalPdu() {
        this.setPduType((short)26);
    }

    @Override
    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize = super.getMarshalledSize();
        marshalSize += this.entityId.getMarshalledSize();
        marshalSize += 2;
        marshalSize += 2;
        marshalSize += 2;
        marshalSize += 4;
        marshalSize += 2;
        marshalSize += 2;
        marshalSize += this.data.length;
        switch (this.data.length % 4) {
            case 0: {
                break;
            }
            case 1: {
                marshalSize += 3;
                break;
            }
            case 2: {
                marshalSize += 2;
                break;
            }
            case 3: {
                ++marshalSize;
            }
        }
        return marshalSize;
    }

    public void setEntityId(EntityID pEntityId) {
        this.entityId = pEntityId;
    }

    public EntityID getEntityId() {
        return this.entityId;
    }

    public void setRadioId(int pRadioId) {
        this.radioId = pRadioId;
    }

    public int getRadioId() {
        return this.radioId;
    }

    public void setEncodingScheme(int pEncodingScheme) {
        this.encodingScheme = pEncodingScheme;
    }

    public int getEncodingScheme() {
        return this.encodingScheme;
    }

    public void setEncodingClass(int pEncodingClass) {
        int newEncodingClass = 0;
        int newEncodingScheme = 0;
        newEncodingClass = pEncodingClass << 14;
        newEncodingScheme = newEncodingClass | this.getEncodingType();
        this.setEncodingScheme(newEncodingScheme);
    }

    public int getEncodingClass() {
        int extractEncodingClass = 0;
        extractEncodingClass = this.getEncodingScheme() & 0xC000;
        return extractEncodingClass >>>= 14;
    }

    public void setEncodingType(int pEncodingType) {
        int newEncodingScheme = 0;
        newEncodingScheme = this.getEncodingScheme() & 0xC000;
        this.setEncodingScheme(newEncodingScheme |= pEncodingType);
    }

    public int getEncodingType() {
        int extractEncodingType = 0;
        extractEncodingType = this.getEncodingScheme() & 0x3FFF;
        return extractEncodingType;
    }

    public void setNumberofTDLMessages(int pEncodingType) {
        int newEncodingScheme = 0;
        newEncodingScheme = this.getEncodingScheme() & 0xC000;
        this.setEncodingScheme(newEncodingScheme |= pEncodingType);
    }

    public int getNumberofTDLMessages() {
        int extractEncodingType = 0;
        extractEncodingType = this.getEncodingScheme() & 0x3FFF;
        return extractEncodingType;
    }

    public void setTdlType(int pTdlType) {
        this.tdlType = pTdlType;
    }

    public int getTdlType() {
        return this.tdlType;
    }

    public void setSampleRate(long pSampleRate) {
        this.sampleRate = pSampleRate;
    }

    public long getSampleRate() {
        return this.sampleRate;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public void setDataLength(int pDataLength) {
        this.dataLength = pDataLength;
    }

    public void setSamples(int pSamples) {
        this.samples = pSamples;
    }

    public int getSamples() {
        return this.samples;
    }

    public void setData(byte[] pData) {
        this.data = pData;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    public void marshal(ByteBuffer buff) {
        super.marshal(buff);
        this.entityId.marshal(buff);
        buff.putShort((short)this.radioId);
        buff.putShort((short)this.encodingScheme);
        buff.putShort((short)this.tdlType);
        buff.putInt((int)this.sampleRate);
        buff.putShort((short)this.dataLength);
        buff.putShort((short)this.samples);
        int nrOfBytes = 0;
        nrOfBytes = this.dataLength / 8;
        buff.put(this.data);
        int paddingBytes = nrOfBytes % 4;
        switch (paddingBytes) {
            case 0: {
                break;
            }
            case 1: {
                buff.put((byte)0);
                buff.putShort((short)0);
                break;
            }
            case 2: {
                buff.putShort((short)0);
                break;
            }
            case 3: {
                buff.put((byte)0);
            }
        }
    }

    @Override
    public void unmarshal(ByteBuffer buff) {
        super.unmarshal(buff);
        this.entityId.unmarshal(buff);
        this.radioId = buff.getShort() & 0xFFFF;
        this.encodingScheme = buff.getShort() & 0xFFFF;
        this.tdlType = buff.getShort() & 0xFFFF;
        this.sampleRate = buff.getInt();
        this.dataLength = buff.getShort() & 0xFFFF;
        this.samples = buff.getShort() & 0xFFFF;
        int dataLengthBytes = this.dataLength / 8;
        this.data = new byte[dataLengthBytes];
        buff.get(this.data);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof SignalPdu)) {
            return false;
        }
        SignalPdu rhs = (SignalPdu)obj;
        if (!this.entityId.equals(rhs.entityId)) {
            ivarsEqual = false;
        }
        if (this.radioId != rhs.radioId) {
            ivarsEqual = false;
        }
        if (this.encodingScheme != rhs.encodingScheme) {
            ivarsEqual = false;
        }
        if (this.tdlType != rhs.tdlType) {
            ivarsEqual = false;
        }
        if (this.sampleRate != rhs.sampleRate) {
            ivarsEqual = false;
        }
        if (this.dataLength != rhs.dataLength) {
            ivarsEqual = false;
        }
        if (this.samples != rhs.samples) {
            ivarsEqual = false;
        }
        if (!Arrays.equals(this.data, rhs.data)) {
            ivarsEqual = false;
        }
        return ivarsEqual && super.equalsImpl(rhs);
    }
}

