/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis;

import edu.nps.moves.dis.EntityType;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class SilentEntitySystem {
    protected short entityNr;
    protected short recordNr;
    protected EntityType entityType = new EntityType();
    protected List<Integer> entityAppearanceList = new ArrayList<Integer>();

    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize += 2;
        marshalSize += 2;
        marshalSize += this.entityType.getMarshalledSize();
        return marshalSize += 4 * this.entityAppearanceList.size();
    }

    public void setNrOfSilentEntities(short aNr) {
        this.entityNr = aNr;
    }

    public short getNrOfSilentEntities() {
        return this.entityNr;
    }

    public void setNumberOfAppearanceRecords(short aNr) {
        this.recordNr = aNr;
    }

    public short getNumberOfAppearanceRecords() {
        return this.recordNr;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public void setEntityType(EntityType aggregateType) {
        this.entityType = aggregateType;
    }

    public void setEntityApperanceList(List<Integer> aList) {
        this.entityAppearanceList = aList;
    }

    public List<Integer> getEntityApperanceList() {
        return this.entityAppearanceList;
    }

    public void marshal(ByteBuffer buff) {
        buff.putShort(this.entityNr);
        buff.putShort(this.recordNr);
        this.entityType.marshal(buff);
        for (int i = 0; i < this.entityAppearanceList.size(); ++i) {
            buff.putInt(this.entityAppearanceList.get(i));
        }
    }

    public void unmarshal(ByteBuffer buff) {
        this.entityNr = (short)(buff.getShort() & 0xFF);
        this.recordNr = (short)(buff.getShort() & 0xFF);
        this.entityType.unmarshal(buff);
        for (int i = 0; i < this.recordNr; ++i) {
            this.entityAppearanceList.add(buff.getInt());
        }
    }

    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof SilentEntitySystem)) {
            return false;
        }
        SilentEntitySystem rhs = (SilentEntitySystem)obj;
        if (this.entityNr != rhs.entityNr) {
            ivarsEqual = false;
        }
        if (this.recordNr != rhs.recordNr) {
            ivarsEqual = false;
        }
        if (this.entityType != rhs.entityType) {
            ivarsEqual = false;
        }
        for (int i = 0; i < this.entityAppearanceList.size(); ++i) {
            if (this.entityAppearanceList.get(i) == rhs.getEntityApperanceList().get(i)) continue;
            ivarsEqual = false;
        }
        return ivarsEqual;
    }
}

