/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis;

import edu.nps.moves.disutil.CoordinateConversions;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class Vector3Double
implements Serializable {
    protected double x;
    protected double y;
    protected double z;

    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize += 8;
        marshalSize += 8;
        return marshalSize += 8;
    }

    public void setX(double pX) {
        this.x = pX;
    }

    public double getX() {
        return this.x;
    }

    public void setY(double pY) {
        this.y = pY;
    }

    public double getY() {
        return this.y;
    }

    public void setZ(double pZ) {
        this.z = pZ;
    }

    public double getZ() {
        return this.z;
    }

    public void marshal(ByteBuffer buff) {
        buff.putDouble(this.x);
        buff.putDouble(this.y);
        buff.putDouble(this.z);
    }

    public void unmarshal(ByteBuffer buff) {
        this.x = buff.getDouble();
        this.y = buff.getDouble();
        this.z = buff.getDouble();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof Vector3Double)) {
            return false;
        }
        Vector3Double rhs = (Vector3Double)obj;
        if (this.x != rhs.x) {
            ivarsEqual = false;
        }
        if (this.y != rhs.y) {
            ivarsEqual = false;
        }
        if (this.z != rhs.z) {
            ivarsEqual = false;
        }
        return ivarsEqual;
    }

    public double[] toArray() {
        return new double[]{this.x, this.y, this.z};
    }

    public void convertLatitudeLongitudeAltitudeToDis() {
        double radiansLat = Math.PI * this.x / 180.0;
        double radiansLon = Math.PI * this.y / 180.0;
        double[] xyz = CoordinateConversions.getXYZfromLatLonRadians(radiansLat, radiansLon, this.z);
        this.setX(xyz[0]);
        this.setY(xyz[1]);
        this.setZ(xyz[2]);
    }

    public void convertDisToLatitudeLongitudeAltitude() {
        double[] xyz = this.toArray();
        double[] result = CoordinateConversions.xyzToLatLonRadians(xyz);
        result[0] = result[0] * 180.0 / Math.PI;
        result[1] = result[1] * 180.0 / Math.PI;
        this.setX(result[0]);
        this.setY(result[1]);
        this.setZ(result[2]);
    }
}

