/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import edu.nps.moves.dis7.SimulationManagementWithReliabilityFamilyPdu;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class AcknowledgeReliablePdu
extends SimulationManagementWithReliabilityFamilyPdu
implements Serializable {
    protected int acknowledgeFlag;
    protected int responseFlag;
    protected long requestID;

    public AcknowledgeReliablePdu() {
        this.setPduType((short)55);
    }

    @Override
    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize = super.getMarshalledSize();
        marshalSize += 2;
        marshalSize += 2;
        return marshalSize += 4;
    }

    public void setAcknowledgeFlag(int pAcknowledgeFlag) {
        this.acknowledgeFlag = pAcknowledgeFlag;
    }

    public int getAcknowledgeFlag() {
        return this.acknowledgeFlag;
    }

    public void setResponseFlag(int pResponseFlag) {
        this.responseFlag = pResponseFlag;
    }

    public int getResponseFlag() {
        return this.responseFlag;
    }

    public void setRequestID(long pRequestID) {
        this.requestID = pRequestID;
    }

    public long getRequestID() {
        return this.requestID;
    }

    @Override
    public void marshal(DataOutputStream dos) {
        super.marshal(dos);
        try {
            dos.writeShort((short)this.acknowledgeFlag);
            dos.writeShort((short)this.responseFlag);
            dos.writeInt((int)this.requestID);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public void unmarshal(DataInputStream dis) {
        super.unmarshal(dis);
        try {
            this.acknowledgeFlag = dis.readUnsignedShort();
            this.responseFlag = dis.readUnsignedShort();
            this.requestID = dis.readInt();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public void marshal(ByteBuffer buff) {
        super.marshal(buff);
        buff.putShort((short)this.acknowledgeFlag);
        buff.putShort((short)this.responseFlag);
        buff.putInt((int)this.requestID);
    }

    @Override
    public void unmarshal(ByteBuffer buff) {
        super.unmarshal(buff);
        this.acknowledgeFlag = buff.getShort() & 0xFFFF;
        this.responseFlag = buff.getShort() & 0xFFFF;
        this.requestID = buff.getInt();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof AcknowledgeReliablePdu)) {
            return false;
        }
        AcknowledgeReliablePdu rhs = (AcknowledgeReliablePdu)obj;
        if (this.acknowledgeFlag != rhs.acknowledgeFlag) {
            ivarsEqual = false;
        }
        if (this.responseFlag != rhs.responseFlag) {
            ivarsEqual = false;
        }
        if (this.requestID != rhs.requestID) {
            ivarsEqual = false;
        }
        return ivarsEqual && super.equalsImpl(rhs);
    }
}

