/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import edu.nps.moves.dis7.AcousticBeamFundamentalParameter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class AcousticBeamData
implements Serializable {
    protected short beamDataLength;
    protected short beamIDNumber;
    protected int pad2;
    protected AcousticBeamFundamentalParameter fundamentalDataParameters = new AcousticBeamFundamentalParameter();

    public int getMarshalledSize() {
        int marshalSize = 0;
        ++marshalSize;
        ++marshalSize;
        marshalSize += 2;
        return marshalSize += this.fundamentalDataParameters.getMarshalledSize();
    }

    public void setBeamDataLength(short pBeamDataLength) {
        this.beamDataLength = pBeamDataLength;
    }

    public short getBeamDataLength() {
        return this.beamDataLength;
    }

    public void setBeamIDNumber(short pBeamIDNumber) {
        this.beamIDNumber = pBeamIDNumber;
    }

    public short getBeamIDNumber() {
        return this.beamIDNumber;
    }

    public void setPad2(int pPad2) {
        this.pad2 = pPad2;
    }

    public int getPad2() {
        return this.pad2;
    }

    public void setFundamentalDataParameters(AcousticBeamFundamentalParameter pFundamentalDataParameters) {
        this.fundamentalDataParameters = pFundamentalDataParameters;
    }

    public AcousticBeamFundamentalParameter getFundamentalDataParameters() {
        return this.fundamentalDataParameters;
    }

    public void marshal(ByteBuffer buff) {
        buff.put((byte)this.beamDataLength);
        buff.put((byte)this.beamIDNumber);
        buff.putShort((short)this.pad2);
        this.fundamentalDataParameters.marshal(buff);
    }

    public void unmarshal(ByteBuffer buff) {
        this.beamDataLength = (short)(buff.get() & 0xFF);
        this.beamIDNumber = (short)(buff.get() & 0xFF);
        this.pad2 = buff.getShort() & 0xFFFF;
        this.fundamentalDataParameters.unmarshal(buff);
    }

    public void marshal(DataOutputStream dos) {
        try {
            dos.writeByte((byte)this.beamDataLength);
            dos.writeByte((byte)this.beamIDNumber);
            dos.writeShort((short)this.pad2);
            this.fundamentalDataParameters.marshal(dos);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void unmarshal(DataInputStream dis) {
        try {
            this.beamDataLength = dis.readByte();
            this.beamIDNumber = dis.readByte();
            this.pad2 = dis.readShort();
            this.fundamentalDataParameters.unmarshal(dis);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof AcousticBeamData)) {
            return false;
        }
        AcousticBeamData rhs = (AcousticBeamData)obj;
        if (this.beamDataLength != rhs.beamDataLength) {
            ivarsEqual = false;
        }
        if (this.beamIDNumber != rhs.beamIDNumber) {
            ivarsEqual = false;
        }
        if (this.pad2 != rhs.pad2) {
            ivarsEqual = false;
        }
        if (!this.fundamentalDataParameters.equals(rhs.fundamentalDataParameters)) {
            ivarsEqual = false;
        }
        return ivarsEqual;
    }
}

