/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import edu.nps.moves.dis7.AcousticBeamData;
import edu.nps.moves.dis7.AcousticEmitterSystem;
import edu.nps.moves.dis7.Vector3Float;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class AcousticEmitterSystemData
implements Serializable {
    protected short emitterSystemDataLength;
    protected short numberOfBeams;
    protected int pad2;
    protected AcousticEmitterSystem acousticEmitterSystem = new AcousticEmitterSystem();
    protected Vector3Float emitterLocation = new Vector3Float();
    protected List<AcousticBeamData> beamRecords = new ArrayList<AcousticBeamData>();

    public int getMarshalledSize() {
        int marshalSize = 0;
        ++marshalSize;
        ++marshalSize;
        marshalSize += 2;
        marshalSize += this.acousticEmitterSystem.getMarshalledSize();
        marshalSize += this.emitterLocation.getMarshalledSize();
        for (int idx = 0; idx < this.beamRecords.size(); ++idx) {
            AcousticBeamData listElement = this.beamRecords.get(idx);
            marshalSize += listElement.getMarshalledSize();
        }
        return marshalSize;
    }

    public void setEmitterSystemDataLength(short pEmitterSystemDataLength) {
        this.emitterSystemDataLength = pEmitterSystemDataLength;
    }

    public short getEmitterSystemDataLength() {
        return this.emitterSystemDataLength;
    }

    public short getNumberOfBeams() {
        return (short)this.beamRecords.size();
    }

    public void setNumberOfBeams(short pNumberOfBeams) {
        this.numberOfBeams = pNumberOfBeams;
    }

    public void setPad2(int pPad2) {
        this.pad2 = pPad2;
    }

    public int getPad2() {
        return this.pad2;
    }

    public void setAcousticEmitterSystem(AcousticEmitterSystem pAcousticEmitterSystem) {
        this.acousticEmitterSystem = pAcousticEmitterSystem;
    }

    public AcousticEmitterSystem getAcousticEmitterSystem() {
        return this.acousticEmitterSystem;
    }

    public void setEmitterLocation(Vector3Float pEmitterLocation) {
        this.emitterLocation = pEmitterLocation;
    }

    public Vector3Float getEmitterLocation() {
        return this.emitterLocation;
    }

    public void setBeamRecords(List<AcousticBeamData> pBeamRecords) {
        this.beamRecords = pBeamRecords;
    }

    public List<AcousticBeamData> getBeamRecords() {
        return this.beamRecords;
    }

    public void marshal(ByteBuffer buff) {
        buff.put((byte)this.emitterSystemDataLength);
        buff.put((byte)this.beamRecords.size());
        buff.putShort((short)this.pad2);
        this.acousticEmitterSystem.marshal(buff);
        this.emitterLocation.marshal(buff);
        for (int idx = 0; idx < this.beamRecords.size(); ++idx) {
            AcousticBeamData aAcousticBeamData = this.beamRecords.get(idx);
            aAcousticBeamData.marshal(buff);
        }
    }

    public void unmarshal(ByteBuffer buff) {
        this.emitterSystemDataLength = (short)(buff.get() & 0xFF);
        this.numberOfBeams = (short)(buff.get() & 0xFF);
        this.pad2 = buff.getShort() & 0xFFFF;
        this.acousticEmitterSystem.unmarshal(buff);
        this.emitterLocation.unmarshal(buff);
        for (int idx = 0; idx < this.numberOfBeams; ++idx) {
            AcousticBeamData anX = new AcousticBeamData();
            anX.unmarshal(buff);
            this.beamRecords.add(anX);
        }
    }

    public void marshal(DataOutputStream dos) {
        try {
            dos.writeByte((byte)this.emitterSystemDataLength);
            dos.writeByte((byte)this.beamRecords.size());
            dos.writeShort((short)this.pad2);
            this.acousticEmitterSystem.marshal(dos);
            this.emitterLocation.marshal(dos);
            for (int idx = 0; idx < this.beamRecords.size(); ++idx) {
                AcousticBeamData aAcousticBeamData = this.beamRecords.get(idx);
                aAcousticBeamData.marshal(dos);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void unmarshal(DataInputStream dis) {
        try {
            this.emitterSystemDataLength = (short)(dis.read() & 0xFF);
            this.numberOfBeams = (short)(dis.read() & 0xFF);
            this.pad2 = dis.readShort() & 0xFFFF;
            this.acousticEmitterSystem.unmarshal(dis);
            this.emitterLocation.unmarshal(dis);
            for (int idx = 0; idx < this.numberOfBeams; ++idx) {
                AcousticBeamData anX = new AcousticBeamData();
                anX.unmarshal(dis);
                this.beamRecords.add(anX);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof AcousticEmitterSystemData)) {
            return false;
        }
        AcousticEmitterSystemData rhs = (AcousticEmitterSystemData)obj;
        if (this.emitterSystemDataLength != rhs.emitterSystemDataLength) {
            ivarsEqual = false;
        }
        if (this.numberOfBeams != rhs.numberOfBeams) {
            ivarsEqual = false;
        }
        if (this.pad2 != rhs.pad2) {
            ivarsEqual = false;
        }
        if (!this.acousticEmitterSystem.equals(rhs.acousticEmitterSystem)) {
            ivarsEqual = false;
        }
        if (!this.emitterLocation.equals(rhs.emitterLocation)) {
            ivarsEqual = false;
        }
        for (int idx = 0; idx < this.beamRecords.size(); ++idx) {
            if (this.beamRecords.get(idx).equals(rhs.beamRecords.get(idx))) continue;
            ivarsEqual = false;
        }
        return ivarsEqual;
    }
}

