/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import edu.nps.moves.dis7.EntityID;
import edu.nps.moves.dis7.FixedDatum;
import edu.nps.moves.dis7.SimulationManagementFamilyPdu;
import edu.nps.moves.dis7.VariableDatum;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class ActionRequestPdu
extends SimulationManagementFamilyPdu
implements Serializable {
    protected EntityID originatingID = new EntityID();
    protected EntityID receivingID = new EntityID();
    protected long requestID;
    protected long actionID;
    protected long numberOfFixedDatumRecords;
    protected long numberOfVariableDatumRecords;
    protected List<FixedDatum> fixedDatums = new ArrayList<FixedDatum>();
    protected List<VariableDatum> variableDatums = new ArrayList<VariableDatum>();

    public ActionRequestPdu() {
        this.setPduType((short)16);
    }

    @Override
    public int getMarshalledSize() {
        Serializable listElement;
        int idx;
        int marshalSize = 0;
        marshalSize = super.getMarshalledSize();
        marshalSize += this.originatingID.getMarshalledSize();
        marshalSize += this.receivingID.getMarshalledSize();
        marshalSize += 4;
        marshalSize += 4;
        marshalSize += 4;
        marshalSize += 4;
        for (idx = 0; idx < this.fixedDatums.size(); ++idx) {
            listElement = this.fixedDatums.get(idx);
            marshalSize += ((FixedDatum)listElement).getMarshalledSize();
        }
        for (idx = 0; idx < this.variableDatums.size(); ++idx) {
            listElement = this.variableDatums.get(idx);
            marshalSize += ((VariableDatum)listElement).getMarshalledSize();
        }
        return marshalSize;
    }

    public void setOriginatingID(EntityID pOriginatingID) {
        this.originatingID = pOriginatingID;
    }

    public EntityID getOriginatingID() {
        return this.originatingID;
    }

    public void setReceivingID(EntityID pReceivingID) {
        this.receivingID = pReceivingID;
    }

    public EntityID getReceivingID() {
        return this.receivingID;
    }

    public void setRequestID(long pRequestID) {
        this.requestID = pRequestID;
    }

    public long getRequestID() {
        return this.requestID;
    }

    public void setActionID(long pActionID) {
        this.actionID = pActionID;
    }

    public long getActionID() {
        return this.actionID;
    }

    public long getNumberOfFixedDatumRecords() {
        return this.fixedDatums.size();
    }

    public void setNumberOfFixedDatumRecords(long pNumberOfFixedDatumRecords) {
        this.numberOfFixedDatumRecords = pNumberOfFixedDatumRecords;
    }

    public long getNumberOfVariableDatumRecords() {
        return this.variableDatums.size();
    }

    public void setNumberOfVariableDatumRecords(long pNumberOfVariableDatumRecords) {
        this.numberOfVariableDatumRecords = pNumberOfVariableDatumRecords;
    }

    public void setFixedDatums(List<FixedDatum> pFixedDatums) {
        this.fixedDatums = pFixedDatums;
    }

    public List<FixedDatum> getFixedDatums() {
        return this.fixedDatums;
    }

    public void setVariableDatums(List<VariableDatum> pVariableDatums) {
        this.variableDatums = pVariableDatums;
    }

    public List<VariableDatum> getVariableDatums() {
        return this.variableDatums;
    }

    @Override
    public void marshal(DataOutputStream dos) {
        super.marshal(dos);
        try {
            int idx;
            this.originatingID.marshal(dos);
            this.receivingID.marshal(dos);
            dos.writeInt((int)this.requestID);
            dos.writeInt((int)this.actionID);
            dos.writeInt(this.fixedDatums.size());
            dos.writeInt(this.variableDatums.size());
            for (idx = 0; idx < this.fixedDatums.size(); ++idx) {
                FixedDatum aFixedDatum = this.fixedDatums.get(idx);
                aFixedDatum.marshal(dos);
            }
            for (idx = 0; idx < this.variableDatums.size(); ++idx) {
                VariableDatum aVariableDatum = this.variableDatums.get(idx);
                aVariableDatum.marshal(dos);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public void unmarshal(DataInputStream dis) {
        super.unmarshal(dis);
        try {
            Serializable anX;
            this.originatingID.unmarshal(dis);
            this.receivingID.unmarshal(dis);
            this.requestID = dis.readInt();
            this.actionID = dis.readInt();
            this.numberOfFixedDatumRecords = dis.readInt();
            this.numberOfVariableDatumRecords = dis.readInt();
            int idx = 0;
            while ((long)idx < this.numberOfFixedDatumRecords) {
                anX = new FixedDatum();
                ((FixedDatum)anX).unmarshal(dis);
                this.fixedDatums.add((FixedDatum)anX);
                ++idx;
            }
            idx = 0;
            while ((long)idx < this.numberOfVariableDatumRecords) {
                anX = new VariableDatum();
                ((VariableDatum)anX).unmarshal(dis);
                this.variableDatums.add((VariableDatum)anX);
                ++idx;
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public void marshal(ByteBuffer buff) {
        int idx;
        super.marshal(buff);
        this.originatingID.marshal(buff);
        this.receivingID.marshal(buff);
        buff.putInt((int)this.requestID);
        buff.putInt((int)this.actionID);
        buff.putInt(this.fixedDatums.size());
        buff.putInt(this.variableDatums.size());
        for (idx = 0; idx < this.fixedDatums.size(); ++idx) {
            FixedDatum aFixedDatum = this.fixedDatums.get(idx);
            aFixedDatum.marshal(buff);
        }
        for (idx = 0; idx < this.variableDatums.size(); ++idx) {
            VariableDatum aVariableDatum = this.variableDatums.get(idx);
            aVariableDatum.marshal(buff);
        }
    }

    @Override
    public void unmarshal(ByteBuffer buff) {
        Serializable anX;
        super.unmarshal(buff);
        this.originatingID.unmarshal(buff);
        this.receivingID.unmarshal(buff);
        this.requestID = buff.getInt();
        this.actionID = buff.getInt();
        this.numberOfFixedDatumRecords = buff.getInt();
        this.numberOfVariableDatumRecords = buff.getInt();
        int idx = 0;
        while ((long)idx < this.numberOfFixedDatumRecords) {
            anX = new FixedDatum();
            ((FixedDatum)anX).unmarshal(buff);
            this.fixedDatums.add((FixedDatum)anX);
            ++idx;
        }
        idx = 0;
        while ((long)idx < this.numberOfVariableDatumRecords) {
            anX = new VariableDatum();
            ((VariableDatum)anX).unmarshal(buff);
            this.variableDatums.add((VariableDatum)anX);
            ++idx;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        int idx;
        boolean ivarsEqual = true;
        if (!(obj instanceof ActionRequestPdu)) {
            return false;
        }
        ActionRequestPdu rhs = (ActionRequestPdu)obj;
        if (!this.originatingID.equals(rhs.originatingID)) {
            ivarsEqual = false;
        }
        if (!this.receivingID.equals(rhs.receivingID)) {
            ivarsEqual = false;
        }
        if (this.requestID != rhs.requestID) {
            ivarsEqual = false;
        }
        if (this.actionID != rhs.actionID) {
            ivarsEqual = false;
        }
        if (this.numberOfFixedDatumRecords != rhs.numberOfFixedDatumRecords) {
            ivarsEqual = false;
        }
        if (this.numberOfVariableDatumRecords != rhs.numberOfVariableDatumRecords) {
            ivarsEqual = false;
        }
        for (idx = 0; idx < this.fixedDatums.size(); ++idx) {
            if (this.fixedDatums.get(idx).equals(rhs.fixedDatums.get(idx))) continue;
            ivarsEqual = false;
        }
        for (idx = 0; idx < this.variableDatums.size(); ++idx) {
            if (this.variableDatums.get(idx).equals(rhs.variableDatums.get(idx))) continue;
            ivarsEqual = false;
        }
        return ivarsEqual && super.equalsImpl(rhs);
    }
}

