/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import edu.nps.moves.dis7.SimulationAddress;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class AggregateIdentifier
implements Serializable {
    protected SimulationAddress simulationAddress = new SimulationAddress();
    protected int aggregateID;

    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize += this.simulationAddress.getMarshalledSize();
        return marshalSize += 2;
    }

    public void setSimulationAddress(SimulationAddress pSimulationAddress) {
        this.simulationAddress = pSimulationAddress;
    }

    public SimulationAddress getSimulationAddress() {
        return this.simulationAddress;
    }

    public void setAggregateID(int pAggregateID) {
        this.aggregateID = pAggregateID;
    }

    public int getAggregateID() {
        return this.aggregateID;
    }

    public void marshal(DataOutputStream dos) {
        try {
            this.simulationAddress.marshal(dos);
            dos.writeShort((short)this.aggregateID);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void unmarshal(DataInputStream dis) {
        try {
            this.simulationAddress.unmarshal(dis);
            this.aggregateID = dis.readUnsignedShort();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void marshal(ByteBuffer buff) {
        this.simulationAddress.marshal(buff);
        buff.putShort((short)this.aggregateID);
    }

    public void unmarshal(ByteBuffer buff) {
        this.simulationAddress.unmarshal(buff);
        this.aggregateID = buff.getShort() & 0xFFFF;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof AggregateIdentifier)) {
            return false;
        }
        AggregateIdentifier rhs = (AggregateIdentifier)obj;
        if (!this.simulationAddress.equals(rhs.simulationAddress)) {
            ivarsEqual = false;
        }
        if (this.aggregateID != rhs.aggregateID) {
            ivarsEqual = false;
        }
        return ivarsEqual;
    }
}

