/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import edu.nps.moves.dis7.AggregateIdentifier;
import edu.nps.moves.dis7.AggregateMarking;
import edu.nps.moves.dis7.AggregateType;
import edu.nps.moves.dis7.EntityID;
import edu.nps.moves.dis7.EntityManagementFamilyPdu;
import edu.nps.moves.dis7.Orientation;
import edu.nps.moves.dis7.SilentAggregateSystem;
import edu.nps.moves.dis7.SilentEntitySystem;
import edu.nps.moves.dis7.VariableDatum;
import edu.nps.moves.dis7.Vector3Double;
import edu.nps.moves.dis7.Vector3Float;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class AggregateStatePdu
extends EntityManagementFamilyPdu
implements Serializable {
    protected AggregateIdentifier aggregateID = new AggregateIdentifier();
    protected short forceID;
    protected short aggregateState;
    protected AggregateType aggregateType = new AggregateType();
    protected long formation;
    protected AggregateMarking aggregateMarking = new AggregateMarking();
    protected Vector3Float dimensions = new Vector3Float();
    protected Orientation orientation = new Orientation();
    protected Vector3Double centerOfMass = new Vector3Double();
    protected Vector3Float velocity = new Vector3Float();
    protected int numberOfAggregateIds;
    protected int numberOfEntitiyIds;
    protected int numberOfSilentAggregateSystems;
    protected int numberOfSilentEntitySystems;
    protected List<AggregateIdentifier> aggregateIDList = new ArrayList<AggregateIdentifier>();
    protected List<EntityID> entityIDList = new ArrayList<EntityID>();
    protected short pad2;
    protected List<SilentAggregateSystem> silentAggregateSystemList = new ArrayList<SilentAggregateSystem>();
    protected List<SilentEntitySystem> silentEntitySystemList = new ArrayList<SilentEntitySystem>();
    protected long numberOfVariableDatumRecords;
    protected List<VariableDatum> variableDatumList = new ArrayList<VariableDatum>();

    public AggregateStatePdu() {
        this.setPduType((short)33);
    }

    @Override
    public int getMarshalledSize() {
        Object listElement;
        int idx;
        int marshalSize = 0;
        marshalSize += super.getMarshalledSize();
        marshalSize += this.aggregateID.getMarshalledSize();
        ++marshalSize;
        ++marshalSize;
        marshalSize += this.aggregateType.getMarshalledSize();
        marshalSize += 4;
        marshalSize += this.aggregateMarking.getMarshalledSize();
        marshalSize += this.dimensions.getMarshalledSize();
        marshalSize += this.orientation.getMarshalledSize();
        marshalSize += this.centerOfMass.getMarshalledSize();
        marshalSize += this.velocity.getMarshalledSize();
        marshalSize += 2;
        marshalSize += 2;
        marshalSize += 2;
        marshalSize += 2;
        for (idx = 0; idx < this.aggregateIDList.size(); ++idx) {
            listElement = this.aggregateIDList.get(idx);
            marshalSize += ((AggregateIdentifier)listElement).getMarshalledSize();
        }
        for (idx = 0; idx < this.entityIDList.size(); ++idx) {
            listElement = this.entityIDList.get(idx);
            marshalSize += ((EntityID)listElement).getMarshalledSize();
        }
        marshalSize += this.getPad2Bits() / 8;
        for (idx = 0; idx < this.silentAggregateSystemList.size(); ++idx) {
            listElement = this.silentAggregateSystemList.get(idx);
            marshalSize += ((SilentAggregateSystem)listElement).getMarshalledSize();
        }
        for (idx = 0; idx < this.silentEntitySystemList.size(); ++idx) {
            listElement = this.silentEntitySystemList.get(idx);
            marshalSize += ((SilentEntitySystem)listElement).getMarshalledSize();
        }
        marshalSize += 4;
        for (idx = 0; idx < this.variableDatumList.size(); ++idx) {
            listElement = this.variableDatumList.get(idx);
            marshalSize += ((VariableDatum)listElement).getMarshalledSize();
        }
        return marshalSize;
    }

    public short getPad2Bits() {
        int val = 16 * ((this.aggregateIDList.size() + this.entityIDList.size()) % 2);
        return (short)val;
    }

    public AggregateIdentifier getAggregateID() {
        return this.aggregateID;
    }

    public void setAggregateID(AggregateIdentifier aggregateID) {
        this.aggregateID = aggregateID;
    }

    public short getForceID() {
        return this.forceID;
    }

    public void setForceID(short forceID) {
        this.forceID = forceID;
    }

    public short getAggregateState() {
        return this.aggregateState;
    }

    public void setAggregateState(short aggregateState) {
        this.aggregateState = aggregateState;
    }

    public AggregateType getAggregateType() {
        return this.aggregateType;
    }

    public void setAggregateType(AggregateType aggregateType) {
        this.aggregateType = aggregateType;
    }

    public long getFormation() {
        return this.formation;
    }

    public void setFormation(long formation) {
        this.formation = formation;
    }

    public AggregateMarking getAggregateMarking() {
        return this.aggregateMarking;
    }

    public void setAggregateMarking(AggregateMarking aggregateMarking) {
        this.aggregateMarking = aggregateMarking;
    }

    public Vector3Float getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(Vector3Float dimensions) {
        this.dimensions = dimensions;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
    }

    public Vector3Double getCenterOfMass() {
        return this.centerOfMass;
    }

    public void setCenterOfMass(Vector3Double centerOfMass) {
        this.centerOfMass = centerOfMass;
    }

    public Vector3Float getVelocity() {
        return this.velocity;
    }

    public void setVelocity(Vector3Float velocity) {
        this.velocity = velocity;
    }

    public List<AggregateIdentifier> getAggregateIDList() {
        return this.aggregateIDList;
    }

    public void setAggregateIDList(List<AggregateIdentifier> aggregateIDList) {
        this.aggregateIDList = aggregateIDList;
    }

    public List<EntityID> getEntityIDList() {
        return this.entityIDList;
    }

    public void setEntityIDList(List<EntityID> entityIDList) {
        this.entityIDList = entityIDList;
    }

    public short getPad2() {
        return this.pad2;
    }

    public void setPad2(short pad2) {
        this.pad2 = pad2;
    }

    public List<SilentAggregateSystem> getSilentAggregateSystemList() {
        return this.silentAggregateSystemList;
    }

    public void setSilentAggregateSystemList(List<SilentAggregateSystem> silentAggregateSystemList) {
        this.silentAggregateSystemList = silentAggregateSystemList;
    }

    public List<SilentEntitySystem> getSilentEntitySystemList() {
        return this.silentEntitySystemList;
    }

    public void setSilentEntitySystemList(List<SilentEntitySystem> silentEntitySystemList) {
        this.silentEntitySystemList = silentEntitySystemList;
    }

    public List<VariableDatum> getVariableDatumList() {
        return this.variableDatumList;
    }

    public void setVariableDatumList(List<VariableDatum> variableDatumList) {
        this.variableDatumList = variableDatumList;
    }

    public int getNumberOfAggregateIds() {
        return this.numberOfAggregateIds;
    }

    public int getNumberOfEntitiyIds() {
        return this.numberOfEntitiyIds;
    }

    public int getNumberOfSilentAggregateSystems() {
        return this.numberOfSilentAggregateSystems;
    }

    public int getNumberOfSilentEntitySystems() {
        return this.numberOfSilentEntitySystems;
    }

    public long getNumberOfVariableDatumRecords() {
        return this.numberOfVariableDatumRecords;
    }

    @Override
    public void marshal(ByteBuffer buff) {
        int idx;
        super.marshal(buff);
        this.aggregateID.marshal(buff);
        buff.put((byte)this.forceID);
        buff.put((byte)this.aggregateState);
        this.aggregateType.marshal(buff);
        buff.putInt((int)this.formation);
        this.aggregateMarking.marshal(buff);
        this.dimensions.marshal(buff);
        this.orientation.marshal(buff);
        this.centerOfMass.marshal(buff);
        this.velocity.marshal(buff);
        buff.putShort((short)this.aggregateIDList.size());
        buff.putShort((short)this.entityIDList.size());
        buff.putShort((short)this.silentAggregateSystemList.size());
        buff.putShort((short)this.silentEntitySystemList.size());
        for (idx = 0; idx < this.aggregateIDList.size(); ++idx) {
            AggregateIdentifier aAggregateID = this.aggregateIDList.get(idx);
            aAggregateID.marshal(buff);
        }
        for (idx = 0; idx < this.entityIDList.size(); ++idx) {
            EntityID aEntityID = this.entityIDList.get(idx);
            aEntityID.marshal(buff);
        }
        if (this.getPad2Bits() / 8 == 2) {
            buff.putShort(this.pad2);
        }
        for (idx = 0; idx < this.silentAggregateSystemList.size(); ++idx) {
            SilentAggregateSystem aSilentAggregateSystem = this.silentAggregateSystemList.get(idx);
            aSilentAggregateSystem.marshal(buff);
        }
        for (idx = 0; idx < this.silentEntitySystemList.size(); ++idx) {
            SilentEntitySystem aSilentEntitySystem = this.silentEntitySystemList.get(idx);
            aSilentEntitySystem.marshal(buff);
        }
        buff.putInt(this.variableDatumList.size());
        for (idx = 0; idx < this.variableDatumList.size(); ++idx) {
            VariableDatum aVariableDatum = this.variableDatumList.get(idx);
            aVariableDatum.marshal(buff);
        }
    }

    @Override
    public void unmarshal(ByteBuffer buff) {
        Object anX;
        int idx;
        Serializable anX2;
        int idx2;
        super.unmarshal(buff);
        this.aggregateID.unmarshal(buff);
        this.forceID = (short)(buff.get() & 0xFF);
        this.aggregateState = (short)(buff.get() & 0xFF);
        this.aggregateType.unmarshal(buff);
        this.formation = buff.getInt();
        this.aggregateMarking.unmarshal(buff);
        this.dimensions.unmarshal(buff);
        this.orientation.unmarshal(buff);
        this.centerOfMass.unmarshal(buff);
        this.velocity.unmarshal(buff);
        this.numberOfAggregateIds = buff.getShort() & 0xFFFF;
        this.numberOfEntitiyIds = buff.getShort() & 0xFFFF;
        this.numberOfSilentAggregateSystems = buff.getShort() & 0xFFFF;
        this.numberOfSilentEntitySystems = buff.getShort() & 0xFFFF;
        for (idx2 = 0; idx2 < this.numberOfAggregateIds; ++idx2) {
            anX2 = new AggregateIdentifier();
            ((AggregateIdentifier)anX2).unmarshal(buff);
            this.aggregateIDList.add((AggregateIdentifier)anX2);
        }
        for (idx2 = 0; idx2 < this.numberOfEntitiyIds; ++idx2) {
            anX2 = new EntityID();
            ((EntityID)anX2).unmarshal(buff);
            this.entityIDList.add((EntityID)anX2);
        }
        int padBits = 16 * ((this.numberOfAggregateIds + this.numberOfEntitiyIds) % 2);
        if (padBits / 8 == 2) {
            this.pad2 = buff.getShort();
        }
        for (idx = 0; idx < this.numberOfSilentAggregateSystems; ++idx) {
            anX = new SilentAggregateSystem();
            ((SilentAggregateSystem)anX).unmarshal(buff);
            this.silentAggregateSystemList.add((SilentAggregateSystem)anX);
        }
        for (idx = 0; idx < this.numberOfSilentEntitySystems; ++idx) {
            anX = new SilentEntitySystem();
            ((SilentEntitySystem)anX).unmarshal(buff);
            this.silentEntitySystemList.add((SilentEntitySystem)anX);
        }
        this.numberOfVariableDatumRecords = buff.getInt();
        idx = 0;
        while ((long)idx < this.numberOfVariableDatumRecords) {
            anX = new VariableDatum();
            ((VariableDatum)anX).unmarshal(buff);
            this.variableDatumList.add((VariableDatum)anX);
            ++idx;
        }
    }

    @Override
    public void marshal(DataOutputStream dos) {
        super.marshal(dos);
        try {
            int idx;
            this.aggregateID.marshal(dos);
            dos.writeByte(this.forceID);
            dos.writeByte(this.aggregateState);
            this.aggregateType.marshal(dos);
            dos.writeInt((int)this.formation);
            this.aggregateMarking.marshal(dos);
            this.dimensions.marshal(dos);
            this.orientation.marshal(dos);
            this.centerOfMass.marshal(dos);
            this.velocity.marshal(dos);
            dos.writeShort((short)this.aggregateIDList.size());
            dos.writeShort((short)this.entityIDList.size());
            dos.writeShort((short)this.silentAggregateSystemList.size());
            dos.writeShort((short)this.silentEntitySystemList.size());
            for (idx = 0; idx < this.aggregateIDList.size(); ++idx) {
                AggregateIdentifier aAggregateID = this.aggregateIDList.get(idx);
                aAggregateID.marshal(dos);
            }
            for (idx = 0; idx < this.entityIDList.size(); ++idx) {
                EntityID aEntityID = this.entityIDList.get(idx);
                aEntityID.marshal(dos);
            }
            if (this.getPad2Bits() / 8 == 2) {
                dos.writeShort(this.pad2);
            }
            for (idx = 0; idx < this.silentAggregateSystemList.size(); ++idx) {
                SilentAggregateSystem aSilentAggregateSystem = this.silentAggregateSystemList.get(idx);
                aSilentAggregateSystem.marshal(dos);
            }
            for (idx = 0; idx < this.silentEntitySystemList.size(); ++idx) {
                SilentEntitySystem aSilentEntitySystem = this.silentEntitySystemList.get(idx);
                aSilentEntitySystem.marshal(dos);
            }
            dos.writeInt(this.variableDatumList.size());
            for (idx = 0; idx < this.variableDatumList.size(); ++idx) {
                VariableDatum aVariableDatum = this.variableDatumList.get(idx);
                aVariableDatum.marshal(dos);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public void unmarshal(DataInputStream dis) {
        super.unmarshal(dis);
        try {
            Object anX;
            int idx;
            Serializable anX2;
            int idx2;
            this.aggregateID.unmarshal(dis);
            this.forceID = dis.readByte();
            this.aggregateState = dis.readByte();
            this.aggregateType.unmarshal(dis);
            this.formation = dis.readInt();
            this.aggregateMarking.unmarshal(dis);
            this.dimensions.unmarshal(dis);
            this.orientation.unmarshal(dis);
            this.centerOfMass.unmarshal(dis);
            this.velocity.unmarshal(dis);
            this.numberOfAggregateIds = dis.readShort();
            this.numberOfEntitiyIds = dis.readShort();
            this.numberOfSilentAggregateSystems = dis.readShort();
            this.numberOfSilentEntitySystems = dis.readShort();
            for (idx2 = 0; idx2 < this.numberOfAggregateIds; ++idx2) {
                anX2 = new AggregateIdentifier();
                ((AggregateIdentifier)anX2).unmarshal(dis);
                this.aggregateIDList.add((AggregateIdentifier)anX2);
            }
            for (idx2 = 0; idx2 < this.numberOfEntitiyIds; ++idx2) {
                anX2 = new EntityID();
                ((EntityID)anX2).unmarshal(dis);
                this.entityIDList.add((EntityID)anX2);
            }
            int padBits = 16 * ((this.numberOfAggregateIds + this.numberOfEntitiyIds) % 2);
            if (padBits / 8 == 2) {
                this.pad2 = dis.readShort();
            }
            for (idx = 0; idx < this.numberOfSilentAggregateSystems; ++idx) {
                anX = new SilentAggregateSystem();
                ((SilentAggregateSystem)anX).unmarshal(dis);
                this.silentAggregateSystemList.add((SilentAggregateSystem)anX);
            }
            for (idx = 0; idx < this.numberOfSilentEntitySystems; ++idx) {
                anX = new SilentEntitySystem();
                ((SilentEntitySystem)anX).unmarshal(dis);
                this.silentEntitySystemList.add((SilentEntitySystem)anX);
            }
            this.numberOfVariableDatumRecords = dis.readInt();
            idx = 0;
            while ((long)idx < this.numberOfVariableDatumRecords) {
                anX = new VariableDatum();
                ((VariableDatum)anX).unmarshal(dis);
                this.variableDatumList.add((VariableDatum)anX);
                ++idx;
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        int idx;
        boolean ivarsEqual = true;
        if (!(obj instanceof AggregateStatePdu)) {
            return false;
        }
        AggregateStatePdu rhs = (AggregateStatePdu)obj;
        if (!this.aggregateID.equals(rhs.aggregateID)) {
            ivarsEqual = false;
        }
        if (this.forceID != rhs.forceID) {
            ivarsEqual = false;
        }
        if (this.aggregateState != rhs.aggregateState) {
            ivarsEqual = false;
        }
        if (!this.aggregateType.equals(rhs.aggregateType)) {
            ivarsEqual = false;
        }
        if (this.formation != rhs.formation) {
            ivarsEqual = false;
        }
        if (!this.aggregateMarking.equals(rhs.aggregateMarking)) {
            ivarsEqual = false;
        }
        if (!this.dimensions.equals(rhs.dimensions)) {
            ivarsEqual = false;
        }
        if (!this.orientation.equals(rhs.orientation)) {
            ivarsEqual = false;
        }
        if (!this.centerOfMass.equals(rhs.centerOfMass)) {
            ivarsEqual = false;
        }
        if (!this.velocity.equals(rhs.velocity)) {
            ivarsEqual = false;
        }
        if (this.numberOfAggregateIds != rhs.numberOfAggregateIds) {
            ivarsEqual = false;
        }
        if (this.numberOfEntitiyIds != rhs.numberOfEntitiyIds) {
            ivarsEqual = false;
        }
        if (this.numberOfSilentAggregateSystems != rhs.numberOfSilentAggregateSystems) {
            ivarsEqual = false;
        }
        if (this.numberOfSilentEntitySystems != rhs.numberOfSilentEntitySystems) {
            ivarsEqual = false;
        }
        for (idx = 0; idx < this.aggregateIDList.size(); ++idx) {
            if (this.aggregateIDList.get(idx).equals(rhs.aggregateIDList.get(idx))) continue;
            ivarsEqual = false;
        }
        for (idx = 0; idx < this.entityIDList.size(); ++idx) {
            if (this.entityIDList.get(idx).equals(rhs.entityIDList.get(idx))) continue;
            ivarsEqual = false;
        }
        if (this.pad2 != rhs.pad2) {
            ivarsEqual = false;
        }
        for (idx = 0; idx < this.silentAggregateSystemList.size(); ++idx) {
            if (this.silentAggregateSystemList.get(idx).equals(rhs.silentAggregateSystemList.get(idx))) continue;
            ivarsEqual = false;
        }
        for (idx = 0; idx < this.silentEntitySystemList.size(); ++idx) {
            if (this.silentEntitySystemList.get(idx).equals(rhs.silentEntitySystemList.get(idx))) continue;
            ivarsEqual = false;
        }
        if (this.numberOfVariableDatumRecords != rhs.numberOfVariableDatumRecords) {
            ivarsEqual = false;
        }
        for (idx = 0; idx < this.variableDatumList.size(); ++idx) {
            if (this.variableDatumList.get(idx).equals(rhs.variableDatumList.get(idx))) continue;
            ivarsEqual = false;
        }
        return ivarsEqual && super.equalsImpl(rhs);
    }
}

