/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import edu.nps.moves.dis7.EntityID;
import edu.nps.moves.dis7.EntityType;
import edu.nps.moves.dis7.SimulationAddress;
import edu.nps.moves.dis7.SyntheticEnvironmentFamilyPdu;
import edu.nps.moves.dis7.Vector3Double;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class ArealObjectStatePdu
extends SyntheticEnvironmentFamilyPdu
implements Serializable {
    protected EntityID objectID = new EntityID();
    protected EntityID referencedObjectID = new EntityID();
    protected int updateNumber;
    protected short forceID;
    protected short modifications;
    protected EntityType objectType = new EntityType();
    protected long specificObjectAppearance;
    protected int generalObjectAppearance;
    protected int numberOfPoints;
    protected SimulationAddress requesterID = new SimulationAddress();
    protected SimulationAddress receivingID = new SimulationAddress();
    protected List<Vector3Double> objectLocation = new ArrayList<Vector3Double>();

    public ArealObjectStatePdu() {
        this.setPduType((short)45);
    }

    @Override
    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize = super.getMarshalledSize();
        marshalSize += this.objectID.getMarshalledSize();
        marshalSize += this.referencedObjectID.getMarshalledSize();
        marshalSize += 2;
        ++marshalSize;
        ++marshalSize;
        marshalSize += this.objectType.getMarshalledSize();
        marshalSize += 4;
        marshalSize += 2;
        marshalSize += 2;
        marshalSize += this.requesterID.getMarshalledSize();
        marshalSize += this.receivingID.getMarshalledSize();
        for (int idx = 0; idx < this.objectLocation.size(); ++idx) {
            Vector3Double listElement = this.objectLocation.get(idx);
            marshalSize += listElement.getMarshalledSize();
        }
        return marshalSize;
    }

    public void setObjectID(EntityID pObjectID) {
        this.objectID = pObjectID;
    }

    public EntityID getObjectID() {
        return this.objectID;
    }

    public void setReferencedObjectID(EntityID pReferencedObjectID) {
        this.referencedObjectID = pReferencedObjectID;
    }

    public EntityID getReferencedObjectID() {
        return this.referencedObjectID;
    }

    public void setUpdateNumber(int pUpdateNumber) {
        this.updateNumber = pUpdateNumber;
    }

    public int getUpdateNumber() {
        return this.updateNumber;
    }

    public void setForceID(short pForceID) {
        this.forceID = pForceID;
    }

    public short getForceID() {
        return this.forceID;
    }

    public void setModifications(short pModifications) {
        this.modifications = pModifications;
    }

    public short getModifications() {
        return this.modifications;
    }

    public void setObjectType(EntityType pObjectType) {
        this.objectType = pObjectType;
    }

    public EntityType getObjectType() {
        return this.objectType;
    }

    public void setSpecificObjectAppearance(long pSpecificObjectAppearance) {
        this.specificObjectAppearance = pSpecificObjectAppearance;
    }

    public long getSpecificObjectAppearance() {
        return this.specificObjectAppearance;
    }

    public void setGeneralObjectAppearance(int pGeneralObjectAppearance) {
        this.generalObjectAppearance = pGeneralObjectAppearance;
    }

    public int getGeneralObjectAppearance() {
        return this.generalObjectAppearance;
    }

    public int getNumberOfPoints() {
        return this.objectLocation.size();
    }

    public void setNumberOfPoints(int pNumberOfPoints) {
        this.numberOfPoints = pNumberOfPoints;
    }

    public void setRequesterID(SimulationAddress pRequesterID) {
        this.requesterID = pRequesterID;
    }

    public SimulationAddress getRequesterID() {
        return this.requesterID;
    }

    public void setReceivingID(SimulationAddress pReceivingID) {
        this.receivingID = pReceivingID;
    }

    public SimulationAddress getReceivingID() {
        return this.receivingID;
    }

    public void setObjectLocation(List<Vector3Double> pObjectLocation) {
        this.objectLocation = pObjectLocation;
    }

    public List<Vector3Double> getObjectLocation() {
        return this.objectLocation;
    }

    @Override
    public void marshal(DataOutputStream dos) {
        super.marshal(dos);
        try {
            this.objectID.marshal(dos);
            this.referencedObjectID.marshal(dos);
            dos.writeShort((short)this.updateNumber);
            dos.writeByte((byte)this.forceID);
            dos.writeByte((byte)this.modifications);
            this.objectType.marshal(dos);
            dos.writeInt((int)this.specificObjectAppearance);
            dos.writeShort((short)this.generalObjectAppearance);
            dos.writeShort((short)this.objectLocation.size());
            this.requesterID.marshal(dos);
            this.receivingID.marshal(dos);
            for (int idx = 0; idx < this.objectLocation.size(); ++idx) {
                Vector3Double aVector3Double = this.objectLocation.get(idx);
                aVector3Double.marshal(dos);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public void unmarshal(DataInputStream dis) {
        super.unmarshal(dis);
        try {
            this.objectID.unmarshal(dis);
            this.referencedObjectID.unmarshal(dis);
            this.updateNumber = dis.readUnsignedShort();
            this.forceID = (short)dis.readUnsignedByte();
            this.modifications = (short)dis.readUnsignedByte();
            this.objectType.unmarshal(dis);
            this.specificObjectAppearance = dis.readInt();
            this.generalObjectAppearance = dis.readUnsignedShort();
            this.numberOfPoints = dis.readUnsignedShort();
            this.requesterID.unmarshal(dis);
            this.receivingID.unmarshal(dis);
            for (int idx = 0; idx < this.numberOfPoints; ++idx) {
                Vector3Double anX = new Vector3Double();
                anX.unmarshal(dis);
                this.objectLocation.add(anX);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public void marshal(ByteBuffer buff) {
        super.marshal(buff);
        this.objectID.marshal(buff);
        this.referencedObjectID.marshal(buff);
        buff.putShort((short)this.updateNumber);
        buff.put((byte)this.forceID);
        buff.put((byte)this.modifications);
        this.objectType.marshal(buff);
        buff.putInt((int)this.specificObjectAppearance);
        buff.putShort((short)this.generalObjectAppearance);
        buff.putShort((short)this.objectLocation.size());
        this.requesterID.marshal(buff);
        this.receivingID.marshal(buff);
        for (int idx = 0; idx < this.objectLocation.size(); ++idx) {
            Vector3Double aVector3Double = this.objectLocation.get(idx);
            aVector3Double.marshal(buff);
        }
    }

    @Override
    public void unmarshal(ByteBuffer buff) {
        super.unmarshal(buff);
        this.objectID.unmarshal(buff);
        this.referencedObjectID.unmarshal(buff);
        this.updateNumber = buff.getShort() & 0xFFFF;
        this.forceID = (short)(buff.get() & 0xFF);
        this.modifications = (short)(buff.get() & 0xFF);
        this.objectType.unmarshal(buff);
        this.specificObjectAppearance = buff.getInt();
        this.generalObjectAppearance = buff.getShort() & 0xFFFF;
        this.numberOfPoints = buff.getShort() & 0xFFFF;
        this.requesterID.unmarshal(buff);
        this.receivingID.unmarshal(buff);
        for (int idx = 0; idx < this.numberOfPoints; ++idx) {
            Vector3Double anX = new Vector3Double();
            anX.unmarshal(buff);
            this.objectLocation.add(anX);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof ArealObjectStatePdu)) {
            return false;
        }
        ArealObjectStatePdu rhs = (ArealObjectStatePdu)obj;
        if (!this.objectID.equals(rhs.objectID)) {
            ivarsEqual = false;
        }
        if (!this.referencedObjectID.equals(rhs.referencedObjectID)) {
            ivarsEqual = false;
        }
        if (this.updateNumber != rhs.updateNumber) {
            ivarsEqual = false;
        }
        if (this.forceID != rhs.forceID) {
            ivarsEqual = false;
        }
        if (this.modifications != rhs.modifications) {
            ivarsEqual = false;
        }
        if (!this.objectType.equals(rhs.objectType)) {
            ivarsEqual = false;
        }
        if (this.specificObjectAppearance != rhs.specificObjectAppearance) {
            ivarsEqual = false;
        }
        if (this.generalObjectAppearance != rhs.generalObjectAppearance) {
            ivarsEqual = false;
        }
        if (this.numberOfPoints != rhs.numberOfPoints) {
            ivarsEqual = false;
        }
        if (!this.requesterID.equals(rhs.requesterID)) {
            ivarsEqual = false;
        }
        if (!this.receivingID.equals(rhs.receivingID)) {
            ivarsEqual = false;
        }
        for (int idx = 0; idx < this.objectLocation.size(); ++idx) {
            if (this.objectLocation.get(idx).equals(rhs.objectLocation.get(idx))) continue;
            ivarsEqual = false;
        }
        return ivarsEqual && super.equalsImpl(rhs);
    }
}

