/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class Attribute
implements Serializable {
    protected long recordType;
    protected int recordLength;
    protected long recordSpecificFields;

    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize += 4;
        marshalSize += 2;
        return marshalSize += 8;
    }

    public void setRecordType(long pRecordType) {
        this.recordType = pRecordType;
    }

    public long getRecordType() {
        return this.recordType;
    }

    public void setRecordLength(int pRecordLength) {
        this.recordLength = pRecordLength;
    }

    public int getRecordLength() {
        return this.recordLength;
    }

    public void setRecordSpecificFields(long pRecordSpecificFields) {
        this.recordSpecificFields = pRecordSpecificFields;
    }

    public long getRecordSpecificFields() {
        return this.recordSpecificFields;
    }

    public void marshal(DataOutputStream dos) {
        try {
            dos.writeInt((int)this.recordType);
            dos.writeShort((short)this.recordLength);
            dos.writeLong(this.recordSpecificFields);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void unmarshal(DataInputStream dis) {
        try {
            this.recordType = dis.readInt();
            this.recordLength = dis.readUnsignedShort();
            this.recordSpecificFields = dis.readLong();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void marshal(ByteBuffer buff) {
        buff.putInt((int)this.recordType);
        buff.putShort((short)this.recordLength);
        buff.putLong(this.recordSpecificFields);
    }

    public void unmarshal(ByteBuffer buff) {
        this.recordType = buff.getInt();
        this.recordLength = buff.getShort() & 0xFFFF;
        this.recordSpecificFields = buff.getLong();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof Attribute)) {
            return false;
        }
        Attribute rhs = (Attribute)obj;
        if (this.recordType != rhs.recordType) {
            ivarsEqual = false;
        }
        if (this.recordLength != rhs.recordLength) {
            ivarsEqual = false;
        }
        if (this.recordSpecificFields != rhs.recordSpecificFields) {
            ivarsEqual = false;
        }
        return ivarsEqual;
    }
}

