/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import edu.nps.moves.dis7.AntennaPattern;
import edu.nps.moves.dis7.EulerAngles;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.nio.ByteBuffer;

public class BeamAntennaPattern
extends AntennaPattern {
    protected EulerAngles beamDirection = new EulerAngles();
    protected float azimuthBeamwidth = 0.0f;
    protected float elevationBeamwidth = 0.0f;
    protected short referenceSystem = 0;
    protected short padding1 = 0;
    protected int padding2 = 0;
    protected float ez = 0.0f;
    protected float ex = 0.0f;
    protected float phase = 0.0f;
    protected long padding3 = 0L;

    @Override
    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize += super.getMarshalledSize();
        marshalSize += this.beamDirection.getMarshalledSize();
        marshalSize += 4;
        marshalSize += 4;
        ++marshalSize;
        ++marshalSize;
        marshalSize += 2;
        marshalSize += 4;
        marshalSize += 4;
        marshalSize += 4;
        return marshalSize += 4;
    }

    public void setBeamDirection(EulerAngles pBeamDirection) {
        this.beamDirection = pBeamDirection;
    }

    public EulerAngles getBeamDirection() {
        return this.beamDirection;
    }

    public void setAzimuthBeamwidth(float pAzimuthBeamwidth) {
        this.azimuthBeamwidth = pAzimuthBeamwidth;
    }

    public float getAzimuthBeamwidth() {
        return this.azimuthBeamwidth;
    }

    public void setElevationBeamwidth(float pElevationBeamwidth) {
        this.elevationBeamwidth = pElevationBeamwidth;
    }

    public float getElevationBeamwidth() {
        return this.elevationBeamwidth;
    }

    public void setReferenceSystem(short pReferenceSystem) {
        this.referenceSystem = pReferenceSystem;
    }

    public short getReferenceSystem() {
        return this.referenceSystem;
    }

    public void setPadding1(short pPadding1) {
        this.padding1 = pPadding1;
    }

    public short getPadding1() {
        return this.padding1;
    }

    public void setPadding2(int pPadding2) {
        this.padding2 = pPadding2;
    }

    public int getPadding2() {
        return this.padding2;
    }

    public void setEz(float pEz) {
        this.ez = pEz;
    }

    public float getEz() {
        return this.ez;
    }

    public void setEx(float pEx) {
        this.ex = pEx;
    }

    public float getEx() {
        return this.ex;
    }

    public void setPhase(float pPhase) {
        this.phase = pPhase;
    }

    public float getPhase() {
        return this.phase;
    }

    public void setPadding3(long pPadding3) {
        this.padding3 = pPadding3;
    }

    public long getPadding3() {
        return this.padding3;
    }

    @Override
    public void marshal(DataOutputStream dos) {
        try {
            super.marshal(dos);
            this.beamDirection.marshal(dos);
            dos.writeFloat(this.azimuthBeamwidth);
            dos.writeFloat(this.elevationBeamwidth);
            dos.writeByte((byte)this.referenceSystem);
            dos.writeByte((byte)this.padding1);
            dos.writeShort((short)this.padding2);
            dos.writeFloat(this.ez);
            dos.writeFloat(this.ex);
            dos.writeFloat(this.phase);
            dos.writeInt((int)this.padding3);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public void unmarshal(DataInputStream dis) {
        try {
            super.unmarshal(dis);
            this.beamDirection.unmarshal(dis);
            this.azimuthBeamwidth = dis.readFloat();
            this.elevationBeamwidth = dis.readFloat();
            this.referenceSystem = (short)dis.readUnsignedByte();
            this.padding1 = (short)dis.readUnsignedByte();
            this.padding2 = dis.readUnsignedShort();
            this.ez = dis.readFloat();
            this.ex = dis.readFloat();
            this.phase = dis.readFloat();
            this.padding3 = dis.readInt();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public void marshal(ByteBuffer buff) {
        super.marshal(buff);
        this.beamDirection.marshal(buff);
        buff.putFloat(this.azimuthBeamwidth);
        buff.putFloat(this.elevationBeamwidth);
        buff.put((byte)this.referenceSystem);
        buff.put((byte)this.padding1);
        buff.putShort((short)this.padding2);
        buff.putFloat(this.ez);
        buff.putFloat(this.ex);
        buff.putFloat(this.phase);
        buff.putInt((int)this.padding3);
    }

    @Override
    public void unmarshal(ByteBuffer buff) {
        super.unmarshal(buff);
        this.beamDirection.unmarshal(buff);
        this.azimuthBeamwidth = buff.getFloat();
        this.elevationBeamwidth = buff.getFloat();
        this.referenceSystem = (short)(buff.get() & 0xFF);
        this.padding1 = (short)(buff.get() & 0xFF);
        this.padding2 = buff.getShort() & 0xFFFF;
        this.ez = buff.getFloat();
        this.ex = buff.getFloat();
        this.phase = buff.getFloat();
        this.padding3 = buff.getInt();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof BeamAntennaPattern)) {
            return false;
        }
        BeamAntennaPattern rhs = (BeamAntennaPattern)obj;
        if (!this.beamDirection.equals(rhs.beamDirection)) {
            ivarsEqual = false;
        }
        if (this.azimuthBeamwidth != rhs.azimuthBeamwidth) {
            ivarsEqual = false;
        }
        if (this.elevationBeamwidth != rhs.elevationBeamwidth) {
            ivarsEqual = false;
        }
        if (this.referenceSystem != rhs.referenceSystem) {
            ivarsEqual = false;
        }
        if (this.padding1 != rhs.padding1) {
            ivarsEqual = false;
        }
        if (this.padding2 != rhs.padding2) {
            ivarsEqual = false;
        }
        if (this.ez != rhs.ez) {
            ivarsEqual = false;
        }
        if (this.ex != rhs.ex) {
            ivarsEqual = false;
        }
        if (this.phase != rhs.phase) {
            ivarsEqual = false;
        }
        if (this.padding3 != rhs.padding3) {
            ivarsEqual = false;
        }
        return ivarsEqual;
    }
}

