/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import edu.nps.moves.dis7.EntityID;
import edu.nps.moves.dis7.EntityInformationFamilyPdu;
import edu.nps.moves.dis7.EventIdentifier;
import edu.nps.moves.dis7.Vector3Float;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class CollisionPdu
extends EntityInformationFamilyPdu
implements Serializable {
    protected EntityID issuingEntityID = new EntityID();
    protected EntityID collidingEntityID = new EntityID();
    protected EventIdentifier eventID = new EventIdentifier();
    protected short collisionType;
    protected byte pad = 0;
    protected Vector3Float velocity = new Vector3Float();
    protected float mass;
    protected Vector3Float location = new Vector3Float();

    public CollisionPdu() {
        this.setPduType((short)4);
        this.setProtocolFamily((short)1);
    }

    @Override
    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize = super.getMarshalledSize();
        marshalSize += this.issuingEntityID.getMarshalledSize();
        marshalSize += this.collidingEntityID.getMarshalledSize();
        marshalSize += this.eventID.getMarshalledSize();
        ++marshalSize;
        ++marshalSize;
        marshalSize += this.velocity.getMarshalledSize();
        marshalSize += 4;
        return marshalSize += this.location.getMarshalledSize();
    }

    public void setIssuingEntityID(EntityID pIssuingEntityID) {
        this.issuingEntityID = pIssuingEntityID;
    }

    public EntityID getIssuingEntityID() {
        return this.issuingEntityID;
    }

    public void setCollidingEntityID(EntityID pCollidingEntityID) {
        this.collidingEntityID = pCollidingEntityID;
    }

    public EntityID getCollidingEntityID() {
        return this.collidingEntityID;
    }

    public void setEventID(EventIdentifier pEventID) {
        this.eventID = pEventID;
    }

    public EventIdentifier getEventID() {
        return this.eventID;
    }

    public void setCollisionType(short pCollisionType) {
        this.collisionType = pCollisionType;
    }

    public short getCollisionType() {
        return this.collisionType;
    }

    public void setPad(byte pPad) {
        this.pad = pPad;
    }

    public byte getPad() {
        return this.pad;
    }

    public void setVelocity(Vector3Float pVelocity) {
        this.velocity = pVelocity;
    }

    public Vector3Float getVelocity() {
        return this.velocity;
    }

    public void setMass(float pMass) {
        this.mass = pMass;
    }

    public float getMass() {
        return this.mass;
    }

    public void setLocation(Vector3Float pLocation) {
        this.location = pLocation;
    }

    public Vector3Float getLocation() {
        return this.location;
    }

    @Override
    public void marshal(DataOutputStream dos) {
        super.marshal(dos);
        try {
            this.issuingEntityID.marshal(dos);
            this.collidingEntityID.marshal(dos);
            this.eventID.marshal(dos);
            dos.writeByte((byte)this.collisionType);
            dos.writeByte(this.pad);
            this.velocity.marshal(dos);
            dos.writeFloat(this.mass);
            this.location.marshal(dos);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public void unmarshal(DataInputStream dis) {
        super.unmarshal(dis);
        try {
            this.issuingEntityID.unmarshal(dis);
            this.collidingEntityID.unmarshal(dis);
            this.eventID.unmarshal(dis);
            this.collisionType = (short)dis.readUnsignedByte();
            this.pad = dis.readByte();
            this.velocity.unmarshal(dis);
            this.mass = dis.readFloat();
            this.location.unmarshal(dis);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public void marshal(ByteBuffer buff) {
        super.marshal(buff);
        this.issuingEntityID.marshal(buff);
        this.collidingEntityID.marshal(buff);
        this.eventID.marshal(buff);
        buff.put((byte)this.collisionType);
        buff.put(this.pad);
        this.velocity.marshal(buff);
        buff.putFloat(this.mass);
        this.location.marshal(buff);
    }

    @Override
    public void unmarshal(ByteBuffer buff) {
        super.unmarshal(buff);
        this.issuingEntityID.unmarshal(buff);
        this.collidingEntityID.unmarshal(buff);
        this.eventID.unmarshal(buff);
        this.collisionType = (short)(buff.get() & 0xFF);
        this.pad = buff.get();
        this.velocity.unmarshal(buff);
        this.mass = buff.getFloat();
        this.location.unmarshal(buff);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof CollisionPdu)) {
            return false;
        }
        CollisionPdu rhs = (CollisionPdu)obj;
        if (!this.issuingEntityID.equals(rhs.issuingEntityID)) {
            ivarsEqual = false;
        }
        if (!this.collidingEntityID.equals(rhs.collidingEntityID)) {
            ivarsEqual = false;
        }
        if (!this.eventID.equals(rhs.eventID)) {
            ivarsEqual = false;
        }
        if (this.collisionType != rhs.collisionType) {
            ivarsEqual = false;
        }
        if (this.pad != rhs.pad) {
            ivarsEqual = false;
        }
        if (!this.velocity.equals(rhs.velocity)) {
            ivarsEqual = false;
        }
        if (this.mass != rhs.mass) {
            ivarsEqual = false;
        }
        if (!this.location.equals(rhs.location)) {
            ivarsEqual = false;
        }
        return ivarsEqual && super.equalsImpl(rhs);
    }
}

