/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import edu.nps.moves.dis7.EntityID;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class CommunicationsNodeID
implements Serializable {
    protected EntityID entityID = new EntityID();
    protected int elementID;

    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize += this.entityID.getMarshalledSize();
        return marshalSize += 2;
    }

    public void setEntityID(EntityID pEntityID) {
        this.entityID = pEntityID;
    }

    public EntityID getEntityID() {
        return this.entityID;
    }

    public void setElementID(int pElementID) {
        this.elementID = pElementID;
    }

    public int getElementID() {
        return this.elementID;
    }

    public void marshal(DataOutputStream dos) {
        try {
            this.entityID.marshal(dos);
            dos.writeShort((short)this.elementID);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void unmarshal(DataInputStream dis) {
        try {
            this.entityID.unmarshal(dis);
            this.elementID = dis.readUnsignedShort();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void marshal(ByteBuffer buff) {
        this.entityID.marshal(buff);
        buff.putShort((short)this.elementID);
    }

    public void unmarshal(ByteBuffer buff) {
        this.entityID.unmarshal(buff);
        this.elementID = buff.getShort() & 0xFFFF;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof CommunicationsNodeID)) {
            return false;
        }
        CommunicationsNodeID rhs = (CommunicationsNodeID)obj;
        if (!this.entityID.equals(rhs.entityID)) {
            ivarsEqual = false;
        }
        if (this.elementID != rhs.elementID) {
            ivarsEqual = false;
        }
        return ivarsEqual;
    }
}

