/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import edu.nps.moves.dis7.FixedDatum;
import edu.nps.moves.dis7.SimulationManagementWithReliabilityFamilyPdu;
import edu.nps.moves.dis7.VariableDatum;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class DataReliablePdu
extends SimulationManagementWithReliabilityFamilyPdu
implements Serializable {
    protected long requestID;
    protected short requiredReliabilityService;
    protected int pad1;
    protected short pad2;
    protected long numberOfFixedDatumRecords;
    protected long numberOfVariableDatumRecords;
    protected List<FixedDatum> fixedDatumRecords = new ArrayList<FixedDatum>();
    protected List<VariableDatum> variableDatumRecords = new ArrayList<VariableDatum>();

    public DataReliablePdu() {
        this.setPduType((short)60);
    }

    @Override
    public int getMarshalledSize() {
        Serializable listElement;
        int idx;
        int marshalSize = 0;
        marshalSize = super.getMarshalledSize();
        marshalSize += 4;
        ++marshalSize;
        marshalSize += 2;
        ++marshalSize;
        marshalSize += 4;
        marshalSize += 4;
        for (idx = 0; idx < this.fixedDatumRecords.size(); ++idx) {
            listElement = this.fixedDatumRecords.get(idx);
            marshalSize += ((FixedDatum)listElement).getMarshalledSize();
        }
        for (idx = 0; idx < this.variableDatumRecords.size(); ++idx) {
            listElement = this.variableDatumRecords.get(idx);
            marshalSize += ((VariableDatum)listElement).getMarshalledSize();
        }
        return marshalSize;
    }

    public void setRequestID(long pRequestID) {
        this.requestID = pRequestID;
    }

    public long getRequestID() {
        return this.requestID;
    }

    public void setRequiredReliabilityService(short pRequiredReliabilityService) {
        this.requiredReliabilityService = pRequiredReliabilityService;
    }

    public short getRequiredReliabilityService() {
        return this.requiredReliabilityService;
    }

    public void setPad1(int pPad1) {
        this.pad1 = pPad1;
    }

    public int getPad1() {
        return this.pad1;
    }

    public void setPad2(short pPad2) {
        this.pad2 = pPad2;
    }

    public short getPad2() {
        return this.pad2;
    }

    public long getNumberOfFixedDatumRecords() {
        return this.fixedDatumRecords.size();
    }

    public void setNumberOfFixedDatumRecords(long pNumberOfFixedDatumRecords) {
        this.numberOfFixedDatumRecords = pNumberOfFixedDatumRecords;
    }

    public long getNumberOfVariableDatumRecords() {
        return this.variableDatumRecords.size();
    }

    public void setNumberOfVariableDatumRecords(long pNumberOfVariableDatumRecords) {
        this.numberOfVariableDatumRecords = pNumberOfVariableDatumRecords;
    }

    public void setFixedDatumRecords(List<FixedDatum> pFixedDatumRecords) {
        this.fixedDatumRecords = pFixedDatumRecords;
    }

    public List<FixedDatum> getFixedDatumRecords() {
        return this.fixedDatumRecords;
    }

    public void setVariableDatumRecords(List<VariableDatum> pVariableDatumRecords) {
        this.variableDatumRecords = pVariableDatumRecords;
    }

    public List<VariableDatum> getVariableDatumRecords() {
        return this.variableDatumRecords;
    }

    @Override
    public void marshal(DataOutputStream dos) {
        super.marshal(dos);
        try {
            int idx;
            dos.writeInt((int)this.requestID);
            dos.writeByte((byte)this.requiredReliabilityService);
            dos.writeShort((short)this.pad1);
            dos.writeByte((byte)this.pad2);
            dos.writeInt(this.fixedDatumRecords.size());
            dos.writeInt(this.variableDatumRecords.size());
            for (idx = 0; idx < this.fixedDatumRecords.size(); ++idx) {
                FixedDatum aFixedDatum = this.fixedDatumRecords.get(idx);
                aFixedDatum.marshal(dos);
            }
            for (idx = 0; idx < this.variableDatumRecords.size(); ++idx) {
                VariableDatum aVariableDatum = this.variableDatumRecords.get(idx);
                aVariableDatum.marshal(dos);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public void unmarshal(DataInputStream dis) {
        super.unmarshal(dis);
        try {
            Serializable anX;
            this.requestID = dis.readInt();
            this.requiredReliabilityService = (short)dis.readUnsignedByte();
            this.pad1 = dis.readUnsignedShort();
            this.pad2 = (short)dis.readUnsignedByte();
            this.numberOfFixedDatumRecords = dis.readInt();
            this.numberOfVariableDatumRecords = dis.readInt();
            int idx = 0;
            while ((long)idx < this.numberOfFixedDatumRecords) {
                anX = new FixedDatum();
                ((FixedDatum)anX).unmarshal(dis);
                this.fixedDatumRecords.add((FixedDatum)anX);
                ++idx;
            }
            idx = 0;
            while ((long)idx < this.numberOfVariableDatumRecords) {
                anX = new VariableDatum();
                ((VariableDatum)anX).unmarshal(dis);
                this.variableDatumRecords.add((VariableDatum)anX);
                ++idx;
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public void marshal(ByteBuffer buff) {
        int idx;
        super.marshal(buff);
        buff.putInt((int)this.requestID);
        buff.put((byte)this.requiredReliabilityService);
        buff.putShort((short)this.pad1);
        buff.put((byte)this.pad2);
        buff.putInt(this.fixedDatumRecords.size());
        buff.putInt(this.variableDatumRecords.size());
        for (idx = 0; idx < this.fixedDatumRecords.size(); ++idx) {
            FixedDatum aFixedDatum = this.fixedDatumRecords.get(idx);
            aFixedDatum.marshal(buff);
        }
        for (idx = 0; idx < this.variableDatumRecords.size(); ++idx) {
            VariableDatum aVariableDatum = this.variableDatumRecords.get(idx);
            aVariableDatum.marshal(buff);
        }
    }

    @Override
    public void unmarshal(ByteBuffer buff) {
        Serializable anX;
        super.unmarshal(buff);
        this.requestID = buff.getInt();
        this.requiredReliabilityService = (short)(buff.get() & 0xFF);
        this.pad1 = buff.getShort() & 0xFFFF;
        this.pad2 = (short)(buff.get() & 0xFF);
        this.numberOfFixedDatumRecords = buff.getInt();
        this.numberOfVariableDatumRecords = buff.getInt();
        int idx = 0;
        while ((long)idx < this.numberOfFixedDatumRecords) {
            anX = new FixedDatum();
            ((FixedDatum)anX).unmarshal(buff);
            this.fixedDatumRecords.add((FixedDatum)anX);
            ++idx;
        }
        idx = 0;
        while ((long)idx < this.numberOfVariableDatumRecords) {
            anX = new VariableDatum();
            ((VariableDatum)anX).unmarshal(buff);
            this.variableDatumRecords.add((VariableDatum)anX);
            ++idx;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        int idx;
        boolean ivarsEqual = true;
        if (!(obj instanceof DataReliablePdu)) {
            return false;
        }
        DataReliablePdu rhs = (DataReliablePdu)obj;
        if (this.requestID != rhs.requestID) {
            ivarsEqual = false;
        }
        if (this.requiredReliabilityService != rhs.requiredReliabilityService) {
            ivarsEqual = false;
        }
        if (this.pad1 != rhs.pad1) {
            ivarsEqual = false;
        }
        if (this.pad2 != rhs.pad2) {
            ivarsEqual = false;
        }
        if (this.numberOfFixedDatumRecords != rhs.numberOfFixedDatumRecords) {
            ivarsEqual = false;
        }
        if (this.numberOfVariableDatumRecords != rhs.numberOfVariableDatumRecords) {
            ivarsEqual = false;
        }
        for (idx = 0; idx < this.fixedDatumRecords.size(); ++idx) {
            if (this.fixedDatumRecords.get(idx).equals(rhs.fixedDatumRecords.get(idx))) continue;
            ivarsEqual = false;
        }
        for (idx = 0; idx < this.variableDatumRecords.size(); ++idx) {
            if (this.variableDatumRecords.get(idx).equals(rhs.variableDatumRecords.get(idx))) continue;
            ivarsEqual = false;
        }
        return ivarsEqual && super.equalsImpl(rhs);
    }
}

