/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import edu.nps.moves.dis7.Vector3Float;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class DeadReckoningParameters
implements Serializable {
    protected short deadReckoningAlgorithm;
    protected short[] parameters = new short[15];
    protected Vector3Float entityLinearAcceleration = new Vector3Float();
    protected Vector3Float entityAngularVelocity = new Vector3Float();

    public int getMarshalledSize() {
        int marshalSize = 0;
        ++marshalSize;
        marshalSize += 15;
        marshalSize += this.entityLinearAcceleration.getMarshalledSize();
        return marshalSize += this.entityAngularVelocity.getMarshalledSize();
    }

    public void setDeadReckoningAlgorithm(short pDeadReckoningAlgorithm) {
        this.deadReckoningAlgorithm = pDeadReckoningAlgorithm;
    }

    public short getDeadReckoningAlgorithm() {
        return this.deadReckoningAlgorithm;
    }

    public void setParameters(short[] pParameters) {
        this.parameters = pParameters;
    }

    public short[] getParameters() {
        return this.parameters;
    }

    public void setEntityLinearAcceleration(Vector3Float pEntityLinearAcceleration) {
        this.entityLinearAcceleration = pEntityLinearAcceleration;
    }

    public Vector3Float getEntityLinearAcceleration() {
        return this.entityLinearAcceleration;
    }

    public void setEntityAngularVelocity(Vector3Float pEntityAngularVelocity) {
        this.entityAngularVelocity = pEntityAngularVelocity;
    }

    public Vector3Float getEntityAngularVelocity() {
        return this.entityAngularVelocity;
    }

    public void marshal(DataOutputStream dos) {
        try {
            dos.writeByte((byte)this.deadReckoningAlgorithm);
            for (int idx = 0; idx < this.parameters.length; ++idx) {
                dos.writeByte(this.parameters[idx]);
            }
            this.entityLinearAcceleration.marshal(dos);
            this.entityAngularVelocity.marshal(dos);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void unmarshal(DataInputStream dis) {
        try {
            this.deadReckoningAlgorithm = (short)dis.readUnsignedByte();
            for (int idx = 0; idx < this.parameters.length; ++idx) {
                this.parameters[idx] = dis.readByte();
            }
            this.entityLinearAcceleration.unmarshal(dis);
            this.entityAngularVelocity.unmarshal(dis);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void marshal(ByteBuffer buff) {
        buff.put((byte)this.deadReckoningAlgorithm);
        for (int idx = 0; idx < this.parameters.length; ++idx) {
            buff.put((byte)this.parameters[idx]);
        }
        this.entityLinearAcceleration.marshal(buff);
        this.entityAngularVelocity.marshal(buff);
    }

    public void unmarshal(ByteBuffer buff) {
        this.deadReckoningAlgorithm = (short)(buff.get() & 0xFF);
        for (int idx = 0; idx < this.parameters.length; ++idx) {
            this.parameters[idx] = buff.get();
        }
        this.entityLinearAcceleration.unmarshal(buff);
        this.entityAngularVelocity.unmarshal(buff);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof DeadReckoningParameters)) {
            return false;
        }
        DeadReckoningParameters rhs = (DeadReckoningParameters)obj;
        if (this.deadReckoningAlgorithm != rhs.deadReckoningAlgorithm) {
            ivarsEqual = false;
        }
        for (int idx = 0; idx < 15; ++idx) {
            if (this.parameters[idx] == rhs.parameters[idx]) continue;
            ivarsEqual = false;
        }
        if (!this.entityLinearAcceleration.equals(rhs.entityLinearAcceleration)) {
            ivarsEqual = false;
        }
        if (!this.entityAngularVelocity.equals(rhs.entityAngularVelocity)) {
            ivarsEqual = false;
        }
        return ivarsEqual;
    }
}

