/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import edu.nps.moves.dis7.ArticulatedParts;
import edu.nps.moves.dis7.AttachedParts;
import edu.nps.moves.dis7.Descriptor;
import edu.nps.moves.dis7.EntityAssociation;
import edu.nps.moves.dis7.EntityID;
import edu.nps.moves.dis7.EntityTypeVP;
import edu.nps.moves.dis7.EventIdentifier;
import edu.nps.moves.dis7.ExpendableDescriptor;
import edu.nps.moves.dis7.ExplosionDescriptor;
import edu.nps.moves.dis7.MunitionDescriptor;
import edu.nps.moves.dis7.SeparationVP;
import edu.nps.moves.dis7.VariableParameter;
import edu.nps.moves.dis7.Vector3Double;
import edu.nps.moves.dis7.Vector3Float;
import edu.nps.moves.dis7.WarfareFamilyPdu;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class DetonationPdu
extends WarfareFamilyPdu
implements Serializable {
    protected EntityID explodingEntityID = new EntityID();
    protected EventIdentifier eventID = new EventIdentifier();
    protected Vector3Float velocity = new Vector3Float();
    protected Vector3Double locationInWorldCoordinates = new Vector3Double();
    protected Descriptor descriptor = new MunitionDescriptor();
    protected Vector3Float locationOfEntityCoordinates = new Vector3Float();
    protected short detonationResult;
    protected short numberOfVariableParameters;
    protected int pad;
    protected List<VariableParameter> variableParameters = new ArrayList<VariableParameter>();

    public DetonationPdu() {
        this.setPduType((short)3);
    }

    @Override
    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize = super.getMarshalledSize();
        marshalSize += this.explodingEntityID.getMarshalledSize();
        marshalSize += this.eventID.getMarshalledSize();
        marshalSize += this.velocity.getMarshalledSize();
        marshalSize += this.locationInWorldCoordinates.getMarshalledSize();
        int detonationTypeIndicator = this.getDetonationTypeIndicator();
        switch (detonationTypeIndicator) {
            default: {
                marshalSize += ((MunitionDescriptor)this.descriptor).getMarshalledSize();
                break;
            }
            case 1: {
                marshalSize += ((ExpendableDescriptor)this.descriptor).getMarshalledSize();
                break;
            }
            case 2: {
                marshalSize += ((ExplosionDescriptor)this.descriptor).getMarshalledSize();
            }
        }
        marshalSize += this.locationOfEntityCoordinates.getMarshalledSize();
        ++marshalSize;
        ++marshalSize;
        marshalSize += 2;
        block11: for (int idx = 0; idx < this.variableParameters.size(); ++idx) {
            VariableParameter listElement = this.variableParameters.get(idx);
            switch (listElement.recordType) {
                case 0: {
                    marshalSize += ((ArticulatedParts)listElement).getMarshalledSize();
                    continue block11;
                }
                case 1: {
                    marshalSize += ((AttachedParts)listElement).getMarshalledSize();
                    continue block11;
                }
                case 2: {
                    marshalSize += ((SeparationVP)listElement).getMarshalledSize();
                    continue block11;
                }
                case 3: {
                    marshalSize += ((EntityTypeVP)listElement).getMarshalledSize();
                    continue block11;
                }
                case 4: {
                    marshalSize += ((EntityAssociation)listElement).getMarshalledSize();
                }
            }
        }
        return marshalSize;
    }

    public void setExplodingEntityID(EntityID pExplodingEntityID) {
        this.explodingEntityID = pExplodingEntityID;
    }

    public EntityID getExplodingEntityID() {
        return this.explodingEntityID;
    }

    public void setEventID(EventIdentifier pEventID) {
        this.eventID = pEventID;
    }

    public EventIdentifier getEventID() {
        return this.eventID;
    }

    public void setVelocity(Vector3Float pVelocity) {
        this.velocity = pVelocity;
    }

    public Vector3Float getVelocity() {
        return this.velocity;
    }

    public void setLocationInWorldCoordinates(Vector3Double pLocationInWorldCoordinates) {
        this.locationInWorldCoordinates = pLocationInWorldCoordinates;
    }

    public Vector3Double getLocationInWorldCoordinates() {
        return this.locationInWorldCoordinates;
    }

    public void setDescriptor(Descriptor pDescriptor) {
        this.descriptor = pDescriptor;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setLocationOfEntityCoordinates(Vector3Float pLocationOfEntityCoordinates) {
        this.locationOfEntityCoordinates = pLocationOfEntityCoordinates;
    }

    public Vector3Float getLocationOfEntityCoordinates() {
        return this.locationOfEntityCoordinates;
    }

    public void setDetonationResult(short pDetonationResult) {
        this.detonationResult = pDetonationResult;
    }

    public short getDetonationResult() {
        return this.detonationResult;
    }

    public short getNumberOfVariableParameters() {
        return (short)this.variableParameters.size();
    }

    public void setNumberOfVariableParameters(short pNumberOfVariableParameters) {
        this.numberOfVariableParameters = pNumberOfVariableParameters;
    }

    public void setPad(int pPad) {
        this.pad = pPad;
    }

    public int getPad() {
        return this.pad;
    }

    public void setVariableParameters(List<VariableParameter> pVariableParameters) {
        this.variableParameters = pVariableParameters;
    }

    public List<VariableParameter> getVariableParameters() {
        return this.variableParameters;
    }

    @Override
    public void marshal(DataOutputStream dos) {
        super.marshal(dos);
        try {
            this.explodingEntityID.marshal(dos);
            this.eventID.marshal(dos);
            this.velocity.marshal(dos);
            this.locationInWorldCoordinates.marshal(dos);
            int detonationTypeIndicator = this.getDetonationTypeIndicator();
            switch (detonationTypeIndicator) {
                default: {
                    ((MunitionDescriptor)this.descriptor).marshal(dos);
                    break;
                }
                case 1: {
                    ((ExpendableDescriptor)this.descriptor).marshal(dos);
                    break;
                }
                case 2: {
                    ((ExplosionDescriptor)this.descriptor).marshal(dos);
                }
            }
            this.locationOfEntityCoordinates.marshal(dos);
            dos.writeByte((byte)this.detonationResult);
            dos.writeByte((byte)this.variableParameters.size());
            dos.writeShort((short)this.pad);
            block13: for (int idx = 0; idx < this.variableParameters.size(); ++idx) {
                VariableParameter aVariableParameter = this.variableParameters.get(idx);
                switch (aVariableParameter.recordType) {
                    case 0: {
                        ((ArticulatedParts)aVariableParameter).marshal(dos);
                        continue block13;
                    }
                    case 1: {
                        ((AttachedParts)aVariableParameter).marshal(dos);
                        continue block13;
                    }
                    case 2: {
                        ((SeparationVP)aVariableParameter).marshal(dos);
                        continue block13;
                    }
                    case 3: {
                        ((EntityTypeVP)aVariableParameter).marshal(dos);
                        continue block13;
                    }
                    case 4: {
                        ((EntityAssociation)aVariableParameter).marshal(dos);
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public void unmarshal(DataInputStream dis) {
        super.unmarshal(dis);
        try {
            this.explodingEntityID.unmarshal(dis);
            this.eventID.unmarshal(dis);
            this.velocity.unmarshal(dis);
            this.locationInWorldCoordinates.unmarshal(dis);
            int detonationTypeIndicator = this.getDetonationTypeIndicator();
            switch (detonationTypeIndicator) {
                default: {
                    this.descriptor = new MunitionDescriptor();
                    ((MunitionDescriptor)this.descriptor).unmarshal(dis);
                    break;
                }
                case 1: {
                    this.descriptor = new ExpendableDescriptor();
                    ((ExpendableDescriptor)this.descriptor).unmarshal(dis);
                    break;
                }
                case 2: {
                    this.descriptor = new ExplosionDescriptor();
                    ((ExplosionDescriptor)this.descriptor).unmarshal(dis);
                }
            }
            this.locationOfEntityCoordinates.unmarshal(dis);
            this.detonationResult = (short)dis.readUnsignedByte();
            this.numberOfVariableParameters = (short)dis.readUnsignedByte();
            this.pad = dis.readUnsignedShort();
            for (int idx = 0; idx < this.numberOfVariableParameters; ++idx) {
                VariableParameter anX = new VariableParameter();
                anX.unmarshal(dis);
                switch (anX.getRecordType()) {
                    case 0: {
                        anX = new ArticulatedParts();
                        ((ArticulatedParts)anX).unmarshal(dis);
                        break;
                    }
                    case 1: {
                        anX = new AttachedParts();
                        ((AttachedParts)anX).unmarshal(dis);
                        break;
                    }
                    case 2: {
                        anX = new SeparationVP();
                        ((SeparationVP)anX).unmarshal(dis);
                        break;
                    }
                    case 3: {
                        anX = new EntityTypeVP();
                        ((EntityTypeVP)anX).unmarshal(dis);
                        break;
                    }
                    case 4: {
                        anX = new EntityAssociation();
                        ((EntityAssociation)anX).unmarshal(dis);
                    }
                }
                this.variableParameters.add(anX);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public void marshal(ByteBuffer buff) {
        super.marshal(buff);
        this.explodingEntityID.marshal(buff);
        this.eventID.marshal(buff);
        this.velocity.marshal(buff);
        this.locationInWorldCoordinates.marshal(buff);
        int detonationTypeIndicator = this.getDetonationTypeIndicator();
        switch (detonationTypeIndicator) {
            default: {
                ((MunitionDescriptor)this.descriptor).marshal(buff);
                break;
            }
            case 1: {
                ((ExpendableDescriptor)this.descriptor).marshal(buff);
                break;
            }
            case 2: {
                ((ExplosionDescriptor)this.descriptor).marshal(buff);
            }
        }
        this.locationOfEntityCoordinates.marshal(buff);
        buff.put((byte)this.detonationResult);
        buff.put((byte)this.variableParameters.size());
        buff.putShort((short)this.pad);
        block11: for (int idx = 0; idx < this.variableParameters.size(); ++idx) {
            VariableParameter aVariableParameter = this.variableParameters.get(idx);
            switch (aVariableParameter.getRecordType()) {
                case 0: {
                    ((ArticulatedParts)aVariableParameter).marshal(buff);
                    continue block11;
                }
                case 1: {
                    ((AttachedParts)aVariableParameter).marshal(buff);
                    continue block11;
                }
                case 2: {
                    ((SeparationVP)aVariableParameter).marshal(buff);
                    continue block11;
                }
                case 3: {
                    ((EntityTypeVP)aVariableParameter).marshal(buff);
                    continue block11;
                }
                case 4: {
                    ((EntityAssociation)aVariableParameter).marshal(buff);
                }
            }
        }
    }

    @Override
    public void unmarshal(ByteBuffer buff) {
        super.unmarshal(buff);
        this.explodingEntityID.unmarshal(buff);
        this.eventID.unmarshal(buff);
        this.velocity.unmarshal(buff);
        this.locationInWorldCoordinates.unmarshal(buff);
        int detonationTypeIndicator = this.getDetonationTypeIndicator();
        switch (detonationTypeIndicator) {
            default: {
                this.descriptor = new MunitionDescriptor();
                ((MunitionDescriptor)this.descriptor).unmarshal(buff);
                break;
            }
            case 1: {
                this.descriptor = new ExpendableDescriptor();
                ((ExpendableDescriptor)this.descriptor).unmarshal(buff);
                break;
            }
            case 2: {
                this.descriptor = new ExplosionDescriptor();
                ((ExplosionDescriptor)this.descriptor).unmarshal(buff);
            }
        }
        this.locationOfEntityCoordinates.unmarshal(buff);
        this.detonationResult = (short)(buff.get() & 0xFF);
        this.numberOfVariableParameters = (short)(buff.get() & 0xFF);
        this.pad = buff.getShort() & 0xFFFF;
        for (int idx = 0; idx < this.numberOfVariableParameters; ++idx) {
            VariableParameter anX = new VariableParameter();
            anX.unmarshal(buff);
            switch (anX.getRecordType()) {
                case 0: {
                    anX = new ArticulatedParts();
                    ((ArticulatedParts)anX).unmarshal(buff);
                    break;
                }
                case 1: {
                    anX = new AttachedParts();
                    ((AttachedParts)anX).unmarshal(buff);
                    break;
                }
                case 2: {
                    anX = new SeparationVP();
                    ((SeparationVP)anX).unmarshal(buff);
                    break;
                }
                case 3: {
                    anX = new EntityTypeVP();
                    ((EntityTypeVP)anX).unmarshal(buff);
                    break;
                }
                case 4: {
                    anX = new EntityAssociation();
                    ((EntityAssociation)anX).unmarshal(buff);
                }
            }
            this.variableParameters.add(anX);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof DetonationPdu)) {
            return false;
        }
        DetonationPdu rhs = (DetonationPdu)obj;
        if (!this.explodingEntityID.equals(rhs.explodingEntityID)) {
            ivarsEqual = false;
        }
        if (!this.eventID.equals(rhs.eventID)) {
            ivarsEqual = false;
        }
        if (!this.velocity.equals(rhs.velocity)) {
            ivarsEqual = false;
        }
        if (!this.locationInWorldCoordinates.equals(rhs.locationInWorldCoordinates)) {
            ivarsEqual = false;
        }
        int detonationTypeIndicator = this.getDetonationTypeIndicator();
        switch (detonationTypeIndicator) {
            default: {
                if (((MunitionDescriptor)this.descriptor).equals((MunitionDescriptor)rhs.descriptor)) break;
                ivarsEqual = false;
                break;
            }
            case 1: {
                if (((ExpendableDescriptor)this.descriptor).equals((ExpendableDescriptor)rhs.descriptor)) break;
                ivarsEqual = false;
                break;
            }
            case 2: {
                if (((ExplosionDescriptor)this.descriptor).equals((ExplosionDescriptor)rhs.descriptor)) break;
                ivarsEqual = false;
            }
        }
        if (!this.descriptor.equals(rhs.descriptor)) {
            ivarsEqual = false;
        }
        if (!this.locationOfEntityCoordinates.equals(rhs.locationOfEntityCoordinates)) {
            ivarsEqual = false;
        }
        if (this.detonationResult != rhs.detonationResult) {
            ivarsEqual = false;
        }
        if (this.numberOfVariableParameters != rhs.numberOfVariableParameters) {
            ivarsEqual = false;
        }
        if (this.pad != rhs.pad) {
            ivarsEqual = false;
        }
        block11: for (int idx = 0; idx < this.variableParameters.size(); ++idx) {
            if (this.variableParameters.get(idx).getRecordType() != rhs.variableParameters.get(idx).getRecordType()) {
                ivarsEqual = false;
                continue;
            }
            switch (this.variableParameters.get(idx).getRecordType()) {
                case 0: {
                    if (((ArticulatedParts)this.variableParameters.get(idx)).equalsImpl((ArticulatedParts)rhs.variableParameters.get(idx))) continue block11;
                    ivarsEqual = false;
                    continue block11;
                }
                case 1: {
                    if (((AttachedParts)this.variableParameters.get(idx)).equalsImpl((AttachedParts)rhs.variableParameters.get(idx))) continue block11;
                    ivarsEqual = false;
                    continue block11;
                }
                case 2: {
                    if (((SeparationVP)this.variableParameters.get(idx)).equalsImpl((AttachedParts)rhs.variableParameters.get(idx))) continue block11;
                    ivarsEqual = false;
                    continue block11;
                }
                case 3: {
                    if (((EntityTypeVP)this.variableParameters.get(idx)).equalsImpl((EntityTypeVP)rhs.variableParameters.get(idx))) continue block11;
                    ivarsEqual = false;
                    continue block11;
                }
                case 4: {
                    if (((EntityAssociation)this.variableParameters.get(idx)).equalsImpl((EntityAssociation)rhs.variableParameters.get(idx))) continue block11;
                    ivarsEqual = false;
                }
            }
        }
        return ivarsEqual && super.equalsImpl(rhs);
    }

    private int getDetonationTypeIndicator() {
        return (this.pduStatus & 0x30) >> 4;
    }
}

