/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import edu.nps.moves.dis7.EventIdentifier;
import edu.nps.moves.dis7.Vector3Float;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class DirectedEnergyDamage
implements Serializable {
    protected long recordType = 4500L;
    protected int recordLength = 40;
    protected int padding = 0;
    protected Vector3Float damageLocation = new Vector3Float();
    protected float damageDiameter;
    protected float temperature = -273.15f;
    protected short componentIdentification;
    protected short componentDamageStatus;
    protected short componentVisualDamageStatus;
    protected short componentVisualSmokeColor;
    protected EventIdentifier fireEventID = new EventIdentifier();
    protected int padding2 = 0;

    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize += 4;
        marshalSize += 2;
        marshalSize += 2;
        marshalSize += this.damageLocation.getMarshalledSize();
        marshalSize += 4;
        marshalSize += 4;
        ++marshalSize;
        ++marshalSize;
        ++marshalSize;
        ++marshalSize;
        marshalSize += this.fireEventID.getMarshalledSize();
        return marshalSize += 2;
    }

    public void setRecordType(long pRecordType) {
        this.recordType = pRecordType;
    }

    public long getRecordType() {
        return this.recordType;
    }

    public void setRecordLength(int pRecordLength) {
        this.recordLength = pRecordLength;
    }

    public int getRecordLength() {
        return this.recordLength;
    }

    public void setPadding(int pPadding) {
        this.padding = pPadding;
    }

    public int getPadding() {
        return this.padding;
    }

    public void setDamageLocation(Vector3Float pDamageLocation) {
        this.damageLocation = pDamageLocation;
    }

    public Vector3Float getDamageLocation() {
        return this.damageLocation;
    }

    public void setDamageDiameter(float pDamageDiameter) {
        this.damageDiameter = pDamageDiameter;
    }

    public float getDamageDiameter() {
        return this.damageDiameter;
    }

    public void setTemperature(float pTemperature) {
        this.temperature = pTemperature;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public void setComponentIdentification(short pComponentIdentification) {
        this.componentIdentification = pComponentIdentification;
    }

    public short getComponentIdentification() {
        return this.componentIdentification;
    }

    public void setComponentDamageStatus(short pComponentDamageStatus) {
        this.componentDamageStatus = pComponentDamageStatus;
    }

    public short getComponentDamageStatus() {
        return this.componentDamageStatus;
    }

    public void setComponentVisualDamageStatus(short pComponentVisualDamageStatus) {
        this.componentVisualDamageStatus = pComponentVisualDamageStatus;
    }

    public short getComponentVisualDamageStatus() {
        return this.componentVisualDamageStatus;
    }

    public void setComponentVisualSmokeColor(short pComponentVisualSmokeColor) {
        this.componentVisualSmokeColor = pComponentVisualSmokeColor;
    }

    public short getComponentVisualSmokeColor() {
        return this.componentVisualSmokeColor;
    }

    public void setFireEventID(EventIdentifier pFireEventID) {
        this.fireEventID = pFireEventID;
    }

    public EventIdentifier getFireEventID() {
        return this.fireEventID;
    }

    public void setPadding2(int pPadding2) {
        this.padding2 = pPadding2;
    }

    public int getPadding2() {
        return this.padding2;
    }

    public void marshal(DataOutputStream dos) {
        try {
            dos.writeInt((int)this.recordType);
            dos.writeShort((short)this.recordLength);
            dos.writeShort((short)this.padding);
            this.damageLocation.marshal(dos);
            dos.writeFloat(this.damageDiameter);
            dos.writeFloat(this.temperature);
            dos.writeByte((byte)this.componentIdentification);
            dos.writeByte((byte)this.componentDamageStatus);
            dos.writeByte((byte)this.componentVisualDamageStatus);
            dos.writeByte((byte)this.componentVisualSmokeColor);
            this.fireEventID.marshal(dos);
            dos.writeShort((short)this.padding2);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void unmarshal(DataInputStream dis) {
        try {
            this.recordType = dis.readInt();
            this.recordLength = dis.readUnsignedShort();
            this.padding = dis.readUnsignedShort();
            this.damageLocation.unmarshal(dis);
            this.damageDiameter = dis.readFloat();
            this.temperature = dis.readFloat();
            this.componentIdentification = (short)dis.readUnsignedByte();
            this.componentDamageStatus = (short)dis.readUnsignedByte();
            this.componentVisualDamageStatus = (short)dis.readUnsignedByte();
            this.componentVisualSmokeColor = (short)dis.readUnsignedByte();
            this.fireEventID.unmarshal(dis);
            this.padding2 = dis.readUnsignedShort();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void marshal(ByteBuffer buff) {
        buff.putInt((int)this.recordType);
        buff.putShort((short)this.recordLength);
        buff.putShort((short)this.padding);
        this.damageLocation.marshal(buff);
        buff.putFloat(this.damageDiameter);
        buff.putFloat(this.temperature);
        buff.put((byte)this.componentIdentification);
        buff.put((byte)this.componentDamageStatus);
        buff.put((byte)this.componentVisualDamageStatus);
        buff.put((byte)this.componentVisualSmokeColor);
        this.fireEventID.marshal(buff);
        buff.putShort((short)this.padding2);
    }

    public void unmarshal(ByteBuffer buff) {
        this.recordType = buff.getInt();
        this.recordLength = buff.getShort() & 0xFFFF;
        this.padding = buff.getShort() & 0xFFFF;
        this.damageLocation.unmarshal(buff);
        this.damageDiameter = buff.getFloat();
        this.temperature = buff.getFloat();
        this.componentIdentification = (short)(buff.get() & 0xFF);
        this.componentDamageStatus = (short)(buff.get() & 0xFF);
        this.componentVisualDamageStatus = (short)(buff.get() & 0xFF);
        this.componentVisualSmokeColor = (short)(buff.get() & 0xFF);
        this.fireEventID.unmarshal(buff);
        this.padding2 = buff.getShort() & 0xFFFF;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof DirectedEnergyDamage)) {
            return false;
        }
        DirectedEnergyDamage rhs = (DirectedEnergyDamage)obj;
        if (this.recordType != rhs.recordType) {
            ivarsEqual = false;
        }
        if (this.recordLength != rhs.recordLength) {
            ivarsEqual = false;
        }
        if (this.padding != rhs.padding) {
            ivarsEqual = false;
        }
        if (!this.damageLocation.equals(rhs.damageLocation)) {
            ivarsEqual = false;
        }
        if (this.damageDiameter != rhs.damageDiameter) {
            ivarsEqual = false;
        }
        if (this.temperature != rhs.temperature) {
            ivarsEqual = false;
        }
        if (this.componentIdentification != rhs.componentIdentification) {
            ivarsEqual = false;
        }
        if (this.componentDamageStatus != rhs.componentDamageStatus) {
            ivarsEqual = false;
        }
        if (this.componentVisualDamageStatus != rhs.componentVisualDamageStatus) {
            ivarsEqual = false;
        }
        if (this.componentVisualSmokeColor != rhs.componentVisualSmokeColor) {
            ivarsEqual = false;
        }
        if (!this.fireEventID.equals(rhs.fireEventID)) {
            ivarsEqual = false;
        }
        if (this.padding2 != rhs.padding2) {
            ivarsEqual = false;
        }
        return ivarsEqual;
    }
}

