/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import edu.nps.moves.dis7.BeamData;
import edu.nps.moves.dis7.BeamStatus;
import edu.nps.moves.dis7.EEFundamentalParameterData;
import edu.nps.moves.dis7.JammingTechnique;
import edu.nps.moves.dis7.TrackJamData;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ElectronicEmissisionBeamData
implements Serializable {
    protected short beamDataLength;
    protected short beamNumber;
    protected int beamParameterIndex;
    protected EEFundamentalParameterData fundamentalParameterData = new EEFundamentalParameterData();
    protected BeamData beamData = new BeamData();
    protected short beamFunction;
    protected short numberOfTargets;
    protected short highDensityTrackJam;
    protected BeamStatus beamStatus = new BeamStatus();
    protected JammingTechnique jammingTechnique = new JammingTechnique();
    protected List<TrackJamData> trackJamData = new ArrayList<TrackJamData>();

    public int getMarshalledSize() {
        int marshalSize = 0;
        ++marshalSize;
        ++marshalSize;
        marshalSize += 2;
        marshalSize += this.fundamentalParameterData.getMarshalledSize();
        marshalSize += this.beamData.getMarshalledSize();
        ++marshalSize;
        ++marshalSize;
        ++marshalSize;
        marshalSize += this.beamStatus.getMarshalledSize();
        marshalSize += this.jammingTechnique.getMarshalledSize();
        for (int idx = 0; idx < this.trackJamData.size(); ++idx) {
            TrackJamData listElement = this.trackJamData.get(idx);
            marshalSize += listElement.getMarshalledSize();
        }
        return marshalSize;
    }

    public EEFundamentalParameterData getFundamentalParameterData() {
        return this.fundamentalParameterData;
    }

    public void setFundamentalParameterData(EEFundamentalParameterData fundamentalParameterData) {
        this.fundamentalParameterData = fundamentalParameterData;
    }

    public BeamData getBeamData() {
        return this.beamData;
    }

    public void setBeamData(BeamData beamData) {
        this.beamData = beamData;
    }

    public short getBeamFunction() {
        return this.beamFunction;
    }

    public void setBeamFunction(short beamFunction) {
        this.beamFunction = beamFunction;
    }

    public short getNumberOfTargets() {
        return this.numberOfTargets;
    }

    public void setNumberOfTargets(short numberOfTargets) {
        this.numberOfTargets = numberOfTargets;
    }

    public short getHighDensityTrackJam() {
        return this.highDensityTrackJam;
    }

    public void setHighDensityTrackJam(short highDensityTrackJam) {
        this.highDensityTrackJam = highDensityTrackJam;
    }

    public BeamStatus getBeamStatus() {
        return this.beamStatus;
    }

    public void setBeamStatus(BeamStatus beamStatus) {
        this.beamStatus = beamStatus;
    }

    public JammingTechnique getJammingTechnique() {
        return this.jammingTechnique;
    }

    public void setJammingTechnique(JammingTechnique jammingTechnique) {
        this.jammingTechnique = jammingTechnique;
    }

    public List<TrackJamData> getTrackJamData() {
        return this.trackJamData;
    }

    public void setTrackJamData(List<TrackJamData> trackJamData) {
        this.trackJamData = trackJamData;
    }

    public int getBeamDataLength() {
        return this.beamDataLength;
    }

    short calculateBeamDataLength() {
        return (short)(2 * this.getTrackJamData().size() + 13);
    }

    public void setBeamDataLength(short beamDataLength) {
        this.beamDataLength = beamDataLength;
    }

    public short getBeamNumber() {
        return this.beamNumber;
    }

    public void setBeamNumber(short pEmitterFunction) {
        this.beamNumber = pEmitterFunction;
    }

    public int getBeamParameterIndex() {
        return this.beamParameterIndex;
    }

    public void setBeamParameterIndex(short pEmitterIDNumber) {
        this.beamParameterIndex = pEmitterIDNumber;
    }

    public void marshal(DataOutputStream dos) {
        try {
            dos.writeByte((byte)this.beamDataLength);
            dos.writeByte((byte)this.beamNumber);
            dos.writeShort(this.beamParameterIndex);
            this.fundamentalParameterData.marshal(dos);
            this.beamData.marshal(dos);
            dos.writeByte((byte)this.beamFunction);
            dos.writeByte((byte)this.trackJamData.size());
            dos.writeByte((byte)this.highDensityTrackJam);
            this.beamStatus.marshal(dos);
            this.jammingTechnique.marshal(dos);
            for (int idx = 0; idx < this.trackJamData.size(); ++idx) {
                TrackJamData aTrackJamTarget = this.trackJamData.get(idx);
                aTrackJamTarget.marshal(dos);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void marshal(ByteBuffer buff) {
        buff.put((byte)this.beamDataLength);
        buff.put((byte)this.beamNumber);
        buff.putShort((short)this.beamParameterIndex);
        this.fundamentalParameterData.marshal(buff);
        this.beamData.marshal(buff);
        buff.put((byte)this.beamFunction);
        buff.put((byte)this.trackJamData.size());
        buff.put((byte)this.highDensityTrackJam);
        this.beamStatus.marshal(buff);
        this.jammingTechnique.marshal(buff);
        for (int idx = 0; idx < this.trackJamData.size(); ++idx) {
            TrackJamData aTrackJamTarget = this.trackJamData.get(idx);
            aTrackJamTarget.marshal(buff);
        }
    }

    public void unmarshal(DataInputStream dis) {
        try {
            this.beamDataLength = (short)dis.readUnsignedByte();
            this.beamNumber = (short)dis.readUnsignedByte();
            this.beamParameterIndex = dis.readUnsignedShort();
            this.fundamentalParameterData.unmarshal(dis);
            this.beamData.unmarshal(dis);
            this.beamFunction = dis.readByte();
            this.numberOfTargets = dis.readByte();
            this.highDensityTrackJam = dis.readByte();
            this.beamStatus.unmarshal(dis);
            this.jammingTechnique.unmarshal(dis);
            for (int idx = 0; idx < this.numberOfTargets; ++idx) {
                TrackJamData anX = new TrackJamData();
                anX.unmarshal(dis);
                this.trackJamData.add(anX);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void unmarshal(ByteBuffer buff) {
        this.beamDataLength = (short)(buff.get() & 0xFF);
        this.beamNumber = (short)(buff.get() & 0xFF);
        this.beamParameterIndex = buff.getShort() & 0xFFFF;
        this.fundamentalParameterData.unmarshal(buff);
        this.beamData.unmarshal(buff);
        this.beamFunction = (short)(buff.get() & 0xFF);
        this.numberOfTargets = (short)(buff.get() & 0xFF);
        this.highDensityTrackJam = (short)(buff.get() & 0xFF);
        this.beamStatus.unmarshal(buff);
        this.jammingTechnique.unmarshal(buff);
        for (int idx = 0; idx < this.numberOfTargets; ++idx) {
            TrackJamData anX = new TrackJamData();
            anX.unmarshal(buff);
            this.trackJamData.add(anX);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ElectronicEmissisionBeamData electronicEmissisionBeamData = (ElectronicEmissisionBeamData)o;
        return this.beamDataLength == electronicEmissisionBeamData.beamDataLength && this.beamNumber == electronicEmissisionBeamData.beamNumber && this.beamParameterIndex == electronicEmissisionBeamData.beamParameterIndex && this.beamFunction == electronicEmissisionBeamData.beamFunction && this.numberOfTargets == electronicEmissisionBeamData.numberOfTargets && this.highDensityTrackJam == electronicEmissisionBeamData.highDensityTrackJam && Objects.equals(this.fundamentalParameterData, electronicEmissisionBeamData.fundamentalParameterData) && Objects.equals(this.beamData, electronicEmissisionBeamData.beamData) && Objects.equals(this.beamStatus, electronicEmissisionBeamData.beamStatus) && Objects.equals(this.jammingTechnique, electronicEmissisionBeamData.jammingTechnique) && Objects.equals(this.trackJamData, electronicEmissisionBeamData.trackJamData);
    }

    public int hashCode() {
        return Objects.hash(this.beamDataLength, this.beamNumber, this.beamParameterIndex, this.fundamentalParameterData, this.beamData, this.beamFunction, this.numberOfTargets, this.highDensityTrackJam, this.beamStatus, this.jammingTechnique, this.trackJamData);
    }
}

