/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import edu.nps.moves.dis7.DirectedEnergyDamage;
import edu.nps.moves.dis7.EntityID;
import edu.nps.moves.dis7.WarfareFamilyPdu;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class EntityDamageStatusPdu
extends WarfareFamilyPdu
implements Serializable {
    protected EntityID damagedEntityID = new EntityID();
    protected int padding1 = 0;
    protected int padding2 = 0;
    protected int numberOfDamageDescription = 0;
    protected List<DirectedEnergyDamage> damageDescriptionRecords = new ArrayList<DirectedEnergyDamage>();

    public EntityDamageStatusPdu() {
        this.setPduType((short)69);
    }

    @Override
    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize = super.getMarshalledSize();
        marshalSize += this.damagedEntityID.getMarshalledSize();
        marshalSize += 2;
        marshalSize += 2;
        marshalSize += 2;
        for (int idx = 0; idx < this.damageDescriptionRecords.size(); ++idx) {
            DirectedEnergyDamage listElement = this.damageDescriptionRecords.get(idx);
            marshalSize += listElement.getMarshalledSize();
        }
        return marshalSize;
    }

    public void setDamagedEntityID(EntityID pDamagedEntityID) {
        this.damagedEntityID = pDamagedEntityID;
    }

    public EntityID getDamagedEntityID() {
        return this.damagedEntityID;
    }

    public void setPadding1(int pPadding1) {
        this.padding1 = pPadding1;
    }

    public int getPadding1() {
        return this.padding1;
    }

    public void setPadding2(int pPadding2) {
        this.padding2 = pPadding2;
    }

    public int getPadding2() {
        return this.padding2;
    }

    public int getNumberOfDamageDescription() {
        return this.damageDescriptionRecords.size();
    }

    public void setNumberOfDamageDescription(int pNumberOfDamageDescription) {
        this.numberOfDamageDescription = pNumberOfDamageDescription;
    }

    public void setDamageDescriptionRecords(List<DirectedEnergyDamage> pDamageDescriptionRecords) {
        this.damageDescriptionRecords = pDamageDescriptionRecords;
    }

    public List<DirectedEnergyDamage> getDamageDescriptionRecords() {
        return this.damageDescriptionRecords;
    }

    @Override
    public void marshal(DataOutputStream dos) {
        super.marshal(dos);
        try {
            this.damagedEntityID.marshal(dos);
            dos.writeShort((short)this.padding1);
            dos.writeShort((short)this.padding2);
            dos.writeShort((short)this.damageDescriptionRecords.size());
            for (int idx = 0; idx < this.damageDescriptionRecords.size(); ++idx) {
                DirectedEnergyDamage aDirectedEnergyDamage = this.damageDescriptionRecords.get(idx);
                aDirectedEnergyDamage.marshal(dos);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public void unmarshal(DataInputStream dis) {
        super.unmarshal(dis);
        try {
            this.damagedEntityID.unmarshal(dis);
            this.padding1 = dis.readUnsignedShort();
            this.padding2 = dis.readUnsignedShort();
            this.numberOfDamageDescription = dis.readUnsignedShort();
            for (int idx = 0; idx < this.numberOfDamageDescription; ++idx) {
                DirectedEnergyDamage anX = new DirectedEnergyDamage();
                anX.unmarshal(dis);
                this.damageDescriptionRecords.add(anX);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public void marshal(ByteBuffer buff) {
        super.marshal(buff);
        this.damagedEntityID.marshal(buff);
        buff.putShort((short)this.padding1);
        buff.putShort((short)this.padding2);
        buff.putShort((short)this.damageDescriptionRecords.size());
        for (int idx = 0; idx < this.damageDescriptionRecords.size(); ++idx) {
            DirectedEnergyDamage aDirectedEnergyDamage = this.damageDescriptionRecords.get(idx);
            aDirectedEnergyDamage.marshal(buff);
        }
    }

    @Override
    public void unmarshal(ByteBuffer buff) {
        super.unmarshal(buff);
        this.damagedEntityID.unmarshal(buff);
        this.padding1 = buff.getShort() & 0xFFFF;
        this.padding2 = buff.getShort() & 0xFFFF;
        this.numberOfDamageDescription = buff.getShort() & 0xFFFF;
        for (int idx = 0; idx < this.numberOfDamageDescription; ++idx) {
            DirectedEnergyDamage anX = new DirectedEnergyDamage();
            anX.unmarshal(buff);
            this.damageDescriptionRecords.add(anX);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof EntityDamageStatusPdu)) {
            return false;
        }
        EntityDamageStatusPdu rhs = (EntityDamageStatusPdu)obj;
        if (!this.damagedEntityID.equals(rhs.damagedEntityID)) {
            ivarsEqual = false;
        }
        if (this.padding1 != rhs.padding1) {
            ivarsEqual = false;
        }
        if (this.padding2 != rhs.padding2) {
            ivarsEqual = false;
        }
        if (this.numberOfDamageDescription != rhs.numberOfDamageDescription) {
            ivarsEqual = false;
        }
        for (int idx = 0; idx < this.damageDescriptionRecords.size(); ++idx) {
            if (this.damageDescriptionRecords.get(idx).equals(rhs.damageDescriptionRecords.get(idx))) continue;
            ivarsEqual = false;
        }
        return ivarsEqual && super.equalsImpl(rhs);
    }
}

