/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import edu.nps.moves.dis7.SimulationAddress;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class EventIdentifier
implements Serializable {
    protected SimulationAddress simulationAddress = new SimulationAddress();
    protected int eventNumber;

    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize += this.simulationAddress.getMarshalledSize();
        return marshalSize += 2;
    }

    public void setSimulationAddress(SimulationAddress pSimulationAddress) {
        this.simulationAddress = pSimulationAddress;
    }

    public SimulationAddress getSimulationAddress() {
        return this.simulationAddress;
    }

    public void setEventNumber(int pEventNumber) {
        this.eventNumber = pEventNumber;
    }

    public int getEventNumber() {
        return this.eventNumber;
    }

    public void marshal(DataOutputStream dos) {
        try {
            this.simulationAddress.marshal(dos);
            dos.writeShort((short)this.eventNumber);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void unmarshal(DataInputStream dis) {
        try {
            this.simulationAddress.unmarshal(dis);
            this.eventNumber = dis.readUnsignedShort();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void marshal(ByteBuffer buff) {
        this.simulationAddress.marshal(buff);
        buff.putShort((short)this.eventNumber);
    }

    public void unmarshal(ByteBuffer buff) {
        this.simulationAddress.unmarshal(buff);
        this.eventNumber = buff.getShort() & 0xFFFF;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof EventIdentifier)) {
            return false;
        }
        EventIdentifier rhs = (EventIdentifier)obj;
        if (!this.simulationAddress.equals(rhs.simulationAddress)) {
            ivarsEqual = false;
        }
        if (this.eventNumber != rhs.eventNumber) {
            ivarsEqual = false;
        }
        return ivarsEqual;
    }
}

