/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import edu.nps.moves.dis7.FixedDatum;
import edu.nps.moves.dis7.SimulationManagementFamilyPdu;
import edu.nps.moves.dis7.VariableDatum;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class EventReportPdu
extends SimulationManagementFamilyPdu
implements Serializable {
    protected long eventType;
    protected long padding1 = 0L;
    protected long numberOfFixedDatumRecords;
    protected long numberOfVariableDatumRecords;
    protected List<FixedDatum> fixedDatums = new ArrayList<FixedDatum>();
    protected List<VariableDatum> variableDatums = new ArrayList<VariableDatum>();

    public EventReportPdu() {
        this.setPduType((short)21);
    }

    @Override
    public int getMarshalledSize() {
        Serializable listElement;
        int idx;
        int marshalSize = 0;
        marshalSize = super.getMarshalledSize();
        marshalSize += 4;
        marshalSize += 4;
        marshalSize += 4;
        marshalSize += 4;
        for (idx = 0; idx < this.fixedDatums.size(); ++idx) {
            listElement = this.fixedDatums.get(idx);
            marshalSize += ((FixedDatum)listElement).getMarshalledSize();
        }
        for (idx = 0; idx < this.variableDatums.size(); ++idx) {
            listElement = this.variableDatums.get(idx);
            marshalSize += ((VariableDatum)listElement).getMarshalledSize();
        }
        return marshalSize;
    }

    public void setEventType(long pEventType) {
        this.eventType = pEventType;
    }

    public long getEventType() {
        return this.eventType;
    }

    public void setPadding1(long pPadding1) {
        this.padding1 = pPadding1;
    }

    public long getPadding1() {
        return this.padding1;
    }

    public long getNumberOfFixedDatumRecords() {
        return this.fixedDatums.size();
    }

    public void setNumberOfFixedDatumRecords(long pNumberOfFixedDatumRecords) {
        this.numberOfFixedDatumRecords = pNumberOfFixedDatumRecords;
    }

    public long getNumberOfVariableDatumRecords() {
        return this.variableDatums.size();
    }

    public void setNumberOfVariableDatumRecords(long pNumberOfVariableDatumRecords) {
        this.numberOfVariableDatumRecords = pNumberOfVariableDatumRecords;
    }

    public void setFixedDatums(List<FixedDatum> pFixedDatums) {
        this.fixedDatums = pFixedDatums;
    }

    public List<FixedDatum> getFixedDatums() {
        return this.fixedDatums;
    }

    public void setVariableDatums(List<VariableDatum> pVariableDatums) {
        this.variableDatums = pVariableDatums;
    }

    public List<VariableDatum> getVariableDatums() {
        return this.variableDatums;
    }

    @Override
    public void marshal(DataOutputStream dos) {
        super.marshal(dos);
        try {
            int idx;
            dos.writeInt((int)this.eventType);
            dos.writeInt((int)this.padding1);
            dos.writeInt(this.fixedDatums.size());
            dos.writeInt(this.variableDatums.size());
            for (idx = 0; idx < this.fixedDatums.size(); ++idx) {
                FixedDatum aFixedDatum = this.fixedDatums.get(idx);
                aFixedDatum.marshal(dos);
            }
            for (idx = 0; idx < this.variableDatums.size(); ++idx) {
                VariableDatum aVariableDatum = this.variableDatums.get(idx);
                aVariableDatum.marshal(dos);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public void unmarshal(DataInputStream dis) {
        super.unmarshal(dis);
        try {
            Serializable anX;
            this.eventType = dis.readInt();
            this.padding1 = dis.readInt();
            this.numberOfFixedDatumRecords = dis.readInt();
            this.numberOfVariableDatumRecords = dis.readInt();
            int idx = 0;
            while ((long)idx < this.numberOfFixedDatumRecords) {
                anX = new FixedDatum();
                ((FixedDatum)anX).unmarshal(dis);
                this.fixedDatums.add((FixedDatum)anX);
                ++idx;
            }
            idx = 0;
            while ((long)idx < this.numberOfVariableDatumRecords) {
                anX = new VariableDatum();
                ((VariableDatum)anX).unmarshal(dis);
                this.variableDatums.add((VariableDatum)anX);
                ++idx;
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public void marshal(ByteBuffer buff) {
        int idx;
        super.marshal(buff);
        buff.putInt((int)this.eventType);
        buff.putInt((int)this.padding1);
        buff.putInt(this.fixedDatums.size());
        buff.putInt(this.variableDatums.size());
        for (idx = 0; idx < this.fixedDatums.size(); ++idx) {
            FixedDatum aFixedDatum = this.fixedDatums.get(idx);
            aFixedDatum.marshal(buff);
        }
        for (idx = 0; idx < this.variableDatums.size(); ++idx) {
            VariableDatum aVariableDatum = this.variableDatums.get(idx);
            aVariableDatum.marshal(buff);
        }
    }

    @Override
    public void unmarshal(ByteBuffer buff) {
        Serializable anX;
        super.unmarshal(buff);
        this.eventType = buff.getInt();
        this.padding1 = buff.getInt();
        this.numberOfFixedDatumRecords = buff.getInt();
        this.numberOfVariableDatumRecords = buff.getInt();
        int idx = 0;
        while ((long)idx < this.numberOfFixedDatumRecords) {
            anX = new FixedDatum();
            ((FixedDatum)anX).unmarshal(buff);
            this.fixedDatums.add((FixedDatum)anX);
            ++idx;
        }
        idx = 0;
        while ((long)idx < this.numberOfVariableDatumRecords) {
            anX = new VariableDatum();
            ((VariableDatum)anX).unmarshal(buff);
            this.variableDatums.add((VariableDatum)anX);
            ++idx;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        int idx;
        boolean ivarsEqual = true;
        if (!(obj instanceof EventReportPdu)) {
            return false;
        }
        EventReportPdu rhs = (EventReportPdu)obj;
        if (this.eventType != rhs.eventType) {
            ivarsEqual = false;
        }
        if (this.padding1 != rhs.padding1) {
            ivarsEqual = false;
        }
        if (this.numberOfFixedDatumRecords != rhs.numberOfFixedDatumRecords) {
            ivarsEqual = false;
        }
        if (this.numberOfVariableDatumRecords != rhs.numberOfVariableDatumRecords) {
            ivarsEqual = false;
        }
        for (idx = 0; idx < this.fixedDatums.size(); ++idx) {
            if (this.fixedDatums.get(idx).equals(rhs.fixedDatums.get(idx))) continue;
            ivarsEqual = false;
        }
        for (idx = 0; idx < this.variableDatums.size(); ++idx) {
            if (this.variableDatums.get(idx).equals(rhs.variableDatums.get(idx))) continue;
            ivarsEqual = false;
        }
        return ivarsEqual && super.equalsImpl(rhs);
    }
}

