/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import edu.nps.moves.dis7.EntityType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class Expendable
implements Serializable {
    protected EntityType expendable = new EntityType();
    protected long station;
    protected int quantity;
    protected short expendableStatus;
    protected short padding = 0;

    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize += this.expendable.getMarshalledSize();
        marshalSize += 4;
        marshalSize += 2;
        ++marshalSize;
        return ++marshalSize;
    }

    public void setExpendable(EntityType pExpendable) {
        this.expendable = pExpendable;
    }

    public EntityType getExpendable() {
        return this.expendable;
    }

    public void setStation(long pStation) {
        this.station = pStation;
    }

    public long getStation() {
        return this.station;
    }

    public void setQuantity(int pQuantity) {
        this.quantity = pQuantity;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public void setExpendableStatus(short pExpendableStatus) {
        this.expendableStatus = pExpendableStatus;
    }

    public short getExpendableStatus() {
        return this.expendableStatus;
    }

    public void setPadding(short pPadding) {
        this.padding = pPadding;
    }

    public short getPadding() {
        return this.padding;
    }

    public void marshal(DataOutputStream dos) {
        try {
            this.expendable.marshal(dos);
            dos.writeInt((int)this.station);
            dos.writeShort((short)this.quantity);
            dos.writeByte((byte)this.expendableStatus);
            dos.writeByte((byte)this.padding);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void unmarshal(DataInputStream dis) {
        try {
            this.expendable.unmarshal(dis);
            this.station = dis.readInt();
            this.quantity = dis.readUnsignedShort();
            this.expendableStatus = (short)dis.readUnsignedByte();
            this.padding = (short)dis.readUnsignedByte();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void marshal(ByteBuffer buff) {
        this.expendable.marshal(buff);
        buff.putInt((int)this.station);
        buff.putShort((short)this.quantity);
        buff.put((byte)this.expendableStatus);
        buff.put((byte)this.padding);
    }

    public void unmarshal(ByteBuffer buff) {
        this.expendable.unmarshal(buff);
        this.station = buff.getInt();
        this.quantity = buff.getShort() & 0xFFFF;
        this.expendableStatus = (short)(buff.get() & 0xFF);
        this.padding = (short)(buff.get() & 0xFF);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof Expendable)) {
            return false;
        }
        Expendable rhs = (Expendable)obj;
        if (!this.expendable.equals(rhs.expendable)) {
            ivarsEqual = false;
        }
        if (this.station != rhs.station) {
            ivarsEqual = false;
        }
        if (this.quantity != rhs.quantity) {
            ivarsEqual = false;
        }
        if (this.expendableStatus != rhs.expendableStatus) {
            ivarsEqual = false;
        }
        if (this.padding != rhs.padding) {
            ivarsEqual = false;
        }
        return ivarsEqual;
    }
}

