/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class IFFFundamentalParameterData
implements Serializable {
    protected float erp;
    protected float frequency;
    protected float pgrf;
    protected float pulseWidth;
    protected long burstLength;
    protected short applicableModes;
    protected short[] systemSpecificData = new short[3];

    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize += 4;
        marshalSize += 4;
        marshalSize += 4;
        marshalSize += 4;
        marshalSize += 4;
        ++marshalSize;
        return marshalSize += 3;
    }

    public void setErp(float pErp) {
        this.erp = pErp;
    }

    public float getErp() {
        return this.erp;
    }

    public void setFrequency(float pFrequency) {
        this.frequency = pFrequency;
    }

    public float getFrequency() {
        return this.frequency;
    }

    public void setPgrf(float pPgrf) {
        this.pgrf = pPgrf;
    }

    public float getPgrf() {
        return this.pgrf;
    }

    public void setPulseWidth(float pPulseWidth) {
        this.pulseWidth = pPulseWidth;
    }

    public float getPulseWidth() {
        return this.pulseWidth;
    }

    public void setBurstLength(long pBurstLength) {
        this.burstLength = pBurstLength;
    }

    public long getBurstLength() {
        return this.burstLength;
    }

    public void setApplicableModes(short pApplicableModes) {
        this.applicableModes = pApplicableModes;
    }

    public short getApplicableModes() {
        return this.applicableModes;
    }

    public void setSystemSpecificData(short[] pSystemSpecificData) {
        this.systemSpecificData = pSystemSpecificData;
    }

    public short[] getSystemSpecificData() {
        return this.systemSpecificData;
    }

    public void marshal(DataOutputStream dos) {
        try {
            dos.writeFloat(this.erp);
            dos.writeFloat(this.frequency);
            dos.writeFloat(this.pgrf);
            dos.writeFloat(this.pulseWidth);
            dos.writeInt((int)this.burstLength);
            dos.writeByte((byte)this.applicableModes);
            for (int idx = 0; idx < this.systemSpecificData.length; ++idx) {
                dos.writeByte(this.systemSpecificData[idx]);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void unmarshal(DataInputStream dis) {
        try {
            this.erp = dis.readFloat();
            this.frequency = dis.readFloat();
            this.pgrf = dis.readFloat();
            this.pulseWidth = dis.readFloat();
            this.burstLength = dis.readInt();
            this.applicableModes = (short)dis.readUnsignedByte();
            for (int idx = 0; idx < this.systemSpecificData.length; ++idx) {
                this.systemSpecificData[idx] = dis.readByte();
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void marshal(ByteBuffer buff) {
        buff.putFloat(this.erp);
        buff.putFloat(this.frequency);
        buff.putFloat(this.pgrf);
        buff.putFloat(this.pulseWidth);
        buff.putInt((int)this.burstLength);
        buff.put((byte)this.applicableModes);
        for (int idx = 0; idx < this.systemSpecificData.length; ++idx) {
            buff.put((byte)this.systemSpecificData[idx]);
        }
    }

    public void unmarshal(ByteBuffer buff) {
        this.erp = buff.getFloat();
        this.frequency = buff.getFloat();
        this.pgrf = buff.getFloat();
        this.pulseWidth = buff.getFloat();
        this.burstLength = buff.getInt();
        this.applicableModes = (short)(buff.get() & 0xFF);
        for (int idx = 0; idx < this.systemSpecificData.length; ++idx) {
            this.systemSpecificData[idx] = buff.get();
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof IFFFundamentalParameterData)) {
            return false;
        }
        IFFFundamentalParameterData rhs = (IFFFundamentalParameterData)obj;
        if (this.erp != rhs.erp) {
            ivarsEqual = false;
        }
        if (this.frequency != rhs.frequency) {
            ivarsEqual = false;
        }
        if (this.pgrf != rhs.pgrf) {
            ivarsEqual = false;
        }
        if (this.pulseWidth != rhs.pulseWidth) {
            ivarsEqual = false;
        }
        if (this.burstLength != rhs.burstLength) {
            ivarsEqual = false;
        }
        if (this.applicableModes != rhs.applicableModes) {
            ivarsEqual = false;
        }
        for (int idx = 0; idx < 3; ++idx) {
            if (this.systemSpecificData[idx] == rhs.systemSpecificData[idx]) continue;
            ivarsEqual = false;
        }
        return ivarsEqual;
    }
}

