/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import edu.nps.moves.dis7.EntityID;
import edu.nps.moves.dis7.EventIdentifier;
import edu.nps.moves.dis7.FundamentalOperationalData;
import edu.nps.moves.dis7.SystemIdentifier;
import edu.nps.moves.dis7.Vector3Float;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class IFFLayer1
implements Serializable {
    protected EntityID emittingEntityId = new EntityID();
    protected EventIdentifier eventId = new EventIdentifier();
    protected Vector3Float relativeAntennaLocation = new Vector3Float();
    protected SystemIdentifier systemId = new SystemIdentifier();
    protected short systemDesignator;
    protected short systemSpecificData;
    protected FundamentalOperationalData fundamentalOperationalData = new FundamentalOperationalData();

    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize += this.emittingEntityId.getMarshalledSize();
        marshalSize += this.eventId.getMarshalledSize();
        marshalSize += this.relativeAntennaLocation.getMarshalledSize();
        marshalSize += this.systemId.getMarshalledSize();
        ++marshalSize;
        ++marshalSize;
        return marshalSize += this.fundamentalOperationalData.getMarshalledSize();
    }

    public EntityID getEmittingEntityId() {
        return this.emittingEntityId;
    }

    public void setEmittingEntityId(EntityID emittingEntityId) {
        this.emittingEntityId = emittingEntityId;
    }

    public EventIdentifier getEventId() {
        return this.eventId;
    }

    public void setEventId(EventIdentifier eventId) {
        this.eventId = eventId;
    }

    public Vector3Float getRelativeAntennaLocation() {
        return this.relativeAntennaLocation;
    }

    public void setRelativeAntennaLocation(Vector3Float relativeAntennaLocation) {
        this.relativeAntennaLocation = relativeAntennaLocation;
    }

    public SystemIdentifier getSystemId() {
        return this.systemId;
    }

    public void setSystemId(SystemIdentifier systemId) {
        this.systemId = systemId;
    }

    public short getSystemDesignator() {
        return this.systemDesignator;
    }

    public void setSystemDesignator(short systemDesignator) {
        this.systemDesignator = systemDesignator;
    }

    public short getSystemSpecificData() {
        return this.systemSpecificData;
    }

    public void setSystemSpecificData(short systemSpecificData) {
        this.systemSpecificData = systemSpecificData;
    }

    public FundamentalOperationalData getFundamentalOperationalData() {
        return this.fundamentalOperationalData;
    }

    public void setFundamentalOperationalData(FundamentalOperationalData fundamentalOperationalData) {
        this.fundamentalOperationalData = fundamentalOperationalData;
    }

    public void marshal(DataOutputStream dos) {
        try {
            this.emittingEntityId.marshal(dos);
            this.eventId.marshal(dos);
            this.relativeAntennaLocation.marshal(dos);
            this.systemId.marshal(dos);
            dos.writeByte((byte)this.systemDesignator);
            dos.writeByte((byte)this.systemSpecificData);
            this.fundamentalOperationalData.marshal(dos);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void unmarshal(DataInputStream dis) {
        try {
            this.emittingEntityId.unmarshal(dis);
            this.eventId.unmarshal(dis);
            this.relativeAntennaLocation.unmarshal(dis);
            this.systemId.unmarshal(dis);
            this.systemDesignator = (short)dis.readUnsignedByte();
            this.systemSpecificData = (short)dis.readUnsignedByte();
            this.fundamentalOperationalData.unmarshal(dis);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void marshal(ByteBuffer buff) {
        this.emittingEntityId.marshal(buff);
        this.eventId.marshal(buff);
        this.relativeAntennaLocation.marshal(buff);
        this.systemId.marshal(buff);
        buff.put((byte)this.systemDesignator);
        buff.put((byte)this.systemSpecificData);
        this.fundamentalOperationalData.marshal(buff);
    }

    public void unmarshal(ByteBuffer buff) {
        this.emittingEntityId.unmarshal(buff);
        this.eventId.unmarshal(buff);
        this.relativeAntennaLocation.unmarshal(buff);
        this.systemId.unmarshal(buff);
        this.systemDesignator = buff.get();
        this.systemSpecificData = buff.get();
        this.fundamentalOperationalData.unmarshal(buff);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof IFFLayer1)) {
            return false;
        }
        IFFLayer1 rhs = (IFFLayer1)obj;
        if (!this.emittingEntityId.equals(rhs.emittingEntityId)) {
            ivarsEqual = false;
        }
        if (!this.eventId.equals(rhs.eventId)) {
            ivarsEqual = false;
        }
        if (!this.relativeAntennaLocation.equals(rhs.relativeAntennaLocation)) {
            ivarsEqual = false;
        }
        if (!this.systemId.equals(rhs.systemId)) {
            ivarsEqual = false;
        }
        if (this.systemDesignator != rhs.systemDesignator) {
            ivarsEqual = false;
        }
        if (this.systemSpecificData != rhs.systemSpecificData) {
            ivarsEqual = false;
        }
        if (!this.fundamentalOperationalData.equals(rhs.fundamentalOperationalData)) {
            ivarsEqual = false;
        }
        return ivarsEqual;
    }
}

