/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import edu.nps.moves.dis7.BeamData;
import edu.nps.moves.dis7.IFFFundamentalParameterData;
import edu.nps.moves.dis7.LayerHeader;
import edu.nps.moves.dis7.SecondaryOperationalData;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class IFFLayer2
implements Serializable {
    protected LayerHeader layerHeader = new LayerHeader();
    protected BeamData beamData = new BeamData();
    protected SecondaryOperationalData secondaryOperationalData = new SecondaryOperationalData();
    protected List<IFFFundamentalParameterData> iffFundamentalParameterData = new ArrayList<IFFFundamentalParameterData>();

    public LayerHeader getLayerHeader() {
        return this.layerHeader;
    }

    public void setLayerHeader(LayerHeader layerHeader) {
        this.layerHeader = layerHeader;
    }

    public BeamData getBeamData() {
        return this.beamData;
    }

    public void setBeamData(BeamData beamData) {
        this.beamData = beamData;
    }

    public SecondaryOperationalData getSecondaryOperationalData() {
        return this.secondaryOperationalData;
    }

    public void setSecondaryOperationalData(SecondaryOperationalData secondaryOperationalData) {
        this.secondaryOperationalData = secondaryOperationalData;
    }

    public List<IFFFundamentalParameterData> getIffFundamentalParameterData() {
        return this.iffFundamentalParameterData;
    }

    public void setIffFundamentalParameterData(List<IFFFundamentalParameterData> iffFundamentalParameterData) {
        this.iffFundamentalParameterData = iffFundamentalParameterData;
    }

    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize += this.layerHeader.getMarshalledSize();
        marshalSize += this.beamData.getMarshalledSize();
        marshalSize += this.secondaryOperationalData.getMarshalledSize();
        for (int idx = 0; idx < this.iffFundamentalParameterData.size(); ++idx) {
            marshalSize += this.iffFundamentalParameterData.get(idx).getMarshalledSize();
        }
        return marshalSize;
    }

    public void marshal(DataOutputStream dos) {
        try {
            this.updateLayerHeader();
            this.layerHeader.marshal(dos);
            this.beamData.marshal(dos);
            this.updateIffFundamentalParameterRecordNumber();
            this.secondaryOperationalData.marshal(dos);
            for (int idx = 0; idx < this.iffFundamentalParameterData.size(); ++idx) {
                this.iffFundamentalParameterData.get(idx).marshal(dos);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void unmarshal(DataInputStream dis) {
        try {
            this.layerHeader.unmarshal(dis);
            this.beamData.unmarshal(dis);
            this.secondaryOperationalData.unmarshal(dis);
            for (int idx = 0; idx < this.secondaryOperationalData.getNumberOfIFFFundamentalParameterRecords(); ++idx) {
                IFFFundamentalParameterData paramData = new IFFFundamentalParameterData();
                paramData.unmarshal(dis);
                this.iffFundamentalParameterData.add(paramData);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void marshal(ByteBuffer buff) {
        this.updateLayerHeader();
        this.layerHeader.marshal(buff);
        this.beamData.marshal(buff);
        this.updateIffFundamentalParameterRecordNumber();
        this.secondaryOperationalData.marshal(buff);
        for (int idx = 0; idx < this.iffFundamentalParameterData.size(); ++idx) {
            this.iffFundamentalParameterData.get(idx).marshal(buff);
        }
    }

    private void updateLayerHeader() {
        this.layerHeader.setLayerNumber((short)2);
        this.layerHeader.setLength(this.getMarshalledSize());
    }

    private void updateIffFundamentalParameterRecordNumber() {
        this.secondaryOperationalData.setNumberOfIFFFundamentalParameterRecords(this.iffFundamentalParameterData.size());
    }

    public void unmarshal(ByteBuffer buff) {
        this.layerHeader.unmarshal(buff);
        this.beamData.unmarshal(buff);
        this.secondaryOperationalData.unmarshal(buff);
        for (int idx = 0; idx < this.secondaryOperationalData.getNumberOfIFFFundamentalParameterRecords(); ++idx) {
            IFFFundamentalParameterData paramData = new IFFFundamentalParameterData();
            paramData.unmarshal(buff);
            this.iffFundamentalParameterData.add(paramData);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof IFFLayer2)) {
            return false;
        }
        IFFLayer2 rhs = (IFFLayer2)obj;
        if (!this.layerHeader.equals(rhs.layerHeader)) {
            ivarsEqual = false;
        }
        if (!this.beamData.equals(rhs.beamData)) {
            ivarsEqual = false;
        }
        if (!this.secondaryOperationalData.equals(rhs.secondaryOperationalData)) {
            ivarsEqual = false;
        }
        for (int idx = 0; idx < this.iffFundamentalParameterData.size(); ++idx) {
            if (this.iffFundamentalParameterData.get(idx).equals(rhs.iffFundamentalParameterData.get(idx))) continue;
            ivarsEqual = false;
        }
        return ivarsEqual;
    }
}

