/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import edu.nps.moves.dis7.CommunicationsNodeID;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class IOCommunicationsNode
implements Serializable {
    protected long recordType = 5501L;
    protected int recordLength = 16;
    protected short communcationsNodeType;
    protected short padding;
    protected CommunicationsNodeID communicationsNodeID = new CommunicationsNodeID();

    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize += 4;
        marshalSize += 2;
        ++marshalSize;
        ++marshalSize;
        return marshalSize += this.communicationsNodeID.getMarshalledSize();
    }

    public void setRecordType(long pRecordType) {
        this.recordType = pRecordType;
    }

    public long getRecordType() {
        return this.recordType;
    }

    public void setRecordLength(int pRecordLength) {
        this.recordLength = pRecordLength;
    }

    public int getRecordLength() {
        return this.recordLength;
    }

    public void setCommuncationsNodeType(short pCommuncationsNodeType) {
        this.communcationsNodeType = pCommuncationsNodeType;
    }

    public short getCommuncationsNodeType() {
        return this.communcationsNodeType;
    }

    public void setPadding(short pPadding) {
        this.padding = pPadding;
    }

    public short getPadding() {
        return this.padding;
    }

    public void setCommunicationsNodeID(CommunicationsNodeID pCommunicationsNodeID) {
        this.communicationsNodeID = pCommunicationsNodeID;
    }

    public CommunicationsNodeID getCommunicationsNodeID() {
        return this.communicationsNodeID;
    }

    public void marshal(DataOutputStream dos) {
        try {
            dos.writeInt((int)this.recordType);
            dos.writeShort((short)this.recordLength);
            dos.writeByte((byte)this.communcationsNodeType);
            dos.writeByte((byte)this.padding);
            this.communicationsNodeID.marshal(dos);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void unmarshal(DataInputStream dis) {
        try {
            this.recordType = dis.readInt();
            this.recordLength = dis.readUnsignedShort();
            this.communcationsNodeType = (short)dis.readUnsignedByte();
            this.padding = (short)dis.readUnsignedByte();
            this.communicationsNodeID.unmarshal(dis);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void marshal(ByteBuffer buff) {
        buff.putInt((int)this.recordType);
        buff.putShort((short)this.recordLength);
        buff.put((byte)this.communcationsNodeType);
        buff.put((byte)this.padding);
        this.communicationsNodeID.marshal(buff);
    }

    public void unmarshal(ByteBuffer buff) {
        this.recordType = buff.getInt();
        this.recordLength = buff.getShort() & 0xFFFF;
        this.communcationsNodeType = (short)(buff.get() & 0xFF);
        this.padding = (short)(buff.get() & 0xFF);
        this.communicationsNodeID.unmarshal(buff);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof IOCommunicationsNode)) {
            return false;
        }
        IOCommunicationsNode rhs = (IOCommunicationsNode)obj;
        if (this.recordType != rhs.recordType) {
            ivarsEqual = false;
        }
        if (this.recordLength != rhs.recordLength) {
            ivarsEqual = false;
        }
        if (this.communcationsNodeType != rhs.communcationsNodeType) {
            ivarsEqual = false;
        }
        if (this.padding != rhs.padding) {
            ivarsEqual = false;
        }
        if (!this.communicationsNodeID.equals(rhs.communicationsNodeID)) {
            ivarsEqual = false;
        }
        return ivarsEqual;
    }
}

