/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import edu.nps.moves.dis7.IFFData;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class IffDataSpecification
implements Serializable {
    protected int numberOfIffDataRecords;
    protected List<IFFData> iffDataRecords = new ArrayList<IFFData>();

    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize += 2;
        for (int idx = 0; idx < this.iffDataRecords.size(); ++idx) {
            IFFData listElement = this.iffDataRecords.get(idx);
            marshalSize += listElement.getMarshalledSize();
        }
        return marshalSize;
    }

    public int getNumberOfIffDataRecords() {
        return this.iffDataRecords.size();
    }

    public void setNumberOfIffDataRecords(int pNumberOfIffDataRecords) {
        this.numberOfIffDataRecords = pNumberOfIffDataRecords;
    }

    public void setIffDataRecords(List<IFFData> pIffDataRecords) {
        this.iffDataRecords = pIffDataRecords;
    }

    public List<IFFData> getIffDataRecords() {
        return this.iffDataRecords;
    }

    public void marshal(DataOutputStream dos) {
        try {
            dos.writeShort((short)this.iffDataRecords.size());
            for (int idx = 0; idx < this.iffDataRecords.size(); ++idx) {
                IFFData aIFFData = this.iffDataRecords.get(idx);
                aIFFData.marshal(dos);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void unmarshal(DataInputStream dis) {
        try {
            this.numberOfIffDataRecords = dis.readUnsignedShort();
            for (int idx = 0; idx < this.numberOfIffDataRecords; ++idx) {
                IFFData anX = new IFFData();
                anX.unmarshal(dis);
                this.iffDataRecords.add(anX);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void marshal(ByteBuffer buff) {
        buff.putShort((short)this.iffDataRecords.size());
        for (int idx = 0; idx < this.iffDataRecords.size(); ++idx) {
            IFFData aIFFData = this.iffDataRecords.get(idx);
            aIFFData.marshal(buff);
        }
    }

    public void unmarshal(ByteBuffer buff) {
        this.numberOfIffDataRecords = buff.getShort() & 0xFFFF;
        for (int idx = 0; idx < this.numberOfIffDataRecords; ++idx) {
            IFFData anX = new IFFData();
            anX.unmarshal(buff);
            this.iffDataRecords.add(anX);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof IffDataSpecification)) {
            return false;
        }
        IffDataSpecification rhs = (IffDataSpecification)obj;
        if (this.numberOfIffDataRecords != rhs.numberOfIffDataRecords) {
            ivarsEqual = false;
        }
        for (int idx = 0; idx < this.iffDataRecords.size(); ++idx) {
            if (this.iffDataRecords.get(idx).equals(rhs.iffDataRecords.get(idx))) continue;
            ivarsEqual = false;
        }
        return ivarsEqual;
    }
}

