/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class IntercomIdentifier
implements Serializable {
    protected int siteNumber;
    protected int applicationNumber;
    protected int referenceNumber;
    protected int intercomNumber;

    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize += 2;
        marshalSize += 2;
        marshalSize += 2;
        return marshalSize += 2;
    }

    public void setSiteNumber(int pSiteNumber) {
        this.siteNumber = pSiteNumber;
    }

    public int getSiteNumber() {
        return this.siteNumber;
    }

    public void setApplicationNumber(int pApplicationNumber) {
        this.applicationNumber = pApplicationNumber;
    }

    public int getApplicationNumber() {
        return this.applicationNumber;
    }

    public void setReferenceNumber(int pReferenceNumber) {
        this.referenceNumber = pReferenceNumber;
    }

    public int getReferenceNumber() {
        return this.referenceNumber;
    }

    public void setIntercomNumber(int pIntercomNumber) {
        this.intercomNumber = pIntercomNumber;
    }

    public int getIntercomNumber() {
        return this.intercomNumber;
    }

    public void marshal(DataOutputStream dos) {
        try {
            dos.writeShort((short)this.siteNumber);
            dos.writeShort((short)this.applicationNumber);
            dos.writeShort((short)this.referenceNumber);
            dos.writeShort((short)this.intercomNumber);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void unmarshal(DataInputStream dis) {
        try {
            this.siteNumber = dis.readUnsignedShort();
            this.applicationNumber = dis.readUnsignedShort();
            this.referenceNumber = dis.readUnsignedShort();
            this.intercomNumber = dis.readUnsignedShort();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void marshal(ByteBuffer buff) {
        buff.putShort((short)this.siteNumber);
        buff.putShort((short)this.applicationNumber);
        buff.putShort((short)this.referenceNumber);
        buff.putShort((short)this.intercomNumber);
    }

    public void unmarshal(ByteBuffer buff) {
        this.siteNumber = buff.getShort() & 0xFFFF;
        this.applicationNumber = buff.getShort() & 0xFFFF;
        this.referenceNumber = buff.getShort() & 0xFFFF;
        this.intercomNumber = buff.getShort() & 0xFFFF;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof IntercomIdentifier)) {
            return false;
        }
        IntercomIdentifier rhs = (IntercomIdentifier)obj;
        if (this.siteNumber != rhs.siteNumber) {
            ivarsEqual = false;
        }
        if (this.applicationNumber != rhs.applicationNumber) {
            ivarsEqual = false;
        }
        if (this.referenceNumber != rhs.referenceNumber) {
            ivarsEqual = false;
        }
        if (this.intercomNumber != rhs.intercomNumber) {
            ivarsEqual = false;
        }
        return ivarsEqual;
    }
}

