/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import edu.nps.moves.dis7.EntityID;
import edu.nps.moves.dis7.RadioCommunicationsFamilyPdu;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class IntercomSignalPdu
extends RadioCommunicationsFamilyPdu
implements Serializable {
    protected EntityID entityID = new EntityID();
    protected int communicationsDeviceID;
    protected int encodingScheme;
    protected int tdlType;
    protected long sampleRate;
    protected int dataLength;
    protected int samples;
    protected byte[] data = new byte[0];

    public IntercomSignalPdu() {
        this.setPduType((short)31);
    }

    @Override
    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize = super.getMarshalledSize();
        marshalSize += this.entityID.getMarshalledSize();
        marshalSize += 2;
        marshalSize += 2;
        marshalSize += 2;
        marshalSize += 4;
        marshalSize += 2;
        marshalSize += 2;
        marshalSize += this.data.length;
        switch (this.data.length % 4) {
            case 0: {
                break;
            }
            case 1: {
                marshalSize += 3;
                break;
            }
            case 2: {
                marshalSize += 2;
                break;
            }
            case 3: {
                ++marshalSize;
            }
        }
        return marshalSize;
    }

    public void setEntityID(EntityID pEntityID) {
        this.entityID = pEntityID;
    }

    public EntityID getEntityID() {
        return this.entityID;
    }

    public void setCommunicationsDeviceID(int pCommunicationsDeviceID) {
        this.communicationsDeviceID = pCommunicationsDeviceID;
    }

    public int getCommunicationsDeviceID() {
        return this.communicationsDeviceID;
    }

    public void setEncodingScheme(int pEncodingScheme) {
        this.encodingScheme = pEncodingScheme;
    }

    public int getEncodingScheme() {
        return this.encodingScheme;
    }

    public void setTdlType(int pTdlType) {
        this.tdlType = pTdlType;
    }

    public int getTdlType() {
        return this.tdlType;
    }

    public void setSampleRate(long pSampleRate) {
        this.sampleRate = pSampleRate;
    }

    public long getSampleRate() {
        return this.sampleRate;
    }

    public short getDataLength() {
        if (this.dataLength == 0) {
            return (short)(this.data.length * 8);
        }
        return (short)this.dataLength;
    }

    public void setDataLength(int pDataLength) {
        this.dataLength = pDataLength;
    }

    public void setSamples(int pSamples) {
        this.samples = pSamples;
    }

    public int getSamples() {
        return this.samples;
    }

    public void setData(byte[] pData) {
        this.data = pData;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    public void marshal(DataOutputStream dos) {
        super.marshal(dos);
        try {
            this.entityID.marshal(dos);
            dos.writeShort((short)this.communicationsDeviceID);
            dos.writeShort((short)this.encodingScheme);
            dos.writeShort((short)this.tdlType);
            dos.writeInt((int)this.sampleRate);
            dos.writeShort((short)this.dataLength);
            dos.writeShort((short)this.samples);
            dos.write(this.data);
            int nrOfBytes = this.dataLength / 8;
            int paddingBytes = nrOfBytes % 4;
            switch (paddingBytes) {
                case 0: {
                    break;
                }
                case 1: {
                    dos.write(0);
                    dos.writeShort(0);
                    break;
                }
                case 2: {
                    dos.writeShort(0);
                    break;
                }
                case 3: {
                    dos.write(0);
                }
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public void unmarshal(DataInputStream dis) {
        super.unmarshal(dis);
        try {
            this.entityID.unmarshal(dis);
            this.communicationsDeviceID = dis.readUnsignedShort();
            this.encodingScheme = dis.readUnsignedShort();
            this.tdlType = dis.readUnsignedShort();
            this.sampleRate = dis.readInt();
            this.dataLength = dis.readUnsignedShort();
            this.samples = dis.readUnsignedShort();
            this.data = new byte[this.dataLength / 8];
            dis.read(this.data);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public void marshal(ByteBuffer buff) {
        super.marshal(buff);
        this.entityID.marshal(buff);
        buff.putShort((short)this.communicationsDeviceID);
        buff.putShort((short)this.encodingScheme);
        buff.putShort((short)this.tdlType);
        buff.putInt((int)this.sampleRate);
        buff.putShort((short)this.dataLength);
        buff.putShort((short)this.samples);
        buff.put(this.data);
        int nrOfBytes = this.dataLength / 8;
        int paddingBytes = nrOfBytes % 4;
        switch (paddingBytes) {
            case 0: {
                break;
            }
            case 1: {
                buff.put((byte)0);
                buff.putShort((short)0);
                break;
            }
            case 2: {
                buff.putShort((short)0);
                break;
            }
            case 3: {
                buff.put((byte)0);
            }
        }
    }

    @Override
    public void unmarshal(ByteBuffer buff) {
        super.unmarshal(buff);
        this.entityID.unmarshal(buff);
        this.communicationsDeviceID = buff.getShort() & 0xFFFF;
        this.encodingScheme = buff.getShort() & 0xFFFF;
        this.tdlType = buff.getShort() & 0xFFFF;
        this.sampleRate = buff.getInt();
        this.dataLength = buff.getShort() & 0xFFFF;
        this.samples = buff.getShort() & 0xFFFF;
        this.data = new byte[this.dataLength / 8];
        buff.get(this.data);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof IntercomSignalPdu)) {
            return false;
        }
        IntercomSignalPdu rhs = (IntercomSignalPdu)obj;
        if (!this.entityID.equals(rhs.entityID)) {
            ivarsEqual = false;
        }
        if (this.communicationsDeviceID != rhs.communicationsDeviceID) {
            ivarsEqual = false;
        }
        if (this.encodingScheme != rhs.encodingScheme) {
            ivarsEqual = false;
        }
        if (this.tdlType != rhs.tdlType) {
            ivarsEqual = false;
        }
        if (this.sampleRate != rhs.sampleRate) {
            ivarsEqual = false;
        }
        if (this.dataLength != rhs.dataLength) {
            ivarsEqual = false;
        }
        if (this.samples != rhs.samples) {
            ivarsEqual = false;
        }
        if (!Arrays.equals(this.data, rhs.data)) {
            ivarsEqual = false;
        }
        return ivarsEqual && super.equalsImpl(rhs);
    }
}

