/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class LayerHeader
implements Serializable {
    protected short layerNumber;
    protected short layerSpecificInformation;
    protected int length;

    public int getMarshalledSize() {
        int marshalSize = 0;
        ++marshalSize;
        ++marshalSize;
        return marshalSize += 2;
    }

    public void setLayerNumber(short pLayerNumber) {
        this.layerNumber = pLayerNumber;
    }

    public short getLayerNumber() {
        return this.layerNumber;
    }

    public void setLayerSpecificInformation(short pLayerSpecificInformation) {
        this.layerSpecificInformation = pLayerSpecificInformation;
    }

    public short getLayerSpecificInformation() {
        return this.layerSpecificInformation;
    }

    public void setLength(int pLength) {
        this.length = pLength;
    }

    public int getLength() {
        return this.length;
    }

    public void marshal(DataOutputStream dos) {
        try {
            dos.writeByte((byte)this.layerNumber);
            dos.writeByte((byte)this.layerSpecificInformation);
            dos.writeShort((short)this.length);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void unmarshal(DataInputStream dis) {
        try {
            this.layerNumber = (short)dis.readUnsignedByte();
            this.layerSpecificInformation = (short)dis.readUnsignedByte();
            this.length = dis.readUnsignedShort();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void marshal(ByteBuffer buff) {
        buff.put((byte)this.layerNumber);
        buff.put((byte)this.layerSpecificInformation);
        buff.putShort((short)this.length);
    }

    public void unmarshal(ByteBuffer buff) {
        this.layerNumber = (short)(buff.get() & 0xFF);
        this.layerSpecificInformation = (short)(buff.get() & 0xFF);
        this.length = buff.getShort() & 0xFFFF;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof LayerHeader)) {
            return false;
        }
        LayerHeader rhs = (LayerHeader)obj;
        if (this.layerNumber != rhs.layerNumber) {
            ivarsEqual = false;
        }
        if (this.layerSpecificInformation != rhs.layerSpecificInformation) {
            ivarsEqual = false;
        }
        if (this.length != rhs.length) {
            ivarsEqual = false;
        }
        return ivarsEqual;
    }
}

