/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import edu.nps.moves.dis7.EulerAngles;
import edu.nps.moves.dis7.Vector3Double;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class LinearSegmentParameter
implements Serializable {
    protected short segmentNumber;
    protected short segmentModification;
    protected int generalSegmentAppearance;
    protected long specificSegmentAppearance;
    protected Vector3Double segmentLocation = new Vector3Double();
    protected EulerAngles segmentOrientation = new EulerAngles();
    protected float segmentLength;
    protected float segmentWidth;
    protected float segmentHeight;
    protected float segmentDepth;
    protected long padding;

    public int getMarshalledSize() {
        int marshalSize = 0;
        ++marshalSize;
        ++marshalSize;
        marshalSize += 2;
        marshalSize += 4;
        marshalSize += this.segmentLocation.getMarshalledSize();
        marshalSize += this.segmentOrientation.getMarshalledSize();
        marshalSize += 4;
        marshalSize += 4;
        marshalSize += 4;
        marshalSize += 4;
        return marshalSize += 4;
    }

    public void setSegmentNumber(short pSegmentNumber) {
        this.segmentNumber = pSegmentNumber;
    }

    public short getSegmentNumber() {
        return this.segmentNumber;
    }

    public void setSegmentModification(short pSegmentModification) {
        this.segmentModification = pSegmentModification;
    }

    public short getSegmentModification() {
        return this.segmentModification;
    }

    public void setGeneralSegmentAppearance(int pGeneralSegmentAppearance) {
        this.generalSegmentAppearance = pGeneralSegmentAppearance;
    }

    public int getGeneralSegmentAppearance() {
        return this.generalSegmentAppearance;
    }

    public void setSpecificSegmentAppearance(long pSpecificSegmentAppearance) {
        this.specificSegmentAppearance = pSpecificSegmentAppearance;
    }

    public long getSpecificSegmentAppearance() {
        return this.specificSegmentAppearance;
    }

    public void setSegmentLocation(Vector3Double pSegmentLocation) {
        this.segmentLocation = pSegmentLocation;
    }

    public Vector3Double getSegmentLocation() {
        return this.segmentLocation;
    }

    public void setSegmentOrientation(EulerAngles pSegmentOrientation) {
        this.segmentOrientation = pSegmentOrientation;
    }

    public EulerAngles getSegmentOrientation() {
        return this.segmentOrientation;
    }

    public void setSegmentLength(float pSegmentLength) {
        this.segmentLength = pSegmentLength;
    }

    public float getSegmentLength() {
        return this.segmentLength;
    }

    public void setSegmentWidth(float pSegmentWidth) {
        this.segmentWidth = pSegmentWidth;
    }

    public float getSegmentWidth() {
        return this.segmentWidth;
    }

    public void setSegmentHeight(float pSegmentHeight) {
        this.segmentHeight = pSegmentHeight;
    }

    public float getSegmentHeight() {
        return this.segmentHeight;
    }

    public void setSegmentDepth(float pSegmentDepth) {
        this.segmentDepth = pSegmentDepth;
    }

    public float getSegmentDepth() {
        return this.segmentDepth;
    }

    public void setPadding(long pPadding) {
        this.padding = pPadding;
    }

    public long getPadding() {
        return this.padding;
    }

    public void marshal(DataOutputStream dos) {
        try {
            dos.writeByte((byte)this.segmentNumber);
            dos.writeByte((byte)this.segmentModification);
            dos.writeShort((short)this.generalSegmentAppearance);
            dos.writeInt((int)this.specificSegmentAppearance);
            this.segmentLocation.marshal(dos);
            this.segmentOrientation.marshal(dos);
            dos.writeFloat(this.segmentLength);
            dos.writeFloat(this.segmentWidth);
            dos.writeFloat(this.segmentHeight);
            dos.writeFloat(this.segmentDepth);
            dos.writeInt((int)this.padding);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void unmarshal(DataInputStream dis) {
        try {
            this.segmentNumber = (short)dis.readUnsignedByte();
            this.segmentModification = (short)dis.readUnsignedByte();
            this.generalSegmentAppearance = dis.readUnsignedShort();
            this.specificSegmentAppearance = dis.readInt();
            this.segmentLocation.unmarshal(dis);
            this.segmentOrientation.unmarshal(dis);
            this.segmentLength = dis.readFloat();
            this.segmentWidth = dis.readFloat();
            this.segmentHeight = dis.readFloat();
            this.segmentDepth = dis.readFloat();
            this.padding = dis.readInt();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void marshal(ByteBuffer buff) {
        buff.put((byte)this.segmentNumber);
        buff.put((byte)this.segmentModification);
        buff.putShort((short)this.generalSegmentAppearance);
        buff.putInt((int)this.specificSegmentAppearance);
        this.segmentLocation.marshal(buff);
        this.segmentOrientation.marshal(buff);
        buff.putFloat(this.segmentLength);
        buff.putFloat(this.segmentWidth);
        buff.putFloat(this.segmentHeight);
        buff.putFloat(this.segmentDepth);
        buff.putInt((int)this.padding);
    }

    public void unmarshal(ByteBuffer buff) {
        this.segmentNumber = (short)(buff.get() & 0xFF);
        this.segmentModification = (short)(buff.get() & 0xFF);
        this.generalSegmentAppearance = buff.getShort() & 0xFFFF;
        this.specificSegmentAppearance = buff.getInt();
        this.segmentLocation.unmarshal(buff);
        this.segmentOrientation.unmarshal(buff);
        this.segmentLength = buff.getFloat();
        this.segmentWidth = buff.getFloat();
        this.segmentHeight = buff.getFloat();
        this.segmentDepth = buff.getFloat();
        this.padding = buff.getInt();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof LinearSegmentParameter)) {
            return false;
        }
        LinearSegmentParameter rhs = (LinearSegmentParameter)obj;
        if (this.segmentNumber != rhs.segmentNumber) {
            ivarsEqual = false;
        }
        if (this.segmentModification != rhs.segmentModification) {
            ivarsEqual = false;
        }
        if (this.generalSegmentAppearance != rhs.generalSegmentAppearance) {
            ivarsEqual = false;
        }
        if (this.specificSegmentAppearance != rhs.specificSegmentAppearance) {
            ivarsEqual = false;
        }
        if (!this.segmentLocation.equals(rhs.segmentLocation)) {
            ivarsEqual = false;
        }
        if (!this.segmentOrientation.equals(rhs.segmentOrientation)) {
            ivarsEqual = false;
        }
        if (this.segmentLength != rhs.segmentLength) {
            ivarsEqual = false;
        }
        if (this.segmentWidth != rhs.segmentWidth) {
            ivarsEqual = false;
        }
        if (this.segmentHeight != rhs.segmentHeight) {
            ivarsEqual = false;
        }
        if (this.segmentDepth != rhs.segmentDepth) {
            ivarsEqual = false;
        }
        if (this.padding != rhs.padding) {
            ivarsEqual = false;
        }
        return ivarsEqual;
    }
}

