/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import edu.nps.moves.dis7.LiveSimulationAddress;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class LiveEntityIdentifier
implements Serializable {
    protected LiveSimulationAddress liveSimulationAddress = new LiveSimulationAddress();
    protected int entityNumber;

    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize += this.liveSimulationAddress.getMarshalledSize();
        return marshalSize += 2;
    }

    public void setLiveSimulationAddress(LiveSimulationAddress pLiveSimulationAddress) {
        this.liveSimulationAddress = pLiveSimulationAddress;
    }

    public LiveSimulationAddress getLiveSimulationAddress() {
        return this.liveSimulationAddress;
    }

    public void setEntityNumber(int pEntityNumber) {
        this.entityNumber = pEntityNumber;
    }

    public int getEntityNumber() {
        return this.entityNumber;
    }

    public void marshal(DataOutputStream dos) {
        try {
            this.liveSimulationAddress.marshal(dos);
            dos.writeShort((short)this.entityNumber);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void unmarshal(DataInputStream dis) {
        try {
            this.liveSimulationAddress.unmarshal(dis);
            this.entityNumber = dis.readUnsignedShort();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void marshal(ByteBuffer buff) {
        this.liveSimulationAddress.marshal(buff);
        buff.putShort((short)this.entityNumber);
    }

    public void unmarshal(ByteBuffer buff) {
        this.liveSimulationAddress.unmarshal(buff);
        this.entityNumber = buff.getShort() & 0xFFFF;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof LiveEntityIdentifier)) {
            return false;
        }
        LiveEntityIdentifier rhs = (LiveEntityIdentifier)obj;
        if (!this.liveSimulationAddress.equals(rhs.liveSimulationAddress)) {
            ivarsEqual = false;
        }
        if (this.entityNumber != rhs.entityNumber) {
            ivarsEqual = false;
        }
        return ivarsEqual;
    }
}

