/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import edu.nps.moves.dis7.SimulationAddress;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class MinefieldIdentifier
implements Serializable {
    protected SimulationAddress simulationAddress = new SimulationAddress();
    protected int minefieldNumber;

    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize += this.simulationAddress.getMarshalledSize();
        return marshalSize += 2;
    }

    public void setSimulationAddress(SimulationAddress pSimulationAddress) {
        this.simulationAddress = pSimulationAddress;
    }

    public SimulationAddress getSimulationAddress() {
        return this.simulationAddress;
    }

    public void setMinefieldNumber(int pMinefieldNumber) {
        this.minefieldNumber = pMinefieldNumber;
    }

    public int getMinefieldNumber() {
        return this.minefieldNumber;
    }

    public void marshal(DataOutputStream dos) {
        try {
            this.simulationAddress.marshal(dos);
            dos.writeShort((short)this.minefieldNumber);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void unmarshal(DataInputStream dis) {
        try {
            this.simulationAddress.unmarshal(dis);
            this.minefieldNumber = dis.readUnsignedShort();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void marshal(ByteBuffer buff) {
        this.simulationAddress.marshal(buff);
        buff.putShort((short)this.minefieldNumber);
    }

    public void unmarshal(ByteBuffer buff) {
        this.simulationAddress.unmarshal(buff);
        this.minefieldNumber = buff.getShort() & 0xFFFF;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof MinefieldIdentifier)) {
            return false;
        }
        MinefieldIdentifier rhs = (MinefieldIdentifier)obj;
        if (!this.simulationAddress.equals(rhs.simulationAddress)) {
            ivarsEqual = false;
        }
        if (this.minefieldNumber != rhs.minefieldNumber) {
            ivarsEqual = false;
        }
        return ivarsEqual;
    }
}

