/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import edu.nps.moves.dis7.EntityType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class Munition
implements Serializable {
    protected EntityType munitionType = new EntityType();
    protected long station;
    protected int quantity;
    protected short munitionStatus;
    protected short padding = 0;

    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize += this.munitionType.getMarshalledSize();
        marshalSize += 4;
        marshalSize += 2;
        ++marshalSize;
        return ++marshalSize;
    }

    public void setMunitionType(EntityType pMunitionType) {
        this.munitionType = pMunitionType;
    }

    public EntityType getMunitionType() {
        return this.munitionType;
    }

    public void setStation(long pStation) {
        this.station = pStation;
    }

    public long getStation() {
        return this.station;
    }

    public void setQuantity(int pQuantity) {
        this.quantity = pQuantity;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public void setMunitionStatus(short pMunitionStatus) {
        this.munitionStatus = pMunitionStatus;
    }

    public short getMunitionStatus() {
        return this.munitionStatus;
    }

    public void setPadding(short pPadding) {
        this.padding = pPadding;
    }

    public short getPadding() {
        return this.padding;
    }

    public void marshal(DataOutputStream dos) {
        try {
            this.munitionType.marshal(dos);
            dos.writeInt((int)this.station);
            dos.writeShort((short)this.quantity);
            dos.writeByte((byte)this.munitionStatus);
            dos.writeByte((byte)this.padding);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void unmarshal(DataInputStream dis) {
        try {
            this.munitionType.unmarshal(dis);
            this.station = dis.readInt();
            this.quantity = dis.readUnsignedShort();
            this.munitionStatus = (short)dis.readUnsignedByte();
            this.padding = (short)dis.readUnsignedByte();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void marshal(ByteBuffer buff) {
        this.munitionType.marshal(buff);
        buff.putInt((int)this.station);
        buff.putShort((short)this.quantity);
        buff.put((byte)this.munitionStatus);
        buff.put((byte)this.padding);
    }

    public void unmarshal(ByteBuffer buff) {
        this.munitionType.unmarshal(buff);
        this.station = buff.getInt();
        this.quantity = buff.getShort() & 0xFFFF;
        this.munitionStatus = (short)(buff.get() & 0xFF);
        this.padding = (short)(buff.get() & 0xFF);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof Munition)) {
            return false;
        }
        Munition rhs = (Munition)obj;
        if (!this.munitionType.equals(rhs.munitionType)) {
            ivarsEqual = false;
        }
        if (this.station != rhs.station) {
            ivarsEqual = false;
        }
        if (this.quantity != rhs.quantity) {
            ivarsEqual = false;
        }
        if (this.munitionStatus != rhs.munitionStatus) {
            ivarsEqual = false;
        }
        if (this.padding != rhs.padding) {
            ivarsEqual = false;
        }
        return ivarsEqual;
    }
}

